/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.attachment;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.api.sponsor.hierarchy.SponsorHierarchyService;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.propdev.impl.attachment.Narrative;
import org.kuali.coeus.propdev.impl.budget.ProposalBudgetService;
import org.kuali.coeus.propdev.impl.budget.ProposalDevelopmentBudgetExt;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.core.ProposalTypeService;
import org.kuali.coeus.propdev.impl.person.ProposalPerson;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.coreservice.api.parameter.Parameter;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProposalDevelopmentProposalAttachmentsAuditRule
extends KcTransactionalDocumentRuleBase
implements DocumentAuditRule {
    private static final String AUDIT_PARAMETER = "AUDIT_INCOMPLETE_PROPOSAL_ATTACHMENTS";
    private static final String AUDIT_PARAMETER_VALUE_YES = "Y";
    private static final String MODULE_STATUS_CODE_INCOMPLETE = "I";
    private static final Logger LOG = LogManager.getLogger(ProposalDevelopmentProposalAttachmentsAuditRule.class);
    private SponsorHierarchyService sponsorHierarchyService;
    private ParameterService parameterService;
    private ProposalBudgetService proposalBudgetService;
    private ProposalTypeService proposalTypeService;

    public boolean processRunAuditBusinessRules(Document document) {
        boolean valid = true;
        ProposalDevelopmentDocument proposalDevelopmentDocument = (ProposalDevelopmentDocument)document;
        DevelopmentProposal developmentProposal = proposalDevelopmentDocument.getDevelopmentProposal();
        valid &= this.checkForIncompleteAttachments(developmentProposal);
        valid &= this.checkNihRelatedAttachments(developmentProposal);
        valid &= this.checkNsfRelatedAttachments(proposalDevelopmentDocument);
        int i = 0;
        for (Narrative narrative : developmentProposal.getNarratives()) {
            valid &= this.validModuleTitle(narrative, developmentProposal, i++);
        }
        return valid;
    }

    protected boolean validModuleTitle(Narrative narrative, DevelopmentProposal developmentProposal, int index) {
        if (StringUtils.contains((CharSequence)narrative.getModuleTitle(), (int)38) && developmentProposal.hasS2sOpportunity() && narrative.getNarrativeType().isAllowMultiple()) {
            this.getAuditErrors("Proposal Attachments").add(new AuditError(String.format("document.developmentProposal.narratives[%d].moduleTitle", index), "error.proposalAttachment.description.illegalCharacters", "PropDev-AttachmentsPage.PropDev-AttachmentsPage-ProposalSection"));
            return false;
        }
        return true;
    }

    public boolean checkForIncompleteAttachments(DevelopmentProposal developmentProposal) {
        boolean valid = true;
        Parameter attachmentAuditParam = this.getParameterService().getParameter(ProposalDevelopmentDocument.class, AUDIT_PARAMETER);
        if (attachmentAuditParam == null) {
            LOG.warn("System parameter AUDIT_INCOMPLETE_ATTACHMENTS is missing or invalid.");
            return this.alternateIncompleteAttachmentValidation(developmentProposal);
        }
        String validateIncompleteAttachments = attachmentAuditParam.getValue();
        int i = 0;
        for (Narrative narrative : developmentProposal.getNarratives()) {
            if (StringUtils.equals((CharSequence)narrative.getModuleStatusCode(), (CharSequence)MODULE_STATUS_CODE_INCOMPLETE) && validateIncompleteAttachments.equals(AUDIT_PARAMETER_VALUE_YES)) {
                valid &= false;
                this.getAuditErrors("Proposal Attachments").add(new AuditError(String.format("document.developmentProposal.narratives[%d].moduleStatusCode", i), "error.document.narrativestatuscode.not.complete", "PropDev-AttachmentsPage.PropDev-AttachmentsPage-ProposalSection"));
            }
            ++i;
        }
        return valid;
    }

    private boolean alternateIncompleteAttachmentValidation(DevelopmentProposal developmentProposal) {
        boolean valid = true;
        int i = 0;
        for (Narrative narrative : developmentProposal.getNarratives()) {
            if (StringUtils.equals((CharSequence)narrative.getModuleStatusCode(), (CharSequence)MODULE_STATUS_CODE_INCOMPLETE)) {
                valid &= false;
                this.getAuditErrors("Proposal Attachments").add(new AuditError(String.format("document.developmentProposal.narratives[%d].moduleStatusCode", i), "error.document.narrativestatuscode.not.complete", "PropDev-AttachmentsPage.PropDev-AttachmentsPage-ProposalSection"));
            }
            ++i;
        }
        return valid;
    }

    public boolean checkNihRelatedAttachments(DevelopmentProposal developmentProposal) {
        boolean valid = true;
        if (this.getProposalTypeService().isProposalTypeRevisionOrSupplementChangedOrCorrectedProposalTypeCode(developmentProposal.getProposalTypeCode())) {
            return true;
        }
        if (this.getSponsorHierarchyService().isSponsorNihMultiplePi(developmentProposal.getSponsorCode()) && developmentProposal.hasS2sOpportunity()) {
            boolean attachment = false;
            boolean hasPI = false;
            block0: for (ProposalPerson proposalPerson : developmentProposal.getInvestigators()) {
                if (proposalPerson.getProposalPersonRoleId().equals("PI")) {
                    hasPI = true;
                }
                if (!proposalPerson.isMultiplePi()) continue;
                attachment = true;
                for (Narrative narrative : developmentProposal.getNarratives()) {
                    if ((narrative.getNarrativeTypeCode() == null || !StringUtils.equals((CharSequence)narrative.getNarrativeTypeCode(), (CharSequence)"121")) && !StringUtils.equals((CharSequence)narrative.getNarrativeTypeCode(), (CharSequence)"46")) continue;
                    attachment = false;
                    continue block0;
                }
            }
            if (attachment && hasPI) {
                valid = false;
                this.getAuditErrors("").add(new AuditError("document.developmentProposal.narratives", "error.document.narrative.not.present", "PropDev-AttachmentsPage"));
            }
        }
        return valid;
    }

    public boolean checkNsfRelatedAttachments(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        boolean valid = true;
        DevelopmentProposal developmentProposal = proposalDevelopmentDocument.getDevelopmentProposal();
        if (developmentProposal.getSponsorCode().equals(this.getParameterService().getParameterValueAsString("KC-GEN", "All", "NSF_SPONSOR_CODE")) && developmentProposal.hasS2sOpportunity()) {
            boolean attachmentNotExists = true;
            try {
                String budgetCostElement = this.getParameterService().getParameterValueAsString("KC-GEN", "All", "POST_DOCTORAL_COSTELEMENT");
                ProposalDevelopmentBudgetExt budget = this.getProposalBudgetService().getFinalBudgetVersion(proposalDevelopmentDocument);
                if (budget != null && budget.getBudgetPeriods() != null) {
                    block2: for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
                        for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                            if (!budgetLineItem.getCostElement().equals(budgetCostElement)) continue;
                            for (Narrative narrative : developmentProposal.getNarratives()) {
                                if (narrative.getNarrativeTypeCode() == null || Integer.parseInt(narrative.getNarrativeTypeCode()) != 8 || !narrative.getName().equalsIgnoreCase("Mentoring Plan.pdf")) continue;
                                attachmentNotExists = false;
                                break;
                            }
                            if (!attachmentNotExists) continue;
                            valid = false;
                            this.getAuditErrors("").add(new AuditError("document.developmentProposal.narratives", "error.document.mentoringplan.narrative.not.present", "PropDev-AttachmentsPage"));
                            continue block2;
                        }
                    }
                }
            }
            catch (Exception e) {
                LOG.error("Unknown error while validating budget data", (Throwable)e);
            }
        }
        return valid;
    }

    private List<AuditError> getAuditErrors(String sectionName) {
        ArrayList<AuditError> auditErrors = new ArrayList();
        String clusterKey = "Attachments." + sectionName;
        if (!GlobalVariables.getAuditErrorMap().containsKey(clusterKey)) {
            GlobalVariables.getAuditErrorMap().put(clusterKey, new AuditCluster(clusterKey, auditErrors, "Error"));
        } else {
            auditErrors = ((AuditCluster)GlobalVariables.getAuditErrorMap().get(clusterKey)).getAuditErrorList();
        }
        return auditErrors;
    }

    private SponsorHierarchyService getSponsorHierarchyService() {
        if (this.sponsorHierarchyService == null) {
            this.sponsorHierarchyService = KcServiceLocator.getService(SponsorHierarchyService.class);
        }
        return this.sponsorHierarchyService;
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    protected ProposalBudgetService getProposalBudgetService() {
        if (this.proposalBudgetService == null) {
            this.proposalBudgetService = KcServiceLocator.getService(ProposalBudgetService.class);
        }
        return this.proposalBudgetService;
    }

    public ProposalTypeService getProposalTypeService() {
        if (this.proposalTypeService == null) {
            this.proposalTypeService = KcServiceLocator.getService(ProposalTypeService.class);
        }
        return this.proposalTypeService;
    }

    public void setProposalTypeService(ProposalTypeService proposalTypeService) {
        this.proposalTypeService = proposalTypeService;
    }
}

