/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.sponsor;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.api.sponsor.SponsorContract;
import org.kuali.coeus.common.api.sponsor.SponsorService;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProposalDevelopmentSponsorAuditRule
implements DocumentAuditRule {
    private SponsorService sponsorService;

    public boolean processRunAuditBusinessRules(Document document) {
        boolean valid = true;
        ProposalDevelopmentDocument proposalDevelopmentDocument = (ProposalDevelopmentDocument)document;
        if (!this.getSponsorService().isValidSponsor((SponsorContract)proposalDevelopmentDocument.getDevelopmentProposal().getSponsor())) {
            valid = false;
            this.getAuditErrors("Proposal Details", "Error").add(new AuditError("document.developmentProposal.sponsorCode", "warning.proposal.inactive.sponsor", "PropDev-DetailsPage"));
        }
        if (!StringUtils.isEmpty((CharSequence)proposalDevelopmentDocument.getDevelopmentProposal().getPrimeSponsorCode()) && !this.getSponsorService().isValidSponsor((SponsorContract)proposalDevelopmentDocument.getDevelopmentProposal().getPrimeSponsor())) {
            valid = false;
            this.getAuditErrors("Proposal Details", "Error").add(new AuditError("document.developmentProposal.primeSponsorCode", "warning.proposal.inactive.primesponsor", "PropDev-DetailsPage"));
        }
        return valid;
    }

    private List<AuditError> getAuditErrors(String areaName, String severity) {
        ArrayList<AuditError> auditErrors = new ArrayList();
        String clusterKey = areaName;
        if (!GlobalVariables.getAuditErrorMap().containsKey(clusterKey + severity)) {
            GlobalVariables.getAuditErrorMap().put(clusterKey + severity, new AuditCluster(clusterKey, auditErrors, severity));
        } else {
            auditErrors = ((AuditCluster)GlobalVariables.getAuditErrorMap().get(clusterKey + severity)).getAuditErrorList();
        }
        return auditErrors;
    }

    private SponsorService getSponsorService() {
        if (this.sponsorService == null) {
            this.sponsorService = KcServiceLocator.getService(SponsorService.class);
        }
        return this.sponsorService;
    }

    public void setSponsorService(SponsorService sponsorService) {
        this.sponsorService = sponsorService;
    }
}

