/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.negotiations.web.struts.form;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.custom.CustomDataDocumentForm;
import org.kuali.coeus.common.framework.medusa.MedusaBean;
import org.kuali.coeus.common.notification.impl.NotificationHelper;
import org.kuali.coeus.sys.framework.model.KcTransactionalDocumentFormBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.negotiations.bo.Negotiation;
import org.kuali.kra.negotiations.bo.NegotiationActivityHistoryLineBean;
import org.kuali.kra.negotiations.bo.NegotiationAssociatedDetailBean;
import org.kuali.kra.negotiations.bo.NegotiationStatus;
import org.kuali.kra.negotiations.bo.NegotiationUnassociatedDetail;
import org.kuali.kra.negotiations.customdata.CustomDataHelper;
import org.kuali.kra.negotiations.document.NegotiationDocument;
import org.kuali.kra.negotiations.notifications.NegotiationNotification;
import org.kuali.kra.negotiations.notifications.NegotiationNotificationContext;
import org.kuali.kra.negotiations.service.NegotiationService;
import org.kuali.kra.negotiations.web.struts.form.NegotiationActivityHelper;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kns.web.ui.ExtraButton;
import org.kuali.rice.kns.web.ui.HeaderField;
import org.kuali.rice.krad.service.BusinessObjectService;

public class NegotiationForm
extends KcTransactionalDocumentFormBase
implements CustomDataDocumentForm {
    private static final long serialVersionUID = 6245888664423593163L;
    private final String filterAllActivities = "All";
    private final String filterPendingActivities = "Pending";
    private List<NegotiationUnassociatedDetail> negotiationUnassociatedDetailsToDelete;
    private NegotiationActivityHelper negotiationActivityHelper;
    private NegotiationAssociatedDetailBean negotiationAssociatedDetailBean;
    private CustomDataHelper customDataHelper = new CustomDataHelper(this);
    private NotificationHelper<NegotiationNotificationContext> notificationHelper;
    private String filterActivities = "All";
    private MedusaBean medusaBean;

    public NegotiationForm() {
        this.negotiationUnassociatedDetailsToDelete = new ArrayList<NegotiationUnassociatedDetail>();
        this.negotiationActivityHelper = new NegotiationActivityHelper(this);
        this.medusaBean = new MedusaBean();
        this.notificationHelper = new NotificationHelper();
        this.init();
    }

    private void init() {
        this.getCustomDataHelper().prepareCustomData();
    }

    @Override
    public CustomDataHelper getCustomDataHelper() {
        return this.customDataHelper;
    }

    public void setCustomDataHelper(CustomDataHelper customDataHelper) {
        this.customDataHelper = customDataHelper;
    }

    public String getDocumentTypeName() {
        return "NegotiationDocument";
    }

    public NegotiationDocument getNegotiationDocument() {
        return (NegotiationDocument)this.getDocument();
    }

    public List<NegotiationUnassociatedDetail> getNegotiationUnassociatedDetailsToDelete() {
        return this.negotiationUnassociatedDetailsToDelete;
    }

    @Override
    protected String getDefaultDocumentTypeName() {
        return "NegotiationDocument";
    }

    @Override
    protected String getLockRegion() {
        return "NEGOTIATION";
    }

    @Override
    protected void setSaveDocumentControl(Map editMode) {
        this.getDocumentActions().put("canSave", "true");
    }

    public BusinessObjectService getBusinessObjectService() {
        return KcServiceLocator.getService(BusinessObjectService.class);
    }

    public NegotiationService getNegotiationService() {
        return KcServiceLocator.getService(NegotiationService.class);
    }

    private boolean isAssocitationType(String typeCode) {
        if (this.getNegotiationDocument().getNegotiation().getNegotiationAssociationType() != null) {
            return StringUtils.equalsIgnoreCase((CharSequence)typeCode, (CharSequence)this.getNegotiationDocument().getNegotiation().getNegotiationAssociationType().getCode());
        }
        return false;
    }

    public boolean getDisplayUnAssociatedDetail() {
        return this.isAssocitationType("NO");
    }

    public boolean getDisplayProposalLog() {
        return this.isAssocitationType("PL");
    }

    public boolean getDisplayInstitutionalProposal() {
        return this.isAssocitationType("IP");
    }

    public boolean getDisplayAward() {
        return this.isAssocitationType("AWD");
    }

    public boolean getDisplaySubAward() {
        return this.isAssocitationType("SWD");
    }

    public NegotiationActivityHelper getNegotiationActivityHelper() {
        return this.negotiationActivityHelper;
    }

    public void setNegotiationActivityHelper(NegotiationActivityHelper negotiationActivityHelper) {
        this.negotiationActivityHelper = negotiationActivityHelper;
    }

    public boolean getDispayAssociatedDetailPanel() {
        return !this.getDisplayUnAssociatedDetail() && StringUtils.isNotEmpty((CharSequence)this.getNegotiationDocument().getNegotiation().getAssociatedDocumentId());
    }

    public void populateHeaderFields(WorkflowDocument workflowDocument) {
        super.populateHeaderFields(workflowDocument);
        NegotiationDocument nd = this.getNegotiationDocument();
        String ATTRIB_NEG_ID = "DataDictionary.Negotiation.attributes.negotiationId";
        String ATTRIB_NEG_USER_NAME = "DataDictionary.Negotiation.attributes.negotiatorUserName";
        if (nd == null || nd.getNegotiation() == null) {
            this.getDocInfo().add(2, new HeaderField("DataDictionary.Negotiation.attributes.negotiationId", ""));
            this.getDocInfo().add(2, new HeaderField("DataDictionary.Negotiation.attributes.negotiatorUserName", ""));
            return;
        }
        if (nd.getNegotiation().getNegotiationId() == null) {
            this.getDocInfo().add(2, new HeaderField("DataDictionary.Negotiation.attributes.negotiationId", ""));
        } else {
            this.getDocInfo().add(2, new HeaderField("DataDictionary.Negotiation.attributes.negotiationId", nd.getNegotiation().getNegotiationId().toString()));
        }
        if (nd.getNegotiation().getNegotiatorUserName() == null) {
            this.getDocInfo().add(2, new HeaderField("DataDictionary.Negotiation.attributes.negotiatorUserName", ""));
        } else {
            this.getDocInfo().add(2, new HeaderField("DataDictionary.Negotiation.attributes.negotiatorUserName", nd.getNegotiation().getNegotiatorUserName()));
        }
    }

    public NegotiationAssociatedDetailBean getNegotiationAssociatedDetailBean() {
        Negotiation negotiation = this.getNegotiationDocument().getNegotiation();
        if (this.negotiationAssociatedDetailBean == null || !StringUtils.equals((CharSequence)this.negotiationAssociatedDetailBean.getAssociatedDocumentId(), (CharSequence)negotiation.getAssociatedDocumentId())) {
            this.negotiationAssociatedDetailBean = this.getNegotiationService().buildNegotiationAssociatedDetailBean(negotiation);
        }
        return this.negotiationAssociatedDetailBean;
    }

    public String getStatusRelatedJavascript() {
        StringBuffer sb = new StringBuffer(100);
        String newLine = "\n ";
        sb.append("function manageStatusEndDate(doUpdateDate){").append(newLine);
        sb.append("var statusField = document.getElementById('document.negotiationList[0].negotiationStatusId');").append(newLine);
        sb.append("var dateField = document.getElementById('document.negotiationList[0].negotiationEndDate');").append(newLine);
        sb.append("var statusFieldSelectedVal = statusField.options[statusField.selectedIndex].value;").append(newLine);
        sb.append("var dateFieldPicker = document.getElementById('document.negotiationList[0].negotiationEndDate_datepicker');").append(newLine);
        sb.append("if (");
        int currentIndex = 0;
        List<String> completedCodes = this.getNegotiationService().getCompletedStatusCodes();
        for (String currentCode : completedCodes) {
            NegotiationStatus currentStatus = this.getNegotiationStatus(currentCode);
            sb.append("statusFieldSelectedVal == '").append(currentStatus.getId().toString()).append("'");
            if (currentIndex + 1 < completedCodes.size()) {
                sb.append(" || ");
            }
            ++currentIndex;
        }
        sb.append(") {").append(newLine);
        sb.append("  dateField.disabled = false;").append(newLine);
        sb.append("  if (dateField.value == '' && doUpdateDate) {").append(newLine);
        sb.append("    var currentTime = new Date();").append(newLine);
        sb.append("    dateField.value = currentTime.getMonth() + 1 + \"/\" +  currentTime.getDate() + \"/\" + currentTime.getFullYear();").append(newLine);
        sb.append("  dateFieldPicker.style.display='inline';").append(newLine);
        sb.append("  }").append(newLine).append("} else {").append(newLine);
        sb.append("  dateField.disabled = true;").append(newLine).append("  dateField.value = '';").append(newLine);
        sb.append("  dateFieldPicker.style.display='none';").append(newLine);
        sb.append("}").append(newLine).append("}").append(newLine);
        sb.append("manageStatusEndDate(false);");
        return sb.toString();
    }

    private NegotiationStatus getNegotiationStatus(String code) {
        return this.getNegotiationService().getNegotiationStatus(code);
    }

    public MedusaBean getMedusaBean() {
        return this.medusaBean;
    }

    public void setMedusaBean(MedusaBean medusaBean) {
        this.medusaBean = medusaBean;
    }

    public String getFilterActivities() {
        return this.filterActivities;
    }

    public void setFilterActivities(String filterActivities) {
        this.filterActivities = filterActivities;
    }

    public List<NegotiationActivityHistoryLineBean> getNegotiationActivityHistoryLineBeans() {
        return this.getNegotiationService().getNegotiationActivityHistoryLineBeans(this.getNegotiationDocument().getNegotiation().getActivities());
    }

    public List<NegotiationNotification> getNegotiationNotifications() {
        return this.getNegotiationService().getNegotiationNotifications(this.getNegotiationDocument().getNegotiation());
    }

    public NotificationHelper<NegotiationNotificationContext> getNotificationHelper() {
        return this.notificationHelper;
    }

    public void setNotificationHelper(NotificationHelper<NegotiationNotificationContext> notificationHelper) {
        this.notificationHelper = notificationHelper;
    }

    public String getFilterAllActivities() {
        return "All";
    }

    public String getFilterPendingActivities() {
        return "Pending";
    }

    public boolean getDispayChangeAssociatedDocumentWarning() {
        boolean retVal = !StringUtils.isEmpty((CharSequence)this.getNegotiationDocument().getNegotiation().getAssociatedDocumentId());
        return retVal;
    }

    public String getDispayChangeAssociatedDocumentWarningMessage() {
        if (this.getDispayChangeAssociatedDocumentWarning() && this.getNegotiationDocument().getNegotiation().getNegotiationAssociationType() != null) {
            StringBuffer sb = new StringBuffer("<div id=\"searchIconDiv\" style=\"display: inline;\" onclick=\"return confirm('");
            String associatedType = this.getNegotiationDocument().getNegotiation().getNegotiationAssociationType().getDescription();
            String docNumber = this.getNegotiationDocument().getNegotiation().getAssociatedNegotiable().getAssociatedDocumentId();
            sb.append("This Negotiation is already associated with ").append(associatedType).append(" number ").append(docNumber);
            sb.append(".  Selecting a different ").append(associatedType).append(" document will disassociate this Negotiation with ");
            sb.append(docNumber).append(".  Are you sure?").append("')\">");
            return sb.toString();
        }
        return "";
    }

    public String getShortUrl() {
        return this.getBaseShortUrl() + "/kc-common/negotiations/" + this.getNegotiationDocument().getNegotiation().getNegotiationId();
    }

    public List<ExtraButton> getExtraActionsButtons() {
        this.extraButtons.clear();
        String externalImageURL = "kra.externalizable.images.url";
        ConfigurationService configurationService = CoreApiServiceLocator.getKualiConfigurationService();
        String sendNotificationImage = configurationService.getPropertyValueAsString(externalImageURL) + "buttonsmall_send_notification.gif";
        this.addExtraButton("methodToCall.sendNotification", sendNotificationImage, "Send Notification");
        return this.extraButtons;
    }
}

