/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository.mock;

import java.util.HashMap;
import java.util.LinkedHashSet;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.krms.api.repository.term.TermRepositoryService;
import org.kuali.rice.krms.api.repository.term.TermResolverDefinition;
import org.kuali.rice.krms.api.repository.term.TermSpecificationDefinition;
import org.kuali.rice.krms.api.repository.term.TermSpecificationDefinitionContract;

public class KrmsTermResolverLoader {
    private TermRepositoryService termRepositoryService = null;

    public TermRepositoryService getTermRepositoryService() {
        return this.termRepositoryService;
    }

    public void setTermRepositoryService(TermRepositoryService termRepositoryService) {
        this.termRepositoryService = termRepositoryService;
    }

    public void loadTermResolver(String id, String namespace, String name, String typeId, String outputId, String prereqId1, String prereqId2, String prereqId3) {
        TermSpecificationDefinition.Builder output = TermSpecificationDefinition.Builder.create((TermSpecificationDefinitionContract)this.getTermRepositoryService().getTermSpecificationById(outputId));
        LinkedHashSet<TermSpecificationDefinition.Builder> prerequisites = new LinkedHashSet<TermSpecificationDefinition.Builder>();
        if (prereqId1 != null && !prereqId1.isEmpty()) {
            prerequisites.add(TermSpecificationDefinition.Builder.create((TermSpecificationDefinitionContract)this.getTermRepositoryService().getTermSpecificationById(prereqId1)));
        }
        if (prereqId2 != null && !prereqId2.isEmpty()) {
            prerequisites.add(TermSpecificationDefinition.Builder.create((TermSpecificationDefinitionContract)this.getTermRepositoryService().getTermSpecificationById(prereqId2)));
        }
        if (prereqId3 != null && !prereqId3.isEmpty()) {
            prerequisites.add(TermSpecificationDefinition.Builder.create((TermSpecificationDefinitionContract)this.getTermRepositoryService().getTermSpecificationById(prereqId3)));
        }
        HashMap attributes = new HashMap();
        LinkedHashSet parameterNames = new LinkedHashSet();
        TermResolverDefinition.Builder bldr = TermResolverDefinition.Builder.create((String)id, (String)namespace, (String)name, (String)typeId, (TermSpecificationDefinition.Builder)output, prerequisites, attributes, parameterNames);
        bldr.setActive(true);
        TermResolverDefinition existing = this.findExisting(bldr);
        if (existing == null) {
            this.getTermRepositoryService().createTermResolver(bldr.build());
        } else {
            bldr.setVersionNumber(existing.getVersionNumber());
            this.getTermRepositoryService().updateTermResolver(bldr.build());
        }
    }

    private TermResolverDefinition findExisting(TermResolverDefinition.Builder bldr) {
        if (bldr.getId() != null) {
            try {
                return this.getTermRepositoryService().getTermResolverById(bldr.getId());
            }
            catch (RiceIllegalArgumentException ex) {
                return null;
            }
        }
        return this.getTermRepositoryService().getTermResolverByNameAndNamespace(bldr.getName(), bldr.getNamespace());
    }

    public void load() {
        this.loadTermResolver("10000", "KS-SYS", "CompletedCourse", "10000", "10000", "", "", "");
        this.loadTermResolver("10001", "KS-SYS", "CompletedCourses", "10000", "10001", "", "", "");
        this.loadTermResolver("10002", "KS-SYS", "NumberOfCompletedCourses", "10000", "10002", "", "", "");
        this.loadTermResolver("10003", "KS-SYS", "NumberOfCreditsFromCompletedCourses", "10000", "10003", "", "", "");
        this.loadTermResolver("10004", "KS-SYS", "EnrolledCourses", "10000", "10004", "", "", "");
        this.loadTermResolver("10005", "KS-SYS", "GPAForCourses", "10000", "10005", "", "", "");
        this.loadTermResolver("10006", "KS-SYS", "GradeTypeForCourses", "10000", "10006", "", "", "");
        this.loadTermResolver("10007", "KS-SYS", "NumberOfCredits", "10000", "10007", "", "", "");
        this.loadTermResolver("10008", "KS-SYS", "NumberOfCreditsFromOrganization", "10000", "10008", "", "", "");
        this.loadTermResolver("10009", "KS-SYS", "AdminOrganizationPermissionRequired", "10000", "10009", "", "", "");
        this.loadTermResolver("10010", "KS-SYS", "ScoreOnTest", "10000", "10010", "", "", "");
        this.loadTermResolver("10011", "KS-SYS", "AdmittedToProgram", "10000", "10011", "", "", "");
        this.loadTermResolver("10012", "KS-SYS", "AdmittedToProgramLimitCoursesInOrgForDuration", "10000", "10012", "", "", "");
        this.loadTermResolver("10013", "KS-SYS", "FreeFormText", "10000", "10013", "", "", "");
    }
}

