/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.queries.DatabaseQueryMechanism;
import org.eclipse.persistence.internal.queries.ExpressionQueryMechanism;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ModifyQuery;

public abstract class ModifyAllQuery
extends ModifyQuery {
    public static final int NO_CACHE = 0;
    public static final int INVALIDATE_CACHE = 1;
    private int m_cacheUsage = 1;
    protected Class referenceClass;
    protected String referenceClassName;
    protected transient Integer result;
    private boolean shouldDeferExecutionInUOW = true;
    protected ExpressionBuilder defaultBuilder;
    protected boolean isPreparedUsingTempStorage;

    public ModifyAllQuery() {
    }

    public ModifyAllQuery(Class referenceClass) {
        this();
        this.setReferenceClass(referenceClass);
    }

    public ModifyAllQuery(Class referenceClass, Expression selectionCriteria) {
        this();
        this.setReferenceClass(referenceClass);
        this.setSelectionCriteria(selectionCriteria);
    }

    @Override
    public boolean isModifyAllQuery() {
        return true;
    }

    public void setIsPreparedUsingTempStorage(boolean isPreparedUsingTempStorage) {
        this.isPreparedUsingTempStorage = isPreparedUsingTempStorage;
    }

    public boolean isPreparedUsingTempStorage() {
        return this.isPreparedUsingTempStorage;
    }

    @Override
    protected void clonedQueryExecutionComplete(DatabaseQuery query, AbstractSession session) {
        super.clonedQueryExecutionComplete(query, session);
        if (session.isUnitOfWork()) {
            ((UnitOfWorkImpl)session).storeModifyAllQuery(query);
        }
    }

    @Override
    public Object executeInUnitOfWork(UnitOfWorkImpl unitOfWork, AbstractRecord translationRow) throws DatabaseException, OptimisticLockException {
        if (unitOfWork.isNestedUnitOfWork()) {
            throw ValidationException.nestedUOWNotSupportedForModifyAllQuery();
        }
        if (this.shouldDeferExecutionInUOW()) {
            unitOfWork.storeDeferredModifyAllQuery(this, translationRow);
            this.result = null;
        } else {
            if (!unitOfWork.isInTransaction()) {
                unitOfWork.beginEarlyTransaction();
            }
            unitOfWork.setWasNonObjectLevelModifyQueryExecuted(true);
            this.result = (Integer)super.executeInUnitOfWork(unitOfWork, translationRow);
        }
        return this.result;
    }

    public int getCacheUsage() {
        return this.m_cacheUsage;
    }

    public ExpressionBuilder getExpressionBuilder() {
        if (this.defaultBuilder == null) {
            this.initializeDefaultBuilder();
        }
        return this.defaultBuilder;
    }

    public void setExpressionBuilder(ExpressionBuilder builder) {
        this.defaultBuilder = builder;
    }

    @Override
    public String getReferenceClassName() {
        if (this.referenceClassName == null && this.referenceClass != null) {
            this.referenceClassName = this.referenceClass.getName();
        }
        return this.referenceClassName;
    }

    @Override
    public Class getReferenceClass() {
        return this.referenceClass;
    }

    protected void invalidateCache() {
        if (this.result != null && this.result == 0) {
            return;
        }
        this.getSession().getIdentityMapAccessor().invalidateObjects(this.getSelectionCriteria(), this.getReferenceClass(), this.getTranslationRow(), true);
    }

    public void mergeChangesIntoSharedCache() {
        if (this.shouldInvalidateCache() && !this.shouldStoreBypassCache()) {
            this.invalidateCache();
        }
    }

    public void setCacheUsage(int cacheUsage) {
        this.m_cacheUsage = cacheUsage;
    }

    public void setReferenceClass(Class referenceClass) {
        if (this.referenceClass != referenceClass) {
            this.setIsPrepared(false);
        }
        this.referenceClass = referenceClass;
    }

    public void setReferenceClassName(String className) {
        this.referenceClassName = className;
    }

    public void setShouldDeferExecutionInUOW(boolean shouldDeferExecutionInUOW) {
        this.shouldDeferExecutionInUOW = shouldDeferExecutionInUOW;
    }

    public boolean shouldDeferExecutionInUOW() {
        return this.shouldDeferExecutionInUOW;
    }

    protected boolean shouldInvalidateCache() {
        return this.m_cacheUsage == 1;
    }

    protected void initializeDefaultBuilder() {
        this.initializeQuerySpecificDefaultBuilder();
        if (this.defaultBuilder == null) {
            this.defaultBuilder = new ExpressionBuilder();
        }
    }

    protected void initializeQuerySpecificDefaultBuilder() {
        DatabaseQueryMechanism mech = this.getQueryMechanism();
        if (mech.isExpressionQueryMechanism() && ((ExpressionQueryMechanism)mech).getExpressionBuilder() != null) {
            this.defaultBuilder = ((ExpressionQueryMechanism)mech).getExpressionBuilder();
        }
    }
}

