<?xml version="1.0" encoding="UTF-8"?>
<!--
  #%L
  %%
  Copyright (C) 2014 - 2020 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  -->

<!-- $Revision:   1.4  $ -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:att="http://apply.grants.gov/system/Attachments-V1.0" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:footer="http://apply.grants.gov/system/Footer-V1.0" xmlns:glob="http://apply.grants.gov/system/Global-V1.0" xmlns:RR_OtherProjectInfo_1_4="http://apply.grants.gov/forms/RR_OtherProjectInfo_1_4-V1.4" xmlns:globLib="http://apply.grants.gov/system/GlobalLibrary-V2.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:header="http://apply.grants.gov/system/Header-V1.0">
    <xsl:variable name="fo:layout-master-set">
        <fo:layout-master-set>
            <fo:simple-page-master master-name="default-page" page-height="11in" page-width="8.5in" margin-left="0.3in" margin-right="0.3in">
                <fo:region-body margin-top="0.5in" margin-bottom="0.5in" font-family="arialuni" font-size="9px"/>
                <fo:region-after region-name="region-after-all" extent=".3in" />
            </fo:simple-page-master>
        </fo:layout-master-set>
    </xsl:variable>
    <xsl:template match="RR_OtherProjectInfo_1_4:RR_OtherProjectInfo_1_4">
        <fo:root>
            <xsl:copy-of select="$fo:layout-master-set"/>
            <fo:page-sequence master-reference="default-page" initial-page-number="1" format="1">
            <fo:static-content flow-name="region-after-all">
               <fo:table width="100%"
                  space-before.optimum="0pt"
                  space-after.optimum="0pt"
                  table-layout="fixed">
                  <fo:table-column column-width="proportional-column-width(1)"/>
                  <fo:table-column column-width="proportional-column-width(1)"/>
                  <fo:table-body>
                     <fo:table-row>
                        <fo:table-cell hyphenate="true" language="en"
                         padding-start="0pt"
                         padding-end="0pt"
                         padding-before="1pt"
                         padding-after="1pt"
                         display-align="before"
                         text-align="left"
                         border-style="solid"
                         border-width="0pt"
                         border-color="white">
                           <fo:block>
                              <fo:inline font-size="8px">Tracking Number: <xsl:value-of select="/*/*/footer:Grants_govTrackingNumber"/>
                              </fo:inline>
                           </fo:block>
                        </fo:table-cell>
                        <fo:table-cell hyphenate="true" language="en" line-height="9pt"
                         padding-start="0pt"
                         padding-end="0pt"
                         padding-before="1pt"
                         padding-after="1pt"
                         display-align="before"
                         text-align="right"
                         border-style="solid"
                         border-width="0pt"
                         border-color="white">
                           <fo:block><fo:inline font-size="8px">Funding Opportunity Number: <xsl:value-of select="/*/*/header:OpportunityID"/></fo:inline>
                                     <fo:inline font-size="8px">.       Received Date: <xsl:value-of select="/*/*/footer:ReceivedDateTime"/></fo:inline></fo:block>
                        </fo:table-cell>
                     </fo:table-row>
                  </fo:table-body>
               </fo:table>
            </fo:static-content>
                <fo:flow flow-name="xsl-region-body">
                	<fo:block text-align="right"  font-family="arialuni" font-size="6px">OMB Number: 4040-0001</fo:block>
                    <fo:block text-align="right"  font-family="arialuni" font-size="6px">Expiration Date: 12/31/2022</fo:block>
                    <fo:block text-align="center" font-family="arialuni" font-size="12px" font-weight="bold">
         RESEARCH &amp; RELATED Other Project Information
         <fo:block>&#160;</fo:block>
                    </fo:block>
                    <fo:table width="100%" table-layout="fixed">
                        <fo:table-column column-width="100%"/>
                        <fo:table-body>
                            <!-- Block 1 Begin -->
                            <fo:table-row font-size="9px">
                                <fo:table-cell line-height="15pt">
                                    <fo:table border-style="solid" border-color="black" width="100%" table-layout="fixed">
                                        <fo:table-column column-width="100%"/>
                                        <fo:table-body>
                                            <fo:table-row>
                                                <fo:table-cell line-height="15pt">
                                                    <fo:table width="100%" table-layout="fixed">
                                                        <fo:table-column column-width="0.2in"/>
                                                        <fo:table-column column-width="2.0in"/>
                                                        <fo:table-column column-width="0.2in"/>
                                                        <fo:table-column column-width="0.5in"/>
                                                        <fo:table-column column-width="0.2in"/>
                                                        <fo:table-column column-width="0.5in"/>
                                                        <fo:table-body>
                                                            <fo:table-row>
                                                                <fo:table-cell line-height="15pt" font-weight="bold" padding-start="2pt">
                                                                    <fo:block>1.</fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt" font-weight="bold">
                                                                    <fo:block>Are Human Subjects Involved?*</fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt">
                                                                    <fo:block>
                                                                        <xsl:call-template name="radio">
                                                                        	<xsl:with-param name="value"><xsl:value-of select="RR_OtherProjectInfo_1_4:HumanSubjectsIndicator"/></xsl:with-param>
                                                                                <xsl:with-param name="radio_on_value">Y: Yes</xsl:with-param>
                                                                            </xsl:call-template>
                                                                    </fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt" font-size="9px" font-weight="bold">
                                                                    <fo:block>Yes</fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt">
                                                                    <fo:block>
                                                                        <xsl:call-template name="radio">
                                                                        	<xsl:with-param name="value"><xsl:value-of select="RR_OtherProjectInfo_1_4:HumanSubjectsIndicator"/></xsl:with-param>
                                                                                <xsl:with-param name="radio_on_value">N: No</xsl:with-param>
                                                                            </xsl:call-template>
                                                                    </fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt" font-weight="bold">
                                                                    <fo:block>No</fo:block>
                                                                </fo:table-cell>
                                                            </fo:table-row>
                                                        </fo:table-body>
                                                    </fo:table>
                                                </fo:table-cell>
                                            </fo:table-row>
                                            <fo:table-row>
                                                <fo:table-cell line-height="15pt" padding-start="2pt">
                                                    <fo:block>1.a.  If YES to Human Subjects</fo:block>
                                                </fo:table-cell>
                                            </fo:table-row>
                                            <!--Project Exempt-->
                                            <fo:table-row>
                                                <fo:table-cell line-height="15pt">
                                                    <fo:table width="100%" table-layout="fixed">
                                                        <fo:table-column column-width="0.4in"/>
                                                        <fo:table-column column-width="3.0in"/>
                                                        <fo:table-column column-width="0.2in"/>
                                                        <fo:table-column column-width="0.5in"/>
                                                        <fo:table-column column-width="0.2in"/>
                                                        <fo:table-column column-width="0.5in"/>
                                                        <fo:table-body>
                                                            <fo:table-row>
                                                                <fo:table-cell line-height="15pt">
                                                                    <fo:block>&#160;</fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt">
                                                                    <fo:block>Is the Project Exempt from Federal regulations?</fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt">
                                                                    <fo:block>
                                                                    	<xsl:call-template name="radio">
                                                                        	<xsl:with-param name="value">
                                                                       			<xsl:value-of select="RR_OtherProjectInfo_1_4:HumanSubjectsSupplement/RR_OtherProjectInfo_1_4:ExemptFedReg" />
                                                                           </xsl:with-param>
                                                                         	<xsl:with-param name="radio_on_value">Y: Yes</xsl:with-param>
                                                                      	</xsl:call-template>
                                                                    </fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt" font-size="9px">
                                                                    <fo:block>Yes</fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt">
                                                                    <fo:block>
                                                                        <xsl:call-template name="radio">
                                                                        	<xsl:with-param name="value">
                                                                       			<xsl:value-of select="RR_OtherProjectInfo_1_4:HumanSubjectsSupplement/RR_OtherProjectInfo_1_4:ExemptFedReg" />
                                                                       		</xsl:with-param>
                                                                                <xsl:with-param name="radio_on_value">N: No</xsl:with-param>
                                                                            </xsl:call-template>
                                                                    </fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt">
                                                                    <fo:block>No</fo:block>
                                                                </fo:table-cell>
                                                            </fo:table-row>
                                                        </fo:table-body>
                                                    </fo:table>
                                                </fo:table-cell>
                                            </fo:table-row>
                                            <fo:table-row>
                                                <fo:table-cell line-height="15pt">
                                                    <fo:table width="100%" table-layout="fixed">
                                                        <fo:table-column column-width="0.8in"/>
                                                        <fo:table-column column-width="3.0in"/>
                                                        <fo:table-column column-width="3.0in"/>
                                                        <fo:table-body>
                                                            <fo:table-row>
                                                                <fo:table-cell>
                                                                    <fo:block>&#160;</fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt">
                                                                    <fo:block>If YES, check appropriate exemption number:</fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt">
                                                                    <fo:table width="100%" table-layout="fixed">
													
                                                                         <fo:table-column column-width="0.2in"/>
                                                                        <fo:table-column column-width="0.2in"/>
                                                                        <fo:table-column column-width="0.2in"/>
                                                                        <fo:table-column column-width="0.2in"/>
                                                                        <fo:table-column column-width="0.2in"/>
                                                                        <fo:table-column column-width="0.2in"/>
                                                                        <fo:table-column column-width="0.2in"/>
                                                                        <fo:table-column column-width="0.2in"/>
                                                                        
                                                                        <fo:table-column column-width="0.2in"/>
                                                                        <fo:table-column column-width="0.2in"/>
                                                                        <fo:table-column column-width="0.2in"/>
                                                                        <fo:table-column column-width="0.2in"/>
                                                                        <fo:table-column column-width="0.2in"/>
                                                                        <fo:table-column column-width="0.2in"/>
                                                                        <fo:table-column column-width="0.2in"/>
                                                                        <fo:table-column column-width="0.2in"/> 
                                                                        <fo:table-body>
                                                                            <fo:table-row>
                                                                            <fo:table-cell line-height="15pt">
                                                                                    <fo:block>
                                                                                        <xsl:choose>
                                                                                            <xsl:when test="RR_OtherProjectInfo_1_4:HumanSubjectsSupplement/RR_OtherProjectInfo_1_4:ExemptionNumbers/RR_OtherProjectInfo_1_4:ExemptionNumber = 'E1'">
                                                                                                <fo:inline white-space-collapse="false" font-family="ZapfDingbats" font-size="9px" padding-start="1pt" padding-end="1pt" text-decoration="underline" color="black">&#x2714;</fo:inline>
                                                                                            </xsl:when>
                                                                                            <xsl:otherwise>
                                                                                                <fo:inline text-decoration="underline" color="black">
                                                                                                    <fo:leader leader-length="8pt" leader-pattern="rule"/>
                                                                                                </fo:inline>
                                                                                            </xsl:otherwise>
                                                                                        </xsl:choose>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell line-height="15pt">
                                                                                    <fo:block>1</fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell line-height="15pt">
                                                                                    <fo:block>
                                                                                        <xsl:choose>
                                                                                            <xsl:when test="RR_OtherProjectInfo_1_4:HumanSubjectsSupplement/RR_OtherProjectInfo_1_4:ExemptionNumbers/RR_OtherProjectInfo_1_4:ExemptionNumber = 'E2'">
                                                                                                <fo:inline white-space-collapse="false" font-family="ZapfDingbats" font-size="9px" padding-start="1pt" padding-end="1pt" text-decoration="underline" color="black">&#x2714;</fo:inline>
                                                                                            </xsl:when>
                                                                                            <xsl:otherwise>
                                                                                                <fo:inline text-decoration="underline" color="black">
                                                                                                    <fo:leader leader-length="8pt" leader-pattern="rule"/>
                                                                                                </fo:inline>
                                                                                            </xsl:otherwise>
                                                                                        </xsl:choose>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell line-height="15pt">
                                                                                    <fo:block>2</fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell line-height="15pt">
                                                                                    <fo:block>
                                                                                        <xsl:choose>
                                                                                            <xsl:when test="RR_OtherProjectInfo_1_4:HumanSubjectsSupplement/RR_OtherProjectInfo_1_4:ExemptionNumbers/RR_OtherProjectInfo_1_4:ExemptionNumber = 'E3'">
                                                                                                <fo:inline white-space-collapse="false" font-family="ZapfDingbats" font-size="9px" padding-start="1pt" padding-end="1pt" text-decoration="underline" color="black">&#x2714;</fo:inline>
                                                                                            </xsl:when>
                                                                                            <xsl:otherwise>
                                                                                                <fo:inline text-decoration="underline" color="black">
                                                                                                    <fo:leader leader-length="8pt" leader-pattern="rule"/>
                                                                                                </fo:inline>
                                                                                            </xsl:otherwise>
                                                                                        </xsl:choose>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell line-height="15pt">
                                                                                    <fo:block>3</fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell line-height="15pt">
                                                                                    <fo:block>
                                                                                        <xsl:choose>
                                                                                            <xsl:when test="RR_OtherProjectInfo_1_4:HumanSubjectsSupplement/RR_OtherProjectInfo_1_4:ExemptionNumbers/RR_OtherProjectInfo_1_4:ExemptionNumber = 'E4'">
                                                                                                <fo:inline white-space-collapse="false" font-family="ZapfDingbats" font-size="9px" padding-start="1pt" padding-end="1pt" text-decoration="underline" color="black">&#x2714;</fo:inline>
                                                                                            </xsl:when>
                                                                                            <xsl:otherwise>
                                                                                                <fo:inline text-decoration="underline" color="black">
                                                                                                    <fo:leader leader-length="8pt" leader-pattern="rule"/>
                                                                                                </fo:inline>
                                                                                            </xsl:otherwise>
                                                                                        </xsl:choose>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell line-height="15pt">
                                                                                    <fo:block>4</fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell line-height="15pt">
                                                                                    <fo:block>
                                                                                        <xsl:choose>
                                                                                            <xsl:when test="RR_OtherProjectInfo_1_4:HumanSubjectsSupplement/RR_OtherProjectInfo_1_4:ExemptionNumbers/RR_OtherProjectInfo_1_4:ExemptionNumber = 'E5'">
                                                                                                <fo:inline white-space-collapse="false" font-family="ZapfDingbats" font-size="9px" padding-start="1pt" padding-end="1pt" text-decoration="underline" color="black">&#x2714;</fo:inline>
                                                                                            </xsl:when>
                                                                                            <xsl:otherwise>
                                                                                                <fo:inline text-decoration="underline" color="black">
                                                                                                    <fo:leader leader-length="8pt" leader-pattern="rule"/>
                                                                                                </fo:inline>
                                                                                            </xsl:otherwise>
                                                                                        </xsl:choose>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell line-height="15pt">
                                                                                    <fo:block>5</fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell line-height="15pt">
                                                                                    <fo:block>
                                                                                        <xsl:choose>
                                                                                            <xsl:when test="RR_OtherProjectInfo_1_4:HumanSubjectsSupplement/RR_OtherProjectInfo_1_4:ExemptionNumbers/RR_OtherProjectInfo_1_4:ExemptionNumber = 'E6'">
                                                                                                <fo:inline white-space-collapse="false" font-family="ZapfDingbats" font-size="9px" padding-start="1pt" padding-end="1pt" text-decoration="underline" color="black">&#x2714;</fo:inline>
                                                                                            </xsl:when>
                                                                                            <xsl:otherwise>
                                                                                                <fo:inline text-decoration="underline" color="black">
                                                                                                    <fo:leader leader-length="8pt" leader-pattern="rule"/>
                                                                                                </fo:inline>
                                                                                            </xsl:otherwise>
                                                                                        </xsl:choose>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell line-height="15pt">
                                                                                    <fo:block>6</fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell line-height="15pt">
                                                                                    <fo:block>
                                                                                        <xsl:choose>
                                                                                            <xsl:when test="RR_OtherProjectInfo_1_4:HumanSubjectsSupplement/RR_OtherProjectInfo_1_4:ExemptionNumbers/RR_OtherProjectInfo_1_4:ExemptionNumber = 'E7'">
                                                                                                <fo:inline white-space-collapse="false" font-family="ZapfDingbats" font-size="9px" padding-start="1pt" padding-end="1pt" text-decoration="underline" color="black">&#x2714;</fo:inline>
                                                                                            </xsl:when>
                                                                                            <xsl:otherwise>
                                                                                                <fo:inline text-decoration="underline" color="black">
                                                                                                    <fo:leader leader-length="8pt" leader-pattern="rule"/>
                                                                                                </fo:inline>
                                                                                            </xsl:otherwise>
                                                                                        </xsl:choose>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell line-height="15pt">
                                                                                    <fo:block>7</fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell line-height="15pt">
                                                                                    <fo:block>
                                                                                        <xsl:choose>
                                                                                            <xsl:when test="RR_OtherProjectInfo_1_4:HumanSubjectsSupplement/RR_OtherProjectInfo_1_4:ExemptionNumbers/RR_OtherProjectInfo_1_4:ExemptionNumber = 'E8'">
                                                                                                <fo:inline white-space-collapse="false" font-family="ZapfDingbats" font-size="9px" padding-start="1pt" padding-end="1pt" text-decoration="underline" color="black">&#x2714;</fo:inline>
                                                                                            </xsl:when>
                                                                                            <xsl:otherwise>
                                                                                                <fo:inline text-decoration="underline" color="black">
                                                                                                    <fo:leader leader-length="8pt" leader-pattern="rule"/>
                                                                                                </fo:inline>
                                                                                            </xsl:otherwise>
                                                                                        </xsl:choose>
                                                                                    </fo:block>
                                                                                </fo:table-cell>
                                                                                <fo:table-cell line-height="15pt">
                                                                                    <fo:block>8</fo:block>
                                                                                </fo:table-cell>
                                                                              
                                                                            </fo:table-row>
                                                                        </fo:table-body>
                                                                    </fo:table>
                                                                </fo:table-cell>
                                                            </fo:table-row>
                                                        </fo:table-body>
                                                    </fo:table>
                                                </fo:table-cell>
                                            </fo:table-row>
                                            <fo:table-row>
                                                <fo:table-cell line-height="15pt">
                                                    <fo:table width="100%" table-layout="fixed">
                                                        <fo:table-column column-width="0.8in"/>
                                                        <fo:table-column column-width="2.2in"/>
                                                        <fo:table-column column-width="0.2in"/>
                                                        <fo:table-column column-width="0.5in"/>
                                                        <fo:table-column column-width="0.2in"/>
                                                        <fo:table-column column-width="0.5in"/>
                                                        <fo:table-body>
                                                            <fo:table-row>
                                                                <fo:table-cell>
                                                                    <fo:block>&#160;</fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt">
                                                                    <fo:block>If NO, is the IRB review Pending?</fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt">
                                                                    <fo:block>
                                                                        <xsl:call-template name="radio">
                                                                            <xsl:with-param name="value">
                                                                                <xsl:value-of select="RR_OtherProjectInfo_1_4:HumanSubjectsSupplement/RR_OtherProjectInfo_1_4:HumanSubjectIRBReviewIndicator"/>
                                                                            </xsl:with-param>
                                                                            <xsl:with-param name="radio_on_value">Y: Yes</xsl:with-param>
                                                                        </xsl:call-template>
                                                                    </fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt" font-size="9px" font-weight="bold">
                                                                    <fo:block>Yes</fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt">
                                                                    <fo:block>
                                                                        <xsl:call-template name="radio">
                                                                            <xsl:with-param name="value">
                                                                                <xsl:value-of select="RR_OtherProjectInfo_1_4:HumanSubjectsSupplement/RR_OtherProjectInfo_1_4:HumanSubjectIRBReviewIndicator"/>
                                                                            </xsl:with-param>
                                                                            <xsl:with-param name="radio_on_value">N: No</xsl:with-param>
                                                                        </xsl:call-template>
                                                                    </fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt" font-weight="bold">
                                                                    <fo:block>No</fo:block>
                                                                </fo:table-cell>
                                                            </fo:table-row>
                                                        </fo:table-body>
                                                    </fo:table>
                                                </fo:table-cell>
                                            </fo:table-row>
                                            <fo:table-row>
                                                <fo:table-cell line-height="15pt">
                                                    <fo:table width="100%" table-layout="fixed">
                                                        <fo:table-column column-width="1.2in"/>
                                                        <fo:table-column column-width="2.0in"/>
                                                        <fo:table-column column-width="100%"/>
                                                        <fo:table-body>
                                                            <fo:table-row>
                                                                <fo:table-cell>
                                                                    <fo:block>&#160;</fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt">
                                                                    <fo:block>IRB Approval Date:</fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt">
                                                                    <fo:block font-family="arialuni">
                                                                        <xsl:call-template name="formatDate">
                                                                            <xsl:with-param name="value" select="RR_OtherProjectInfo_1_4:HumanSubjectsSupplement/RR_OtherProjectInfo_1_4:HumanSubjectIRBReviewDate"/>
                                                                        </xsl:call-template>
                                                                    </fo:block>
                                                                </fo:table-cell>
                                                            </fo:table-row>
                                                        </fo:table-body>
                                                    </fo:table>
                                                </fo:table-cell>
                                            </fo:table-row>
                                            <fo:table-row>
                                                <fo:table-cell line-height="15pt">
                                                    <fo:table width="100%" table-layout="fixed">
                                                        <fo:table-column column-width="1.2in"/>
                                                        <fo:table-column column-width="2.5in"/>
                                                        <fo:table-column column-width="100%"/>
                                                        <fo:table-body>
                                                            <fo:table-row>
                                                                <fo:table-cell>
                                                                    <fo:block>&#160;</fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt">
                                                                    <fo:block>Human Subject Assurance Number</fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt">
                                                                    <fo:block font-family="arialuni">
                                                                        <xsl:value-of select="RR_OtherProjectInfo_1_4:HumanSubjectsSupplement/RR_OtherProjectInfo_1_4:HumanSubjectAssuranceNumber"/>
                                                                    </fo:block>
                                                                </fo:table-cell>
                                                            </fo:table-row>
                                                        </fo:table-body>
                                                    </fo:table>
                                                </fo:table-cell>
                                            </fo:table-row>
                                        </fo:table-body>
                                    </fo:table>
                                </fo:table-cell>
                            </fo:table-row>
                            <!-- Block 1 End -->
                            <!-- Block 2 Begin -->
                            <fo:table-row font-size="9px">
                                <fo:table-cell line-height="15pt">
                                    <fo:table border-style="solid" border-color="black" width="100%" table-layout="fixed">
                                        <fo:table-column column-width="100%"/>
                                        <fo:table-body>
                                            <fo:table-row>
                                                <fo:table-cell line-height="15pt">
                                                    <fo:table width="100%" table-layout="fixed">
                                                        <fo:table-column column-width="0.2in"/>
                                                        <fo:table-column column-width="2.0in"/>
                                                        <fo:table-column column-width="0.2in"/>
                                                        <fo:table-column column-width="0.5in"/>
                                                        <fo:table-column column-width="0.2in"/>
                                                        <fo:table-column column-width="0.5in"/>
                                                        <fo:table-body>
                                                            <fo:table-row>
                                                                <fo:table-cell line-height="15pt" font-weight="bold" padding-start="2pt">
                                                                    <fo:block>2.</fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt" font-weight="bold">
                                                                    <fo:block>Are Vertebrate Animals Used?*</fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt">
                                                                    <fo:block>
                                                                        <xsl:call-template name="radio">
                                                                        	<xsl:with-param name="value"><xsl:value-of select="RR_OtherProjectInfo_1_4:VertebrateAnimalsIndicator"/></xsl:with-param>
                                                                                <xsl:with-param name="radio_on_value">Y: Yes</xsl:with-param>
                                                                            </xsl:call-template>
                                                                    </fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt" font-size="9px" font-weight="bold">
                                                                    <fo:block>Yes</fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt">
                                                                	<fo:block>
                                                                        <xsl:call-template name="radio">
                                                                        	<xsl:with-param name="value"><xsl:value-of select="RR_OtherProjectInfo_1_4:VertebrateAnimalsIndicator"/></xsl:with-param>
                                                                                <xsl:with-param name="radio_on_value">N: No</xsl:with-param>
                                                                            </xsl:call-template>
                                                                    </fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt" font-weight="bold">
                                                                    <fo:block>No</fo:block>
                                                                </fo:table-cell>
                                                            </fo:table-row>
                                                        </fo:table-body>
                                                    </fo:table>
                                                </fo:table-cell>
                                            </fo:table-row>
                                            <fo:table-row>
                                                <fo:table-cell line-height="15pt" padding-start="2pt">
                                                    <fo:block>2.a. If YES to Vertebrate Animals</fo:block>
                                                </fo:table-cell>
                                            </fo:table-row>
                                            <fo:table-row>
                                                <fo:table-cell line-height="15pt">
                                                    <fo:table width="100%" table-layout="fixed">
                                                        <fo:table-column column-width="2.4in"/>
                                                        <fo:table-column column-width="0.2in"/>
                                                        <fo:table-column column-width="0.3in"/>
                                                        <fo:table-column column-width="0.2in"/>
                                                        <fo:table-column column-width="0.5in"/>
                                                        <fo:table-body>
                                                            <fo:table-row>
                                                                <fo:table-cell line-height="15pt" padding-start="0.4in">
                                                                    <fo:block>Is the IACUC review Pending?</fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt">
                                                                    <fo:block>
                                                                        <xsl:call-template name="radio">
                                                                            <xsl:with-param name="value">
                                                                                <xsl:value-of select="RR_OtherProjectInfo_1_4:VertebrateAnimalsSupplement/RR_OtherProjectInfo_1_4:VertebrateAnimalsIACUCReviewIndicator"/>
                                                                            </xsl:with-param>
                                                                            <xsl:with-param name="radio_on_value">Y: Yes</xsl:with-param>
                                                                        </xsl:call-template>
                                                                    </fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt" font-size="9px">
                                                                    <fo:block>Yes</fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt">
                                                                    <fo:block>
                                                                        <xsl:call-template name="radio">
                                                                            <xsl:with-param name="value">
                                                                                <xsl:value-of select="RR_OtherProjectInfo_1_4:VertebrateAnimalsSupplement/RR_OtherProjectInfo_1_4:VertebrateAnimalsIACUCReviewIndicator"/>
                                                                            </xsl:with-param>
                                                                            <xsl:with-param name="radio_on_value">N: No</xsl:with-param>
                                                                        </xsl:call-template>
                                                                    </fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt">
                                                                    <fo:block>No</fo:block>
                                                                </fo:table-cell>
                                                            </fo:table-row>
                                                        </fo:table-body>
                                                    </fo:table>
                                                </fo:table-cell>
                                            </fo:table-row>
                                            <fo:table-row>
                                                <fo:table-cell line-height="15pt">
                                                    <fo:table width="100%" table-layout="fixed">
                                                        <fo:table-column column-width="3.0in"/>
                                                        <fo:table-column column-width="100%"/>
                                                        <fo:table-body>
                                                            <fo:table-row>
                                                                <fo:table-cell line-height="15pt" padding-start="0.8in">
                                                                    <fo:block>IACUC Approval Date:</fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt">
                                                                    <fo:block font-family="arialuni">
                                                                        <xsl:call-template name="formatDate">
                                                                            <xsl:with-param name="value" select="RR_OtherProjectInfo_1_4:VertebrateAnimalsSupplement/RR_OtherProjectInfo_1_4:VertebrateAnimalsIACUCApprovalDateReviewDate"/>
                                                                        </xsl:call-template>
                                                                    </fo:block>
                                                                </fo:table-cell>
                                                            </fo:table-row>
                                                        </fo:table-body>
                                                    </fo:table>
                                                </fo:table-cell>
                                            </fo:table-row>
                                            <fo:table-row>
                                                <fo:table-cell line-height="15pt">
                                                    <fo:table width="100%" table-layout="fixed">
                                                        <fo:table-column column-width="3.0in"/>
                                                        <fo:table-column column-width="100%"/>
                                                        <fo:table-body>
                                                            <fo:table-row>
                                                                <fo:table-cell line-height="15pt" padding-start="0.8in">
                                                                    <fo:block>Animal Welfare Assurance Number</fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt">
                                                                    <fo:block font-family="arialuni">
                                                                        <xsl:value-of select="RR_OtherProjectInfo_1_4:VertebrateAnimalsSupplement/RR_OtherProjectInfo_1_4:AssuranceNumber"/>
                                                                    </fo:block>
                                                                </fo:table-cell>
                                                            </fo:table-row>
                                                        </fo:table-body>
                                                    </fo:table>
                                                </fo:table-cell>
                                            </fo:table-row>
                                        </fo:table-body>
                                    </fo:table>
                                </fo:table-cell>
                            </fo:table-row>
                            <!-- Block 2 End -->
                            <!-- Block 3 Begin -->
                            <fo:table-row font-size="9px">
                                <fo:table-cell line-height="15pt">
                                    <fo:table border-style="solid" border-color="black" width="100%" table-layout="fixed">
                                        <fo:table-column column-width="100%"/>
                                        <fo:table-body>
                                            <fo:table-row>
                                                <fo:table-cell line-height="15pt">
                                                    <fo:table width="100%" table-layout="fixed">
                                                        <fo:table-column column-width="0.2in"/>
                                                        <fo:table-column column-width="4.0in"/>
                                                        <fo:table-column column-width="0.2in"/>
                                                        <fo:table-column column-width="0.5in"/>
                                                        <fo:table-column column-width="0.2in"/>
                                                        <fo:table-column column-width="0.5in"/>
                                                        <fo:table-body>
                                                            <fo:table-row>
                                                                <fo:table-cell line-height="15pt" font-weight="bold" padding-start="2pt">
                                                                    <fo:block>3.</fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt" font-weight="bold">
                                                                    <fo:block>Is proprietary/privileged information included in the application?*</fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt">
                                                                    <fo:block>
                                                                        <xsl:call-template name="radio">
                                                                        	<xsl:with-param name="value">
                                                                       			<xsl:value-of select="RR_OtherProjectInfo_1_4:ProprietaryInformationIndicator" />
                                                                                </xsl:with-param>
                                                                                <xsl:with-param name="radio_on_value">Y: Yes</xsl:with-param>
                                                                            </xsl:call-template>
                                                                    </fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt" font-size="9px" font-weight="bold">
                                                                    <fo:block>Yes</fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt">
                                                                    <fo:block>
                                                                        <xsl:call-template name="radio">
                                                                        	<xsl:with-param name="value">
                                                                       			<xsl:value-of select="RR_OtherProjectInfo_1_4:ProprietaryInformationIndicator" />
                                                                                </xsl:with-param>
                                                                                <xsl:with-param name="radio_on_value">N: No</xsl:with-param>
                                                                            </xsl:call-template>
                                                                    </fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt" font-weight="bold">
                                                                    <fo:block>No</fo:block>
                                                                </fo:table-cell>
                                                            </fo:table-row>
                                                        </fo:table-body>
                                                    </fo:table>
                                                </fo:table-cell>
                                            </fo:table-row>
                                        </fo:table-body>
                                    </fo:table>
                                </fo:table-cell>
                            </fo:table-row>
                            <!-- Block 3 End -->
                            <!-- Block 4 Begin -->
                            <fo:table-row font-size="9px">
                                <fo:table-cell line-height="15pt">
                                    <fo:table border-style="solid" border-color="black" width="100%" table-layout="fixed">
                                        <fo:table-column column-width="100%"/>
                                        <fo:table-body>
                                            <fo:table-row>
                                                <fo:table-cell line-height="15pt">
                                                    <fo:table width="100%" table-layout="fixed">
                                                        <fo:table-column column-width="6.2in"/>
                                                        <fo:table-column column-width="0.2in"/>
                                                        <fo:table-column column-width="0.5in"/>
                                                        <fo:table-column column-width="0.2in"/>
                                                        <fo:table-column column-width="0.5in"/>
                                                        <fo:table-body>
                                                            <fo:table-row>
                                                                <fo:table-cell line-height="15pt" font-weight="bold" padding-start="2pt">
                                                                    <fo:block>4.a.&#160;Does this project have an actual or potential impact - positive or negative - on the environment?*</fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt">
                                                                    <fo:block>
                                                                        <xsl:call-template name="radio">
                                                                        	<xsl:with-param name="value">
                                                                       			<xsl:value-of select="RR_OtherProjectInfo_1_4:EnvironmentalImpact/RR_OtherProjectInfo_1_4:EnvironmentalImpactIndicator" />
                                                                                </xsl:with-param>
                                                                                <xsl:with-param name="radio_on_value">Y: Yes</xsl:with-param>
                                                                            </xsl:call-template>
                                                                    </fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt" font-size="9px" font-weight="bold">
                                                                    <fo:block>Yes</fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt">
                                                                    <fo:block>
                                                                        <xsl:call-template name="radio">
                                                                        	<xsl:with-param name="value">
                                                                       			<xsl:value-of select="RR_OtherProjectInfo_1_4:EnvironmentalImpact/RR_OtherProjectInfo_1_4:EnvironmentalImpactIndicator" />
                                                                                </xsl:with-param>
                                                                                <xsl:with-param name="radio_on_value">N: No</xsl:with-param>
                                                                            </xsl:call-template>
                                                                    </fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt" font-weight="bold">
                                                                    <fo:block>No</fo:block>
                                                                </fo:table-cell>
                                                            </fo:table-row>
                                                        </fo:table-body>
                                                    </fo:table>
                                                </fo:table-cell>
                                            </fo:table-row>
                                            <fo:table-row>
                                                <fo:table-cell line-height="15pt">
                                                    <fo:table width="100%" table-layout="fixed">
                                                        <fo:table-column column-width="2.0in"/>
                                                        <fo:table-column column-width="100%"/>
                                                        <fo:table-body>
                                                            <fo:table-row>
                                                                <fo:table-cell line-height="15pt" padding-start="2pt">
                                                                    <fo:block>4.b.&#160;If yes, please explain:</fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt" hyphenate="true" language="en">
                                                                    <fo:block font-family="arialuni">
                                                                        <xsl:value-of select="RR_OtherProjectInfo_1_4:EnvironmentalImpact/RR_OtherProjectInfo_1_4:EnvironmentalImpactExplanation"/>
                                                                    </fo:block>
                                                                </fo:table-cell>
                                                            </fo:table-row>
                                                        </fo:table-body>
                                                    </fo:table>
                                                </fo:table-cell>
                                            </fo:table-row>
                                        	<fo:table-row>
                                                <fo:table-cell line-height="15pt">
                                                    <fo:table width="100%" table-layout="fixed">
                                                        <fo:table-column column-width="6.3in"/>
                                                        <fo:table-column column-width="0.2in"/>
                                                        <fo:table-column column-width="0.5in"/>
                                                        <fo:table-column column-width="0.2in"/>
                                                        <fo:table-column column-width="0.5in"/>
                                                        <fo:table-body>
                                                            <fo:table-row>
                                                                <fo:table-cell padding-start="2pt">
                                                                       <fo:block>4.c.&#160;If this project has an actual or potential impact on the environment, has an exemption been authorized or an environmental assessment (EA) or environmental impact statement (EIS) been performed?</fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt">
                                                                    <fo:block>
                                                                        <xsl:call-template name="radio">
                                                                            <xsl:with-param name="value">
                                                                                <xsl:value-of select="RR_OtherProjectInfo_1_4:EnvironmentalImpact/RR_OtherProjectInfo_1_4:EnvironmentalExemption/RR_OtherProjectInfo_1_4:EnvironmentalExemptionIndicator"/>
                                                                            </xsl:with-param>
                                                                            <xsl:with-param name="radio_on_value">Y: Yes</xsl:with-param>
                                                                        </xsl:call-template>
                                                                    </fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt" font-size="9px">
                                                                    <fo:block>Yes</fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt">
                                                                    <fo:block>
                                                                        <xsl:call-template name="radio">
                                                                            <xsl:with-param name="value">
                                                                                <xsl:value-of select="RR_OtherProjectInfo_1_4:EnvironmentalImpact/RR_OtherProjectInfo_1_4:EnvironmentalExemption/RR_OtherProjectInfo_1_4:EnvironmentalExemptionIndicator"/>
                                                                            </xsl:with-param>
                                                                            <xsl:with-param name="radio_on_value">N: No</xsl:with-param>
                                                                        </xsl:call-template>
                                                                    </fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt">
                                                                    <fo:block>No</fo:block>
                                                                </fo:table-cell>
                                                            </fo:table-row>
                                                        </fo:table-body>
                                                    </fo:table>
                                                </fo:table-cell>
                                            </fo:table-row>
                                            <fo:table-row>
                                                <fo:table-cell line-height="15pt">
                                                    <fo:table width="100%" table-layout="fixed">
                                                        <fo:table-column column-width="2.0in"/>
                                                        <fo:table-column column-width="100%"/>
                                                        <fo:table-body>
                                                            <fo:table-row>
                                                                <fo:table-cell line-height="15pt" padding-start="2pt">
                                                                    <fo:block>4.d.&#160;If yes, please explain:</fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt" hyphenate="true" language="en">
                                                                    <fo:block font-family="arialuni">
                                                                        <xsl:value-of select="RR_OtherProjectInfo_1_4:EnvironmentalImpact/RR_OtherProjectInfo_1_4:EnvironmentalExemption/RR_OtherProjectInfo_1_4:EnvironmentalExemptionExplanation"/>
                                                                    </fo:block>
                                                                </fo:table-cell>
                                                            </fo:table-row>
                                                        </fo:table-body>
                                                    </fo:table>
                                                </fo:table-cell>
                                            </fo:table-row>
                                        </fo:table-body>
                                    </fo:table>
                                </fo:table-cell>
                            </fo:table-row>
                            <!-- Block 4 End -->
                            <!-- Block 5 Begin -->
                            <fo:table-row font-size="9px">
                                <fo:table-cell line-height="15pt">
                                    <fo:table border-style="solid" border-color="black" width="100%" table-layout="fixed">
                                        <fo:table-column column-width="100%"/>
                                        <fo:table-body>
                                            <fo:table-row>
                                                <fo:table-cell line-height="15pt">
                                                    <fo:table width="100%" table-layout="fixed">
                                                        <fo:table-column column-width="0.2in"/>
                                                        <fo:table-column column-width="6.0in"/>
                                                        <fo:table-column column-width="0.2in"/>
                                                        <fo:table-column column-width="0.5in"/>
                                                        <fo:table-column column-width="0.2in"/>
                                                        <fo:table-column column-width="0.5in"/>
                                                        <fo:table-body>
                                                            <fo:table-row>
                                                                <fo:table-cell line-height="15pt" font-weight="bold" padding-start="2pt">
                                                                    <fo:block>5.</fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt" font-weight="bold">
                                                                    <fo:block>Is the research performance site designated, or eligible to be designated, as a historic place?*</fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt">
                                                                    <fo:block>
                                                                        <xsl:call-template name="radio">
                                                                        	<xsl:with-param name="value">
                                                                       			<xsl:value-of select="RR_OtherProjectInfo_1_4:HistoricDesignation" />
                                                                                </xsl:with-param>
                                                                                <xsl:with-param name="radio_on_value">Y: Yes</xsl:with-param>
                                                                            </xsl:call-template>
                                                                    </fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt" font-size="9px" font-weight="bold">
                                                                    <fo:block>Yes</fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt">
                                                                    <fo:block>
                                                                        <xsl:call-template name="radio">
                                                                        	<xsl:with-param name="value">
                                                                       			<xsl:value-of select="RR_OtherProjectInfo_1_4:HistoricDesignation" />
                                                                                </xsl:with-param>
                                                                                <xsl:with-param name="radio_on_value">N: No</xsl:with-param>
                                                                            </xsl:call-template>
                                                                    </fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt" font-weight="bold">
                                                                    <fo:block>No</fo:block>
                                                                </fo:table-cell>
                                                            </fo:table-row>
                                                        </fo:table-body>
                                                    </fo:table>
                                                </fo:table-cell>
                                            </fo:table-row>
                                            <fo:table-row>
                                                <fo:table-cell line-height="15pt">
                                                    <fo:table width="100%" table-layout="fixed">
                                                        <fo:table-column column-width="2.0in"/>
                                                        <fo:table-column column-width="100%"/>
                                                        <fo:table-body>
                                                            <fo:table-row>
                                                                <fo:table-cell line-height="15pt" padding-start="2pt">
                                                                    <fo:block>5.a.&#160;If yes, please explain:</fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt" hyphenate="true" language="en">
                                                                    <fo:block font-family="arialuni">
                                                                        <xsl:value-of select="RR_OtherProjectInfo_1_4:HistoricDesignationExplanation"/>
                                                                    </fo:block>
                                                                </fo:table-cell>
                                                            </fo:table-row>
                                                        </fo:table-body>
                                                    </fo:table>
                                                </fo:table-cell>
                                            </fo:table-row>
                                        </fo:table-body>
                                    </fo:table>
                                </fo:table-cell>
                            </fo:table-row>
                            <!-- Block 5 End -->
                            <!-- Block 6 Begin -->
                            <fo:table-row font-size="9px">
                                <fo:table-cell line-height="15pt">
                                    <fo:table border-style="solid" border-color="black" width="100%" table-layout="fixed">
                                        <fo:table-column column-width="100%"/>
                                        <fo:table-body>
                                            <fo:table-row>
                                                <fo:table-cell line-height="15pt">
                                                    <fo:table width="100%" table-layout="fixed">
                                                        <fo:table-column column-width="0.2in"/>
                                                        <fo:table-column column-width="6.0in"/>
                                                        <fo:table-column column-width="0.2in"/>
                                                        <fo:table-column column-width="0.5in"/>
                                                        <fo:table-column column-width="0.2in"/>
                                                        <fo:table-column column-width="0.5in"/>
                                                        <fo:table-body>
                                                            <fo:table-row>
                                                                <fo:table-cell line-height="15pt" font-weight="bold" padding-start="2pt">
                                                                    <fo:block>6.</fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt" font-weight="bold">
                                                                    <fo:block>Does this project involve activities outside the United States or partnership with international collaborators?*</fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt">
                                                                    <fo:block>
                                                                        <xsl:call-template name="radio">
                                                                        	<xsl:with-param name="value">
                                                                       			<xsl:value-of select="RR_OtherProjectInfo_1_4:InternationalActivities/RR_OtherProjectInfo_1_4:InternationalActivitiesIndicator" />
                                                                                </xsl:with-param>
                                                                                <xsl:with-param name="radio_on_value">Y: Yes</xsl:with-param>
                                                                            </xsl:call-template>
                                                                    </fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt" font-size="9px" font-weight="bold">
                                                                    <fo:block>Yes</fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt">
                                                                    <fo:block>
                                                                        <xsl:call-template name="radio">
                                                                        	<xsl:with-param name="value">
                                                                       			<xsl:value-of select="RR_OtherProjectInfo_1_4:InternationalActivities/RR_OtherProjectInfo_1_4:InternationalActivitiesIndicator" />
                                                                                </xsl:with-param>
                                                                                <xsl:with-param name="radio_on_value">N: No</xsl:with-param>
                                                                            </xsl:call-template>
                                                                    </fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt" font-weight="bold">
                                                                    <fo:block>No</fo:block>
                                                                </fo:table-cell>
                                                            </fo:table-row>
                                                        </fo:table-body>
                                                    </fo:table>
                                                </fo:table-cell>
                                            </fo:table-row>
                                            <fo:table-row>
                                                <fo:table-cell line-height="15pt">
                                                    <fo:table width="100%" table-layout="fixed">
                                                        <fo:table-column column-width="2.0in"/>
                                                        <fo:table-column column-width="100%"/>
                                                        <fo:table-body>
                                                            <fo:table-row>
                                                                <fo:table-cell line-height="15pt" padding-start="2pt">
                                                                    <fo:block>6.a.&#160;If yes, identify countries:</fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt" hyphenate="true" language="en">
                                                                    <fo:block font-family="arialuni">
                                                                        <xsl:value-of select="RR_OtherProjectInfo_1_4:InternationalActivities/RR_OtherProjectInfo_1_4:ActivitiesPartnershipsCountries"/>
                                                                    </fo:block>
                                                                </fo:table-cell>
                                                            </fo:table-row>
                                                        </fo:table-body>
                                                    </fo:table>
                                                </fo:table-cell>
                                            </fo:table-row>
                                            <fo:table-row>
                                                <fo:table-cell line-height="15pt">
                                                    <fo:table width="100%" table-layout="fixed">
                                                        <fo:table-column column-width="2.0in"/>
                                                        <fo:table-column column-width="100%"/>
                                                        <fo:table-body>
                                                            <fo:table-row>
                                                                <fo:table-cell line-height="15pt" padding-start="2pt">
                                                                    <fo:block>6.b.&#160;Optional Explanation:</fo:block>
                                                                </fo:table-cell>
                                                                <fo:table-cell line-height="15pt" hyphenate="true" language="en">
                                                                    <fo:block font-family="arialuni">
                                                                        <xsl:value-of select="RR_OtherProjectInfo_1_4:InternationalActivities/RR_OtherProjectInfo_1_4:InternationalActivitiesExplanation"/>
                                                                    </fo:block>
                                                                </fo:table-cell>
                                                            </fo:table-row>
                                                        </fo:table-body>
                                                    </fo:table>
                                                </fo:table-cell>
                                            </fo:table-row>
                                        </fo:table-body>
                                    </fo:table>
                                </fo:table-cell>
                            </fo:table-row>
                            <!-- Block 6  End -->
                            <!-- Block 7 repace -->
                            <xsl:element name="fo:table-row">
            <xsl:element name="fo:table-cell">
                <xsl:attribute name="font-size">9px</xsl:attribute>
                <xsl:element name="fo:table">
                    <xsl:attribute name="border-style">solid</xsl:attribute>
                    <xsl:attribute name="border-color">black</xsl:attribute>
                    <xsl:if test="(position( )) = 1">
                    <xsl:attribute name="border-bottom-style">hidden</xsl:attribute>
                    </xsl:if>
                    <xsl:if test="(position( )) = last()">
                    <xsl:attribute name="border-top-style">hidden</xsl:attribute>
                    </xsl:if>
                    <xsl:if test="(position( )) > 1 and position() &lt; last() ">
                    <xsl:attribute name="border-bottom-style">hidden</xsl:attribute>
                    <xsl:attribute name="border-top-style">hidden</xsl:attribute>
                    </xsl:if>
                    <xsl:attribute name="width">100%</xsl:attribute>
                    <xsl:element name="fo:table-column"/>
                    <xsl:element name="fo:table-body">
                        <xsl:element name="fo:table-row">
                            <xsl:element name="fo:table-cell">
                                <xsl:element name="fo:table">
                                    <xsl:attribute name="width">100%</xsl:attribute>
                                    <xsl:element name="fo:table-column">
                                        <xsl:attribute name="column-width">0.2in</xsl:attribute>
                                        <xsl:attribute name="line-height">15pt</xsl:attribute>
                                    </xsl:element>
                                    <xsl:element name="fo:table-column">
                                        <xsl:attribute name="column-width">2.0in</xsl:attribute>
                                          <xsl:attribute name="line-height">15pt</xsl:attribute>
                                   </xsl:element>
                                    <xsl:element name="fo:table-column">
                                        <xsl:attribute name="column-width">5.0in</xsl:attribute>
                                        <xsl:attribute name="line-height">15pt</xsl:attribute>
                                    </xsl:element>

                                    <xsl:element name="fo:table-body">
                                        <xsl:element name="fo:table-row">
                                            <xsl:element name="fo:table-cell">
                                                <xsl:attribute name="font-weight">bold</xsl:attribute>
                                                <xsl:element name="fo:block">
                                                <xsl:if test="(position( )) = 1">
                                                &#160;
                                                </xsl:if>
                                                </xsl:element>
                                            </xsl:element>
                                            <xsl:element name="fo:table-cell">
                                                <xsl:attribute name="font-weight">bold</xsl:attribute>
                                                <xsl:element name="fo:block">
                                                <xsl:if test="(position( )) = 1">
                                               &#160;
                                                </xsl:if>
                                                </xsl:element>
                                            </xsl:element>
                                           <xsl:element name="fo:table-cell">
                                                 <fo:block>Filename</fo:block>
                                            </xsl:element> 
                                        </xsl:element>
                                    </xsl:element>
                                </xsl:element>
                            </xsl:element>
                        </xsl:element>
                    </xsl:element>
                </xsl:element>
            </xsl:element>
        </xsl:element>
                             <xsl:call-template name="attach_block">
                                <xsl:with-param name="block_num">7.</xsl:with-param>
                                <xsl:with-param name="block_title">Project Summary/Abstract*</xsl:with-param>
                                <xsl:with-param name="filename">
                                    <xsl:value-of select="RR_OtherProjectInfo_1_4:AbstractAttachments/RR_OtherProjectInfo_1_4:AbstractAttachment/att:FileName"/>
                                </xsl:with-param>
                            </xsl:call-template>
                            <!-- Block 7 End -->
                            <!-- Block 8  Begin -->
                            <xsl:call-template name="attach_block">
                                <xsl:with-param name="block_num">8.</xsl:with-param>
                                <xsl:with-param name="block_title">Project Narrative*</xsl:with-param>
                                <xsl:with-param name="filename">
                                    <xsl:value-of select="RR_OtherProjectInfo_1_4:ProjectNarrativeAttachments/RR_OtherProjectInfo_1_4:ProjectNarrativeAttachment/att:FileName"/>
                                </xsl:with-param>
                            </xsl:call-template>
                            <!-- Block 8 End -->
                            <!-- Block 9  Begin -->
                            <xsl:call-template name="attach_block">
                                <xsl:with-param name="block_num">9.</xsl:with-param>
                                <xsl:with-param name="block_title">Bibliography &amp; References Cited</xsl:with-param>
                                <xsl:with-param name="filename">
                                    <xsl:value-of select="RR_OtherProjectInfo_1_4:BibliographyAttachments/RR_OtherProjectInfo_1_4:BibliographyAttachment/att:FileName"/>
                                </xsl:with-param>
                            </xsl:call-template>
                            <!-- Block 9 End -->
                            <!-- Block 10  Begin -->
                            <xsl:call-template name="attach_block">
                                <xsl:with-param name="block_num">10.</xsl:with-param>
                                <xsl:with-param name="block_title">Facilities &amp; Other Resources</xsl:with-param>
                                <xsl:with-param name="filename">
                                    <xsl:value-of select="RR_OtherProjectInfo_1_4:FacilitiesAttachments/RR_OtherProjectInfo_1_4:FacilitiesAttachment/att:FileName"/>
                                </xsl:with-param>
                            </xsl:call-template>
                            <!-- Block 10 End -->
                            <!-- Block 11  Begin -->
                            <xsl:call-template name="attach_block">
                                <xsl:with-param name="block_num">11.</xsl:with-param>
                                <xsl:with-param name="block_title">Equipment</xsl:with-param>
                                <xsl:with-param name="filename">
                                    <xsl:value-of select="RR_OtherProjectInfo_1_4:EquipmentAttachments/RR_OtherProjectInfo_1_4:EquipmentAttachment/att:FileName"/>
                                </xsl:with-param>
                            </xsl:call-template>
                            <!-- Block 11 End -->
                            <!-- Block 12  Begin -->
                            <xsl:for-each select="RR_OtherProjectInfo_1_4:OtherAttachments/RR_OtherProjectInfo_1_4:OtherAttachment">
        <xsl:element name="fo:table-row">
            <xsl:element name="fo:table-cell">
                <xsl:attribute name="font-size">9px</xsl:attribute>
                <xsl:element name="fo:table">
                    <xsl:attribute name="border-style">solid</xsl:attribute>
                    <xsl:attribute name="border-color">black</xsl:attribute>
                    <xsl:if test="(position( )) = 1">
                    <xsl:attribute name="border-bottom-style">hidden</xsl:attribute>
                    </xsl:if>
                    <xsl:if test="(position( )) = last()">
                    <xsl:attribute name="border-top-style">hidden</xsl:attribute>
                    <xsl:attribute name="border-bottom-style">solid</xsl:attribute>
                    <xsl:attribute name="border-bottom-color">black</xsl:attribute>
                    </xsl:if>
                    <xsl:if test="(position( )) > 1 and position() &lt; last() ">
                    <xsl:attribute name="border-bottom-style">hidden</xsl:attribute>
                    <xsl:attribute name="border-top-style">hidden</xsl:attribute>
                    </xsl:if>
                    <xsl:attribute name="width">100%</xsl:attribute>
                    <xsl:element name="fo:table-column"/>
                    <xsl:element name="fo:table-body">
                        <xsl:element name="fo:table-row">
                       <!--  <xsl:attribute name="keep-with-next">always</xsl:attribute> -->
                            <xsl:element name="fo:table-cell">
                                <xsl:element name="fo:table">
                                    <xsl:attribute name="width">100%</xsl:attribute>
                                    <xsl:element name="fo:table-column">
                                        <xsl:attribute name="column-width">0.2in</xsl:attribute>
                                        <xsl:attribute name="line-height">15pt</xsl:attribute>
                                    </xsl:element>
                                    <xsl:element name="fo:table-column">
                                        <xsl:attribute name="column-width">2.0in</xsl:attribute>
                                        <xsl:attribute name="line-height">15pt</xsl:attribute>
                                    </xsl:element>
                                    <xsl:element name="fo:table-column">
                                        <xsl:attribute name="column-width">5.0in</xsl:attribute>
                                         <xsl:attribute name="line-height">15pt</xsl:attribute>
         								 <xsl:attribute name="border-top-width">1px</xsl:attribute>
         								 <xsl:attribute name="border-bottom-width">1px</xsl:attribute>
                                    </xsl:element>
                                    <xsl:element name="fo:table-body">
                                        <xsl:element name="fo:table-row">
                                            <xsl:element name="fo:table-cell">
                                                <xsl:attribute name="font-weight">bold</xsl:attribute>
                                                <xsl:element name="fo:block">
                                                <xsl:if test="(position( )) = 1">
                                                12.
                                                </xsl:if>
                                                </xsl:element>
                                            </xsl:element>
                                            <xsl:element name="fo:table-cell">
                                                <xsl:attribute name="font-weight">bold</xsl:attribute>
                                                <xsl:element name="fo:block">
                                                <xsl:if test="(position( )) = 1">
                                                Other Attachments
                                                </xsl:if>
                                                </xsl:element>
                                            </xsl:element>
                                            <xsl:element name="fo:table-cell">
                                            	<xsl:attribute name="font-family">arialuni</xsl:attribute>
                                                <xsl:element name="fo:block">
                                                    <xsl:value-of select="att:FileName"/>
                                                </xsl:element>
                                            </xsl:element>
                                        </xsl:element>
                                    </xsl:element>
                                </xsl:element>
                            </xsl:element>
                        </xsl:element>
                    </xsl:element>
                </xsl:element>
            </xsl:element>
        </xsl:element>
                            </xsl:for-each>
                            <!-- Block 12 End -->
                        </fo:table-body>
                    </fo:table>
                </fo:flow>
            </fo:page-sequence>
        </fo:root>
    </xsl:template>
    <!-- ================================ -->
    <!-- Format Date template -->
    <!-- ================================ -->
    <xsl:template name="formatDate">
        <xsl:param name="value"/>
        <xsl:if test="string-length($value) &gt; 0 and $value != '--'">
            <xsl:value-of select="format-number(substring($value,6,2), '00')"/>
            <xsl:text>-</xsl:text>
            <xsl:value-of select="format-number(substring($value,9,2), '00')"/>
            <xsl:text>-</xsl:text>
            <xsl:value-of select="format-number(substring($value,1,4), '0000')"/>
        </xsl:if>
    </xsl:template>
    <!-- ================================ -->
    <!-- Radio  template -->
    <!-- ================================ -->
    <xsl:template name="radio">
        <xsl:param name="value"/>
        <xsl:param name="radio_on_value"/>
        <xsl:choose>
            <xsl:when test="$value = $radio_on_value">
                <fo:inline font-family="ZapfDingbats" font-size="9px" padding-start="1pt" padding-end="1pt">&#x25cf;</fo:inline>
            </xsl:when>
            <xsl:otherwise>
                <fo:inline font-family="ZapfDingbats" font-size="9px" padding-start="1pt" padding-end="1pt">&#x274d;</fo:inline>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--                                      NEW NEW NEW NEW -->
    <!-- Block 7  Begin -->
    <xsl:template name="attach_block">
        <xsl:param name="block_num"/>
        <xsl:param name="block_title"/>
        <xsl:param name="filename"/>
        <xsl:param name="mimetype"/>
        <xsl:element name="fo:table-row">
         <xsl:attribute name="border-left-color">black</xsl:attribute>
         <xsl:attribute name="border-left-style">solid</xsl:attribute>
         <xsl:attribute name="border-left-width">1px</xsl:attribute>
         <xsl:attribute name="border-right-color">black</xsl:attribute>
         <xsl:attribute name="border-right-style">solid</xsl:attribute>
         <xsl:attribute name="border-right-width">1px</xsl:attribute>
    	 <xsl:attribute name="border-bottom-color">black</xsl:attribute>
         <xsl:attribute name="border-bottom-style">solid</xsl:attribute>
         <xsl:attribute name="border-bottom-width">1px</xsl:attribute>
            <xsl:element name="fo:table-cell">
                <xsl:attribute name="font-size">9px</xsl:attribute>
                <xsl:element name="fo:table">
                    <xsl:attribute name="width">100%</xsl:attribute>
                    <xsl:element name="fo:table-column"/>
                    <xsl:element name="fo:table-body">
                        <xsl:element name="fo:table-row">
                        	<xsl:attribute name="border-top-color">white</xsl:attribute>
         					<xsl:attribute name="border-top-style">solid</xsl:attribute>
                             <xsl:attribute name="border-top-width">1px</xsl:attribute>
                             <xsl:attribute name="border-bottom-color">white</xsl:attribute>
                             <xsl:attribute name="border-bottom-style">solid</xsl:attribute>
                             <xsl:attribute name="border-bottom-width">1px</xsl:attribute>
                            <xsl:element name="fo:table-cell">
                                <xsl:element name="fo:table">
                                    <xsl:attribute name="width">100%</xsl:attribute>
                                    <xsl:element name="fo:table-column">
                                        <xsl:attribute name="column-width">0.2in</xsl:attribute>
                                         <xsl:attribute name="line-height">15pt</xsl:attribute>
                                    </xsl:element>
                                    <xsl:element name="fo:table-column">
                                        <xsl:attribute name="column-width">2.0in</xsl:attribute>
                                         <xsl:attribute name="line-height">15pt</xsl:attribute>
                                    </xsl:element>
                                    <xsl:element name="fo:table-column">
                                        <xsl:attribute name="column-width">5.0in</xsl:attribute>
                                         <xsl:attribute name="line-height">15pt</xsl:attribute>
                                    </xsl:element>

                                    <xsl:element name="fo:table-body">
                                        <xsl:element name="fo:table-row">
                                            <xsl:element name="fo:table-cell">
                                                <xsl:attribute name="font-weight">bold</xsl:attribute>
                                                 <xsl:attribute name="line-height">15pt</xsl:attribute>
                                                 <xsl:attribute name="padding-start">2pt</xsl:attribute>
                                                 <xsl:attribute name="border-top-color">white</xsl:attribute>
         										 <xsl:attribute name="border-top-style">solid</xsl:attribute>
         										 <xsl:attribute name="border-top-width">1px</xsl:attribute>
                                                 <xsl:attribute name="border-bottom-color">white</xsl:attribute>
         										 <xsl:attribute name="border-bottom-style">solid</xsl:attribute>
         										 <xsl:attribute name="border-bottom-width">1px</xsl:attribute>
                                                 <xsl:element name="fo:block">
                                                    <xsl:value-of select="$block_num"/>
                                                </xsl:element>
                                            </xsl:element>
                                            <xsl:element name="fo:table-cell">
                                                 <xsl:attribute name="line-height">15pt</xsl:attribute>
                                                <xsl:attribute name="font-weight">bold</xsl:attribute>
                                                 <xsl:attribute name="border-top-color">white</xsl:attribute>
         										 <xsl:attribute name="border-top-style">solid</xsl:attribute>
         										 <xsl:attribute name="border-top-width">1px</xsl:attribute>
                                                 <xsl:attribute name="border-bottom-color">white</xsl:attribute>
         										 <xsl:attribute name="border-bottom-style">solid</xsl:attribute>
         										 <xsl:attribute name="border-bottom-width">1px</xsl:attribute>
                                                 <xsl:element name="fo:block">
                                                    <xsl:value-of select="$block_title"/>
                                                </xsl:element>
                                            </xsl:element>
                                            <xsl:element name="fo:table-cell">
                                                 <xsl:attribute name="line-height">15pt</xsl:attribute>
                                                 <xsl:attribute name="border-top-color">white</xsl:attribute>
         										 <xsl:attribute name="border-top-style">solid</xsl:attribute>
         										 <xsl:attribute name="border-top-width">1px</xsl:attribute>
                                                 <xsl:attribute name="border-bottom-color">white</xsl:attribute>
         										 <xsl:attribute name="border-bottom-style">solid</xsl:attribute>
         										 <xsl:attribute name="border-bottom-width">1px</xsl:attribute>
                                                 <xsl:attribute name="font-family">arialuni</xsl:attribute>
                                                <xsl:element name="fo:block">
                                                    <xsl:value-of select="$filename"/>
                                                </xsl:element>
                                            </xsl:element>
                                        </xsl:element>
                                    </xsl:element>
                                </xsl:element>
                            </xsl:element>
                        </xsl:element>
                    </xsl:element>
                </xsl:element>
            </xsl:element>
        </xsl:element>
    </xsl:template>
    <!-- Block 7 End -->
</xsl:stylesheet>
