/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.s2s.fetch.rest;

import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.propdev.impl.s2s.fetch.rest.search.SearchParams;
import org.kuali.coeus.propdev.impl.s2s.fetch.rest.search.SearchResults;
import org.kuali.coeus.propdev.impl.s2s.fetch.rest.status.StatusResults;
import org.kuali.coeus.propdev.impl.s2s.fetch.util.FetchUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

public class RestBasedGrantsGovResourceFetcher {
    private static final Predicate<byte[]> CONTAINS_HTML_PAGE = f -> new String((byte[])f).contains("<!DOCTYPE html>");
    private static final Predicate<byte[]> IS_EMPTY = ArrayUtils::isEmpty;
    private static final String PDF_DOWNLOAD_ENDPOINT = "https://www.grants.gov/grantsws/rest/forms/download/pdf/";
    private static final String INSTRUCTIONS_DOWNLOAD_ENDPOINT = "https://www.grants.gov/grantsws/rest/forms/download/instructions/";
    private static final String SCHEMA_DOWNLOAD_ENDPOINT = "https://www.grants.gov/grantsws/rest/forms/download/schema/";
    private static final String DAT_DOWNLOAD_ENDPOINT = "https://www.grants.gov/grantsws/rest/forms/download/dat/";
    private static final String FORMS_SEARCH_ENDPOINT = "https://www.grants.gov/grantsws/rest/forms/search/";
    private static final String FORMS_STATUS_ENDPOINT = "https://www.grants.gov/grantsws/rest/forms/report/status/";

    public static void main(String[] args) {
        String baseDir = FetchUtils.directoryArg(args);
        if (baseDir != null) {
            RestBasedGrantsGovResourceFetcher.fetchFromSearchRestEndpoint("all", baseDir + "/rest/active");
            RestBasedGrantsGovResourceFetcher.fetchFromSearchRestEndpoint("retiredForms", baseDir + "/rest/retired");
            RestBasedGrantsGovResourceFetcher.fetchFromStatusRestEndpoint(baseDir + "/rest/wip");
        }
    }

    private static void fetchFromSearchRestEndpoint(String formSet, String dir) {
        RestTemplate restTemplate = new RestTemplate();
        SearchParams params = new SearchParams();
        params.setFormSet(formSet);
        ResponseEntity response = restTemplate.postForEntity(FORMS_SEARCH_ENDPOINT, (Object)params, SearchResults.class, new Object[0]);
        ((Stream)((SearchResults)response.getBody()).getFamilies().stream().parallel()).flatMap(f -> (Stream)f.getForms().stream().parallel()).forEach(form -> RestBasedGrantsGovResourceFetcher.cleanSplit(form.getName(), ",").forEach(name -> RestBasedGrantsGovResourceFetcher.cleanSplit(form.getVersion(), ",").forEach(version -> RestBasedGrantsGovResourceFetcher.fetchResources(dir, name, version, form.getId()))));
    }

    private static Stream<String> cleanSplit(String string, String delim) {
        return Stream.of(string.split(delim)).filter(Objects::nonNull).map(String::trim).filter(StringUtils::isNotBlank);
    }

    private static void fetchFromStatusRestEndpoint(String dir) {
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity response = restTemplate.getForEntity(FORMS_STATUS_ENDPOINT, StatusResults.class, new Object[0]);
        ((Stream)((StatusResults)response.getBody()).getFormStatuses().stream().parallel()).forEach(form -> RestBasedGrantsGovResourceFetcher.fetchResources(dir, form.getFormName(), form.getFormVersion(), form.getFormId().toString()));
    }

    private static void fetchResources(String dir, String formName, String formVersion, String formId) {
        String pdfFile = RestBasedGrantsGovResourceFetcher.createPdfName(formName, formVersion);
        FetchUtils.fetch("https://apply07.grants.gov/apply/forms/sample/" + pdfFile, pdfFile, dir + "/pdf", RestBasedGrantsGovResourceFetcher.containsHtmlPage());
        FetchUtils.fetch(PDF_DOWNLOAD_ENDPOINT + formId, pdfFile, dir + "/pdf", RestBasedGrantsGovResourceFetcher.containsHtmlPage());
        String instructionsFile = RestBasedGrantsGovResourceFetcher.createInstructionsName(formName, formVersion);
        FetchUtils.fetch("https://apply07.grants.gov/apply/forms/instructions/" + instructionsFile, instructionsFile, dir + "/instructions", RestBasedGrantsGovResourceFetcher.containsHtmlPage());
        FetchUtils.fetch(INSTRUCTIONS_DOWNLOAD_ENDPOINT + formId, instructionsFile, dir + "/instructions", RestBasedGrantsGovResourceFetcher.containsHtmlPage());
        String schemaFile = RestBasedGrantsGovResourceFetcher.createSchemaName(formName, formVersion);
        FetchUtils.fetch("https://apply07.grants.gov/apply/forms/schemas/" + schemaFile, schemaFile, dir + "/xsd", RestBasedGrantsGovResourceFetcher.emptyBytes());
        FetchUtils.fetch(SCHEMA_DOWNLOAD_ENDPOINT + formId, schemaFile, dir + "/xsd", RestBasedGrantsGovResourceFetcher.emptyBytes());
        String nihXslFile = RestBasedGrantsGovResourceFetcher.createNihXslName(formName, formVersion);
        FetchUtils.fetch("https://grants.nih.gov/grants/ElectronicReceipt/files/" + nihXslFile, nihXslFile, dir + "/xsl", RestBasedGrantsGovResourceFetcher.containsHtmlPage());
        String xslFile = RestBasedGrantsGovResourceFetcher.createXslName(formName, formVersion);
        FetchUtils.fetch("https://apply07.grants.gov/apply/forms/fo/" + xslFile, xslFile, dir + "/xsl", RestBasedGrantsGovResourceFetcher.containsHtmlPage());
        String datFile = RestBasedGrantsGovResourceFetcher.createDatName(formName, formVersion, formId);
        FetchUtils.fetch("https://apply07.grants.gov/apply/forms/sample/" + datFile, datFile, dir + "/dat", RestBasedGrantsGovResourceFetcher.containsHtmlPage());
        FetchUtils.fetch(DAT_DOWNLOAD_ENDPOINT + formId, datFile, dir + "/dat", RestBasedGrantsGovResourceFetcher.containsHtmlPage());
    }

    private static String createPdfName(String formName, String formVersion) {
        return formName + "-V" + formVersion + ".pdf";
    }

    private static String createDatName(String formName, String formVersion, String formId) {
        return formName + "-V" + formVersion + "_F" + formId + ".xls";
    }

    private static String createInstructionsName(String formName, String formVersion) {
        return formName + "-V" + formVersion + "-Instructions.pdf";
    }

    private static String createSchemaName(String formName, String formVersion) {
        return formName + "-V" + formVersion + ".xsd";
    }

    private static String createNihXslName(String formName, String formVersion) {
        return formName + "-V" + formVersion + ".xsl";
    }

    private static String createXslName(String formName, String formVersion) {
        return formName + "-V" + formVersion + ".fo.xsl";
    }

    private static Predicate<byte[]> containsHtmlPage() {
        return CONTAINS_HTML_PAGE;
    }

    private static Predicate<byte[]> emptyBytes() {
        return IS_EMPTY;
    }
}

