<%--
  #%L
  %%
  Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>
<%@ tag import="org.kuali.kra.negotiations.document.authorization.NegotiationDocumentAuthorizer" %>
<%@ include file="/WEB-INF/jsp/kraTldHeader.jsp" %>


<c:url var="NegotiationURI" value="negotiationNegotiation.do">
    <c:param name="methodToCall" value="docHandler"/>
    <c:param name="docTypeName" value="NegotiationDocument"/>
    <c:param name="command" value="displayDocSearchView"/>
    <c:param name="docId" value="${KualiForm.docId}"/>
</c:url>
<display:table name="${KualiForm.negotiationActivityHistoryLineBeans}"
               export="${empty KualiForm.negotiationDocument.negotiation.objectId ? 'false' : 'true'}" id="row"
               class="datatable-100" cellpadding="2" cellspacing="0" requestURIcontext="false"
               requestURI="${NegotiationURI }"
               excludedParams="*">
    <display:column property="lineNumber" title="History Line #" style="height:20px;"/>
    <display:column property="activityType" title="Activity Type"/>
    <display:column property="location" title="Location"/>
    <display:column property="startDate" title="Start Date"/>
    <display:column property="endDate" title="End Date"/>
    <display:column property="activityDays" title="Activity Days"/>

    <c:choose>
        <c:when test="${KualiForm.editingMode[NegotiationDocumentAuthorizer.VIEW_UNRESTRICTED]}">
            <display:column property="activityDescription" title="Activity Description"/>
        </c:when>
        <c:otherwise>
            <display:column property="restrictedActivityDescription" title="Activity Description"/>
        </c:otherwise>
    </c:choose>

    <display:column property="locationDays" title="Location Days"/>
</display:table>
<c:if test="${empty KualiForm.negotiationDocument.negotiation.objectId}">
    <br/>
    <div.exportlinks>Export options: Save document to export table</div.exportlinks>
</c:if>
