<%--
  #%L
  %%
  Copyright (C) 2005 - 2020 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>
<%@ include file="/WEB-INF/jsp/kraTldHeader.jsp"%>
<%@ include file="/WEB-INF/jsp/kraExconTldHeader.jsp" %>

<c:set var="exconProjectAttachmentAttributes" value="${DataDictionary.ExconProjectAttachment.attributes}" />
<c:set var="exconProjectAttachmentsBean" value="${KualiForm.exconProjectAttachmentsBean}" />
<c:set var="action" value="notesAndAttachments" />
<c:set var="attachments" value="${KualiForm.document.exconProjectList[0].exconProjectAttachments}"/>

<kul:tab tabTitle="Attachments" tabItemCount="${fn:length(attachments)}" defaultOpen="true" tabErrorKey="exconProjectAttachmentsBean.newAttachment*,document.exconProjectList[0].exconProjectAttachments*" transparentBackground="false" useRiceAuditMode="true">
	<div class="tab-container" align="center">
   		<h3>
   			<span class="subhead-left">Add Attachment</span>
   			<span class="subhead-right"><kul:help businessObjectClassName="org.kuali.kra.excon.project.ExconProjectAttachment" altText="help"/></span>
       </h3>
       <table id="attachments-table" cellpadding="4" cellspacing="0" summary="">
         	<tr>
         	    <th>
         	    	&nbsp;
         	    </th>
         		<th>
         			<div align="center">
         				Attached Date
         			</div>
         		</th>
         		<th>
         			<div align="center">
         				Attaching User
         			</div>
         		</th>
         		<th>
         			<div align="center">
         				<kul:htmlAttributeLabel attributeEntry="${exconProjectAttachmentAttributes['typeCode']}" noColon="true"/>
         			</div>
         		</th>
         		<th>
					<div align="center">
						<kul:htmlAttributeLabel attributeEntry="${exconProjectAttachmentAttributes.description}" noColon="true"/>
					</div>
				</th>
         		<th>
					<div align="center">
						<kul:htmlAttributeLabel attributeEntry="${exconProjectAttachmentAttributes['fileId']}" noColon="true"/>
					</div>
				</th>
         		<th>
					<div align="center">
						Actions
					</div>
				</th>
             </tr>
             
                <c:if test="${!readOnly}">
                <tbody class="addline">
	             <tr>
	                <th align="center" valign="middle" class="infoline">
	                	<div align="center">
	                		Add
		            	</div>
					</th>
	                <td align="left" valign="middle" class="infoline">
	                	<div align="left">
							&nbsp;
		            	</div>
					</td>
	                <td align="left" valign="middle" class="infoline">
	                	<div align="left">
	                		&nbsp;
	                	</div>
					</td>
	         		<td class="infoline">
	              		<div align="center">
	            			<kul:htmlControlAttribute property="exconProjectAttachmentsBean.newAttachment.typeCode" attributeEntry="${exconProjectAttachmentAttributes.typeCode}" />
	              		</div>
	            	</td>
					<td align="left" valign="middle" class="infoline">
	                	<div align="left">
	                		<kul:htmlControlAttribute property="exconProjectAttachmentsBean.newAttachment.description" attributeEntry="${exconProjectAttachmentAttributes.description}"/>
		            	</div>
					</td>
					<td align="left" valign="middle" class="infoline">
	              		<div align="left">
	              		    <c:set var="property" value="exconProjectAttachmentsBean.newAttachment.newFile" />
	              		
	              		    <%-- attachment file error handling logic start--%>
	               				<kul:checkErrors keyMatch="${property}" auditMatch="${property}"/>
	               				<%-- highlighting does not work in firefox but does in ie... --%>
	               				<c:set var="textStyle" value="${hasErrors == true ? 'background-color:#FFD5D5' : ''}"/>
	               			<%-- attachment file error handling logic start--%>
	              		
	              			<html:file property="${property}" style="${textStyle}"/>
	           			</div>
					</td>
					<td align="center" valign="middle" class="infoline">
						<div align="center">
							<kul:kualiButton property="methodToCall.addAttachment.anchor${tabKey}"
											 src="${ConfigProperties.kr.externalizable.images.url}tinybutton-add1.gif"
											 label="Add" title="Add Attachment" styleClass="tinybutton addButton small outline" />
						</div>
					</td>
				</tr>
				</tbody>
			 </c:if>
				
			<c:forEach var="attachment" items="${attachments}" varStatus="itrStatus">
				<tr>
	         		<th>
	         			<div align="center">
	                		${itrStatus.index + 1}
		            	</div>
	         		</th>
	         		<td align="left" valign="middle">
	                	<div align="left">
							${attachment.attachDateStr}
	   			       	</div>
					</td>
	         		<td align="left" valign="middle">
	                	<div align="left">
							${attachment.attachUserName}
						</div>
					</td>
	         		<td align="left" valign="middle">
	                	<div align="left">
	                		<kul:htmlControlAttribute property="document.exconProjectList[0].exconProjectAttachments[${itrStatus.index}].type.description" attributeEntry="${exconProjectAttachmentAttributes['typeCode']}" readOnly="true" readOnlyAlternateDisplay ="${exconProjectAttachment.type.description}"/>
		            	</div>
					</td>
					<td align="left" valign="middle">
	                	<div align="left">
	                		<kul:htmlControlAttribute property="document.exconProjectList[0].exconProjectAttachments[${itrStatus.index}].description" attributeEntry="${exconProjectAttachmentAttributes.description}" readOnly="true"/>
		            	</div>
					</td>
	       			<td align="left" valign="middle">
	           			<div align="left" id="attachmentFileName${itrStatus.index}">
	              			<kra:fileicon attachment="${attachment.file}"/>${attachment.file.name}
	           			</div>
					</td>
					<td align="center" valign="middle">
						<div align="center">
							<kul:kualiButton property="methodToCall.viewAttachment.line${itrStatus.index}.anchor${currentTabIndex}"
											 src="${ConfigProperties.kra.externalizable.images.url}tinybutton-view.gif"
											 label="View" title="View Attachment" styleClass="tinybutton small outline"
											 onclick="excludeSubmitRestriction = true;" />
								<c:if test="${!readOnly}">
									<kul:kualiButton property="methodToCall.deleteAttachment.line${itrStatus.index}.anchor${currentTabIndex}"
													 src="${ConfigProperties.kra.externalizable.images.url}tinybutton-delete1.gif"
													 label="Delete" title="Delete Attachment" styleClass="tinybutton small outline" />
							    </c:if>
						</div>
					</td>
	         	</tr>
			</c:forEach>
		</table>
     </div>		
</kul:tab>
