<%--
  #%L
  %%
  Copyright (C) 2005 - 2020 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>
<%@ include file="/WEB-INF/jsp/kraTldHeader.jsp"%>
<%@ include file="/WEB-INF/jsp/kraExconTldHeader.jsp"%>

<c:set var="exconProjectAttributes" value="${DataDictionary.ExconProject.attributes}" />
<c:set var="RPSEntityAttributes" value="${DataDictionary.ExconProjectRPSEntity.attributes}" />
<c:set var="RPSResultAttributes" value="${DataDictionary.ExconProjectRPSResult.attributes}" />

<c:set var="readOnly" value="${not KualiForm.editingMode['fullEntry']}" scope="request" />
<c:set var="action" value="exconProjectContacts" />


    <div class="tab-container" align="center">
        <h3>
            <span class="subhead-left">RPS Results</span>
            <span class="subhead-right"><kul:help parameterNamespace="KC-EXCON" parameterDetailType="Document" parameterName="exconProjectRPSResultsHelpUrl" altText="help"/></span>
        </h3>
        <table cellpadding="0" cellspacing="0" summary="">
            <tr>
                <th>&nbsp;</th>
                <th>Search Date</th>
                <th>Searching User</th>
                <th>Number Of Matches</th>
                <th>
                    <div align="center">Actions</div>
                </th>
            </tr>

            <c:forEach var="result"
                       items="${KualiForm.exconProjectRPSResultsBean.exconProjectRPSResults}"
                       varStatus="rpsResultsRowStatus">
                <tr>
                    <th class="infoline" scope="row">
                        <c:out value="${rpsResultsRowStatus.index + 1}" />
                    </th>
                    <td valign="middle">
                            ${result.rpsSearchDate}
                    </td>
                    <td valign="middle">
                            ${result.searchingUserName}
                    </td>
                    <td valign="middle">
                        ${result.numMatches}
                    </td>

                    <td>
                        <div align="center">
                            <kul:kualiButton property="methodToCall.refresh"
                                             src="${ConfigProperties.kra.externalizable.images.url}tinybutton-view.gif"
                                             label="View" title="View Results" styleClass="tinybutton small outline"
                                             onclick="openNewWindow('exconProjectContacts','viewRPSResult','${rpsResultsRowStatus.index}','${KualiForm.formKey}','${KualiForm.document.sessionDocument}');return false;" />
                            <c:choose>
                                <c:when test="${!readOnly}">
                                    <kul:kualiButton property="methodToCall.deleteRPSResult.line${rpsResultsRowStatus.index}.anchor${currentTabIndex}"
                                                     src="${ConfigProperties.kra.externalizable.images.url}tinybutton-delete1.gif"
                                                     label="Delete" title="Delete Results" styleClass="tinybutton small outline" />
                                </c:when>
                                <c:otherwise>&nbsp;
                                </c:otherwise>
                            </c:choose>
                        </div>
                    </td>
                </tr>
            </c:forEach>

        </table>
    </div>

