<%--
  #%L
  %%
  Copyright (C) 2005 - 2020 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>
<%@ include file="/WEB-INF/jsp/kraTldHeader.jsp"%>
<%@ include file="/WEB-INF/jsp/kraExconTldHeader.jsp"%>

<c:set var="exconProjectAttributes" value="${DataDictionary.ExconProject.attributes}" />
<c:set var="exconProjectDestinationAttributes" value="${DataDictionary.ExconProjectDestination.attributes}" />
<c:set var="exconProjectPersonAttributes" value="${DataDictionary.ExconProjectPerson.attributes}" />
<c:set var="exconProjectEmailAttributes" value="${DataDictionary.ExconProjectEmailContent.attributes}" />

<c:set var="readOnly" value="${not KualiForm.editingMode['fullEntry']}" scope="request" />
<c:set var="action" value="exconProjectActions" />

<kul:tab tabTitle="Communications" defaultOpen="true" useRiceAuditMode="true" tabErrorKey="exconProjectEmailBean*" tabAuditKey="exconProjectEmailBean*" auditCluster="communicationsAuditErrors">
	<div class="tab-container" align="center">
	<h3>
		<span class="subhead-left">${KualiForm.exconProject.traveler != null ? 'Trip Info' : 'Person Info'}</span>
		<span class="subhead-right"><kul:help parameterNamespace="KC-EXCON" parameterDetailType="Document" parameterName="exconProjectEventsHelpUrl" altText="help"/></span>
	</h3>
	<table cellpadding="0" cellspacing="0" summary="">
		<c:if test="${KualiForm.exconProject.person.isPresent()}">
			<c:set var="person" value="${KualiForm.exconProject.person.get()}"/>
			<tr>
				<th>Name</th>
				<th>Email</th>
				<th>Unit</th>
			</tr>
			<tr>
				<td><div align="center">${person.fullName}</div></td>
				<td><div align="center"><a href="mailto:${person.person.emailAddress}">${person.person.emailAddress}</a></div></td>
				<td><div align="center">
				<c:if test="${person.isUnitRestricted}">
					<font color="red">
				</c:if>
				${person.person.unit.unitName}
				<c:if test="${person.isUnitRestricted}">
					</font>
				</c:if>
				</div>
				</td>
			</tr>
		</c:if>			
		
	</table>
	<table cellpadding="0" cellspacing="0" summary="">
		<tr>
			<th>Destination Country</th>
			<th>Arrival Date</th>
			<th>Departure Date</th>
			<th>Sanction List</th>
			<th>Comment</th>
		</tr>
		
		<c:forEach var="destinations"
			items="${KualiForm.exconProject.exconProjectDestinations}"
			varStatus="projectDestinationRowStatus">
			<tr>
				<td>
					<div align="center">${destinations.destinationCountryName}</div>
				</td>
				<td align="center">
					<div align="center">${destinations.arrivalDateStr}</div>
				</td>
				<td align="center">
					<div align="center">${destinations.departureDateStr}</div>
				</td>
				<td align="center">
					<div align="center"><font color="red">${destinations.sanctionListName}</font></div>
				</td>
				<td align="center">
					<div align="center">${destinations.destinationComment}</div>
				</td>
			</tr>
		</c:forEach>			
	</table>
	<h3>
		<span class="subhead-left">Correspondence</span>
	</h3>
	<table cellpadding="0" cellspacing="0">
		<tr>
			<th width="25%">Communication Date</th>
			<th width="50%">Content/Agenda</th>
			<th>Comment</th>
		</tr>
		<c:forEach var="communication"
			items="${KualiForm.exconProject.travelerCommunications}"
			varStatus="communicationRowStatus">	
			<tr>
				<td><div align="center">${communication.communicationDateStr}</div></td>
				<td><div align="center">${communication.description}</div></td>
				<td><div align="center">${communication.travelComment}</div></td>
			</tr>	
		</c:forEach>
	</table>
	
	<c:if test="${not readOnly}">
	<table cellpadding="0" cellspacing="0">
		<tr><th colspan="6">&nbsp;</th></tr>
		<tr>
		<td width="20%">
		<div align="right">
		<b>Meeting Agenda</b>
		</div>
		</td>
		<td>
		<div align="right">
		<kul:htmlControlAttribute property="exconProjectEmailBean.newAgenda.contentCode" attributeEntry="${exconProjectEmailAttributes.contentCodeAgenda}" />
		</div>
		</td>
		<td>
			<div align="center">
				<c:choose>
				<c:when test="${!readOnly}">
					<kul:kualiButton property="methodToCall.addMeetingAgenda"
									 src="${ConfigProperties.kr.externalizable.images.url}tinybutton-add1.gif"
									 label="Add" title="Add Meeting Agenda" styleClass="tinybutton addButton small outline" />
				</c:when>
				<c:otherwise>&nbsp;
				</c:otherwise>
				</c:choose>
			</div>
		</td>
		<td width="20%">
		<div align="right">
		<b>Send Email:</b>
		</div>
		<td>
			<div align="right">
				<div>
					<b>Email Content:</b>&nbsp;&nbsp;<kul:htmlControlAttribute property="exconProjectEmailBean.newBody.contentCodeBody" attributeEntry="${exconProjectEmailAttributes.contentCodeBody}" />
				</div>
				<div style="margin-top: 10px;">
					<b>Email Attachment:</b>&nbsp;&nbsp;<kul:htmlControlAttribute property="exconProjectEmailBean.newAttachment.contentCodeAttachment" attributeEntry="${exconProjectEmailAttributes.contentCodeAttachment}" />
				</div>
			</div>
		</td>
		<td>
			<div align="center">
				<c:choose>
				<c:when test="${!readOnly}">
					<kul:kualiButton property="methodToCall.sendEmail"
									 src="${ConfigProperties.kr.externalizable.images.url}tinybutton-send.gif"
									 label="Send" title="Send Email" styleClass="tinybutton small outline" />
				</c:when>
				<c:otherwise>&nbsp;
				</c:otherwise>
				</c:choose>
			</div>
		</td>
	</table>
	</c:if>
	</div>

</kul:tab>
