<%--
  #%L
  %%
  Copyright (C) 2005 - 2020 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.

  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>

<%@ include file="/kr/WEB-INF/jsp/tldHeader.jsp"%>
<%@ attribute name="src" required="true" description="Image source if this button is being rendered as an image." %>
<%@ attribute name="label" required="true" description="Label if this button is being rendered as a submit input." %>
<%@ attribute name="property" required="true" description="The property being rendered." %>

<%@ attribute name="styleClass" required="false" description="Any CSS classes to pass along to the underlying input." %>
<%@ attribute name="onclick" required="false" description="Javascript onClick handler." %>
<%@ attribute name="disabled" required="false" description="Whether this button should be rendered as disabled or not." %>
<%@ attribute name="disabledSrc" required="false" description="Optional different image source to render if this button is disabled." %>
<%@ attribute name="title" required="false" description="Descriptive text for this button's purpose." %>
<%@ attribute name="alt" required="false" description="Alternative text describing this button to screen readers." %>
<%@ attribute name="tabindex" required="false" description="Explicit tab index (generally not needed for buttons)." %>

<c:if test="${alt == null or alt.blank}">
    <c:set var="alt" value="${title}" />
</c:if>

<c:set var="kuiEnabled" value="${ConfigProperties.kuali.ui.enabled eq 'true'}" />

<c:if test="${kuiEnabled}">
    <c:set var="styleClass" value="${styleClass} kui" />
</c:if>

<c:if test="${!kuiEnabled and disabled eq 'true' and disabledSrc != null}">
    <c:set var="src" value="${disabledSrc}" />
</c:if>

<c:choose>
    <c:when test="${kuiEnabled}">
        <html:submit value="${label}" styleClass="${styleClass}" property="${property}"
                     title="${title}" alt="${alt}" onclick="${onclick}" disabled="${disabled}"
                     tabindex="${tabindex}" />
    </c:when>
    <c:otherwise>
        <html:image src="${src}" styleClass="${styleClass}" property="${property}"
                     title="${title}" alt="${alt}" onclick="${onclick}" disabled="${disabled}"
                     tabindex="${tabindex}" />
    </c:otherwise>
</c:choose>
