<%--
  #%L
  %%
  Copyright (C) 2005 - 2020 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>

<%@ include file="/kr/WEB-INF/jsp/tldHeader.jsp"%>

<%@ attribute name="displayTopicFieldInNotes" required="false" description="Whether to display the note topic column in the table of notes." %>
<%@ attribute name="attachmentTypesValuesFinderClass" required="false" description="A finder class to give options for the types of attachments allowed as as note attachments on this document." %>
<%@ attribute name="transparentBackground" required="false" description="Whether the tab should render as having the background transparent around the corners of the tab." %>
<%@ attribute name="defaultOpen" required="false" description="Whether the tab for the notes is rendered as open." %>
<%@ attribute name="preserveWhitespace" required="false" description="Whether to preserve the whitespace contained inside the text of the notes." %>
<%@ attribute name="readOnly" required="false" description="Whether notes should be editable or not." %>

<c:set var="noteColSpan" value="6" />

<c:set var="documentNotes" value="${KualiForm.document.notes}" />
<c:set var="propPrefix" value="document." />

<c:set var="documentTypeName" value="${KualiForm.docTypeName}" />
<c:set var="documentEntry" value="${DataDictionary[documentTypeName]}" />
<c:set var="allowsNoteAttachments" value="${documentEntry.allowsNoteAttachments}" />
<c:set var="allowsNoteFYI" value="${documentEntry.allowsNoteFYI}" />
<c:set var="tabTitle" value="Notes and Attachments" />
<c:if test="${allowsNoteAttachments eq false}">
  <c:set var="tabTitle" value="Notes" />
</c:if>

<c:if test="${not empty attachmentTypesValuesFinderClass}">
  <c:set var="noteColSpan" value="${noteColSpan + 1}" />
</c:if>

<c:if test="${empty displayTopicFieldInNotes}">
  <c:set var="displayTopicFieldInNotes" value="${documentEntry.displayTopicFieldInNotes}" />
</c:if>

<c:if test="${displayTopicFieldInNotes eq true}">
  <c:set var="noteColSpan" value="${noteColSpan + 1}" />
</c:if>

<kul:tab tabTitle="${tabTitle}" defaultOpen="${!empty documentNotes or (not empty defaultOpen and defaultOpen)}" tabErrorKey="${Constants.DOCUMENT_NOTES_ERRORS},attachmentFile" tabItemCount="${fn:length(documentNotes)}" transparentBackground="${transparentBackground}" >
    <c:set var="notesAttributes" value="${DataDictionary.Note.attributes}" />
    <div class="tab-container" align=center id="G4">
    <p align=left><jsp:doBody/>
  <h3>${tabTitle}</h3>
        <table cellpadding="0" cellspacing="0" class="datatable" summary="view/add notes">
            <tbody>
                <tr>
                    <kul:htmlAttributeHeaderCell literalLabel="&nbsp;" scope="col" align="left"/>
                    <kul:htmlAttributeHeaderCell attributeEntry="${notesAttributes.notePostedTimestamp}" hideRequiredAsterisk="true" scope="col" align="left"/>
                    <kul:htmlAttributeHeaderCell attributeEntry="${notesAttributes.authorUniversalIdentifier}" hideRequiredAsterisk="true" scope="col" align="left"/>

<%-- NEED TO ADD THIS TOPIC FIELD TO DATABASE REMOVE THIS COMMENT ONCE FIELD IS THERE--%>

                    <c:if test="${displayTopicFieldInNotes eq true}">
            <kul:htmlAttributeHeaderCell attributeEntry="${notesAttributes.noteTopicText}" forceRequired="true" labelFor="newNote.noteTopicText" scope="col" align="left" />
          </c:if>
                     <kul:htmlAttributeHeaderCell attributeEntry="${notesAttributes.noteText}" labelFor="newNote.noteText" scope="col" align="left"/>
                    <c:if test="${allowsNoteAttachments eq true}">
                      <kul:htmlAttributeHeaderCell attributeEntry="${notesAttributes.attachment}" labelFor="attachmentFile" scope="col" align="left"/>
                    </c:if>
                    <c:if test="${(not empty attachmentTypesValuesFinderClass) and (allowsNoteAttachments eq true)}">
                      <kul:htmlAttributeHeaderCell literalLabel="Attachment Type" scope="col" align="left"/>
                    </c:if>
                    <c:if test="${allowsNoteFYI}" >
                      <kul:htmlAttributeHeaderCell literalLabel="Notification Recipient" scope="col"/>
                    </c:if>
                    <kul:htmlAttributeHeaderCell literalLabel="Actions" scope="col"/>
                </tr>
				<c:if test="${!readOnly && (((not empty attachmentTypesValuesFinderClass) and (allowsNoteAttachments eq true)) || kfunc:canAddNoteAttachment(KualiForm.document))}" >
                  <html:hidden property="newNote.noteTypeCode" value="${KualiForm.document.noteType.code}"/>
                  <tr>
                      <kul:htmlAttributeHeaderCell literalLabel="add:" scope="row"/>
                      <td class="infoline">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
                      <td class="infoline">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
                      <c:if test="${displayTopicFieldInNotes eq true}">
                       <td class="infoline"><kul:htmlControlAttribute attributeEntry="${notesAttributes.noteTopicText}" property="newNote.noteTopicText" forceRequired="true" /></td>
                      </c:if>
                      <td class="infoline"><kul:htmlControlAttribute attributeEntry="${notesAttributes.noteText}" property="newNote.noteText" forceRequired="${notesAttributes.noteText.required}" /></td>
                      <c:if test="${allowsNoteAttachments eq true}">
                        <td class="infoline">
                          <div align="center"><br />
                          <html:file property="attachmentFile" size="30" styleId="attachmentFile" value="" /><br /><br />
                          <html:image property="methodToCall.cancelBOAttachment" src="${ConfigProperties.kr.externalizable.images.url}tinygrey-cancel.gif" title="Cancel Attachment" alt="Cancel Attachment" styleClass="tinybutton"/>
                          </div>
                        </td>
                     </c:if>
                     <c:if test="${(not empty attachmentTypesValuesFinderClass) and (allowsNoteAttachments eq true)}">
                        <c:set var="finderClass" value="${fn:replace(attachmentTypesValuesFinderClass,'.','|')}"/>
                        <td class="infoline">
                            <html:select property="newNote.attachment.attachmentTypeCode">
                                <html:optionsCollection property="actionFormUtilMap.getOptionsMap${Constants.ACTION_FORM_UTIL_MAP_METHOD_PARM_DELIMITER}${finderClass}" label="value" value="key"/>
                            </html:select>
                        </td>
                     </c:if>
                     <c:if test="${allowsNoteFYI}" >
                      <td>&nbsp;</td>
                     </c:if>
                     <td class="infoline"><div align="center">
                         <kul:kualiButton property="methodToCall.insertBONote"
                                          src="${ConfigProperties.kr.externalizable.images.url}tinybutton-add1.gif"
                                          label="Add" title="Add a Note" styleClass="tinybutton small outline"/>
                     </div></td>
			       </tr>
			   </c:if>

  <c:forEach var="note" items="${documentNotes}" varStatus="status">

	<c:set var="authorUniversalIdentifier" value = "${note.authorUniversalIdentifier}" />
	<c:if test="${kfunc:canViewNoteAttachment(KualiForm.document, null)}" >
      <tr>
            <kul:htmlAttributeHeaderCell literalLabel="${status.index + 1}" scope="row"/>
            <td class="datacell center">
			<bean:write name="KualiForm" property="${propPrefix}note[${status.index}].notePostedTimestamp"/>
            &nbsp;</td>

                        <td class="datacell center">
                        <bean:write name="KualiForm" property="${propPrefix}note[${status.index}].authorUniversal.name"/>
<%-- NEED TO ADD THIS TOPIC FIELD TO DATABASE --%>
                        <c:if test="${displayTopicFieldInNotes eq true}">
                          <td class="datacell center">
                          <bean:write name="KualiForm" property="${propPrefix}note[${status.index}].noteTopicText"/></td>
                        </c:if>

                        <td class="datacell center">
                        <%-- 
     					 * Modified the display of the contents of a note to preserve the
     					 * whitespace by default.  If the preserveWhitespace attribute is 
     					 * set to false then this behavior is suppressed. 
     					 --%>
     					 <c:if test="${empty preserveWhitespace or preserveWhitespace}">
                           <kul:preserveWhitespace><bean:write name="KualiForm" property="${propPrefix}note[${status.index}].noteText" /></kul:preserveWhitespace>
                         </c:if>
                         <c:if test="${not empty preserveWhitespace and not preserveWhitespace}">
                           <bean:write name="KualiForm" property="${propPrefix}note[${status.index}].noteText" />
                         </c:if></td>
                         
            <%-- use caution if you rename either of these two variables.  It seems that the properties are not read in sequentially
                 but instead in some other arbitrary way (sorted alphabetically?) and therefore you may end up with a reference to a null authorUniversal object --%>
                        <%--<html:hidden property="${propPrefix}boNote[${status.index}].authorUniversal.principalId" />--%>

<%-- won't work until I add attachment logic to action --%>

                            <c:choose>
                                <c:when test="${(!empty note.attachment) and (note.attachment.complete)}">
                                  <td class="datacell center">
                                    
                                    <c:if test="${allowsNoteAttachments eq true}">
                                      <c:if test="${(!empty note.attachment)}">
										<c:set var="attachmentTypeCode" value ="${note.attachment.attachmentTypeCode}" />
                    <c:set var="mimeTypeCode" value="${note.attachment.attachmentMimeTypeCode}" />
									  </c:if>
                                      <c:if test="${kfunc:canViewNoteAttachment(KualiForm.document, attachmentTypeCode)}" >
                                        <html:image property="methodToCall.downloadBOAttachment.attachment[${status.index}]" src="${ConfigProperties.kr.externalizable.images.url}${kfunc:getAttachmentImageForUrl(mimeTypeCode)}" title="download attachment" alt="download attachment" style="padding:5px" onclick="excludeSubmitRestriction=true"/>
                                      </c:if>
                                      <bean:write name="KualiForm" property="${propPrefix}note[${status.index}].attachment.attachmentFileName"/>
                                      &nbsp;
                                      &nbsp;
                                      <span style="white-space: nowrap">
                                        <kul:fileSize byteSize="${note.attachment.attachmentFileSize}">
                                            (<c:out value="${fileSize} ${fileSizeUnits}" />,  <bean:write name="KualiForm" property="${propPrefix}note[${status.index}].attachment.attachmentMimeTypeCode"/>)
                                        </kul:fileSize>
                                      </span>
                                    </c:if>
                                  </td>
                                  <c:if test="${(not empty attachmentTypesValuesFinderClass) and (allowsNoteAttachments eq true)}">
                                     <td class="datacell center">
                                     &nbsp;
									 <c:set var="mapKey" value = "getOptionsMap${Constants.ACTION_FORM_UTIL_MAP_METHOD_PARM_DELIMITER}${finderClass}" />
									 <c:set var="attachmentTypeFinderMap" value="${KualiForm.actionFormUtilMap[mapKey]}"  />
                                       <c:forEach items="${attachmentTypeFinderMap}" var="type">
                                         <c:if test="${type.key eq note.attachment.attachmentTypeCode}">${type.value}</c:if>
                                       </c:forEach>
                                     </td>
                                  </c:if>
                                </c:when>
                                <c:otherwise>
                                    <td class="datacell center">&nbsp;</td>
                                    <c:if test="${(not empty attachmentTypesValuesFinderClass) and (allowsNoteAttachments eq true)}">
                                        <td class="datacell center">&nbsp;</td>
                                    </c:if>
                                </c:otherwise>
                            </c:choose>

                            <c:if test="${allowsNoteFYI}" >
                              <td class="infoline">
                                <c:if test="${!empty KualiForm.documentActions[Constants.KUALI_ACTION_CAN_SEND_NOTE_FYI]}">
                             <kul:user userIdFieldName="${propPrefix}note[${status.index}].adHocRouteRecipient.id" 
                              userId="${note.adHocRouteRecipient.id}" 
                              universalIdFieldName=""
                              universalId=""
                              userNameFieldName="${propPrefix}note[${status.index}].adHocRouteRecipient.name"
                              userName="${note.adHocRouteRecipient.name}"
                              readOnly="false" 
                              fieldConversions="principalName:${propPrefix}note[${status.index}].adHocRouteRecipient.id,name:${propPrefix}note[${status.index}].adHocRouteRecipient.name" 
                              lookupParameters="${propPrefix}note[${status.index}].adHocRouteRecipient.id:principalName" />
                            </c:if>
                            <c:if test="${empty KualiForm.documentActions[Constants.KUALI_ACTION_CAN_SEND_NOTE_FYI]}">
                              &nbsp;
                            </c:if>
                             </td>
                           </c:if>

                        <c:if test="${!readOnly}">
                            <td class="datacell center"><div align="center">
                              <c:if test="${kfunc:canDeleteNoteAttachment(KualiForm.document, attachmentTypeCode, authorUniversalIdentifier)}">
                                  <kul:kualiButton property="methodToCall.deleteBONote.line${status.index}"
                                                   src="${ConfigProperties.kr.externalizable.images.url}tinybutton-delete1.gif"
                                                   disabledSrc="${ConfigProperties.kr.externalizable.images.url}tinybutton-delete2.gif"
                                                   label="Delete" title="Delete a Note" styleClass="tinybutton small outline" />
                              </c:if> &nbsp;
                              <c:if test="${allowsNoteFYI && !empty KualiForm.documentActions[Constants.KUALI_ACTION_CAN_SEND_NOTE_FYI]}" >
                                  <kul:kualiButton property="methodToCall.sendNoteWorkflowNotification.line${status.index}"
                                                   src="${ConfigProperties.kr.externalizable.images.url}tinybutton-send.gif"
                                                   label="Send" title="Send FYI" styleClass="tinybutton small outline" />
                              </c:if>
                            </div></td>
                        </c:if>
                    </tr>
	</c:if>
  </c:forEach>
              </tbody>
        </table>
    </div>
</kul:tab>
