<%--
  #%L
  %%
  Copyright (C) 2005 - 2020 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>
<%@ include file="/WEB-INF/jsp/kraTldHeader.jsp"%>
<%@ include file="/WEB-INF/jsp/kraExconTldHeader.jsp"%>
<%@ include file="/WEB-INF/jsp/kraNuiTldHeader.jsp"%>

<c:set var="exconIntlShipmentAttributes" value="${DataDictionary.ExconIntlShipment.attributes}" />

<c:set var="readOnly" value="${not KualiForm.editingMode['fullEntry']}" scope="request" />
<c:set var="action" value="exconIntlShipment" />

<kul:tabTop tabTitle="" defaultOpen="true" tabErrorKey="document.exconProjectList[0].*" tabAuditKey="document.exconProjectList[0].*">

    <div class="tab-container">

        <table style="border-bottom-width:0px; border-bottom-style:none; border-bottom-color:transparent" summary="">
            <tr><td colspan="4">&nbsp;</td></tr>
            <tr>
                <th colspan="4" style="font-size: large"><div align="middle">International Shipping Checklist for Colorado State University</div></th>
            </tr>
            <tr><td colspan="4">&nbsp;</td></tr>
            <tr>
                <th colspan="4">
                    To protect you, the members of your research team or department, and the university, please make
                    all international shipments through Central Receiving, and answer the questions below.
                </th>
            </tr>
            <tr><td colspan="4"><hr></td></tr>

            <tr>
                <td width="10%">&nbsp;</td>
                <td>&nbsp;</td>
                <td><b>Shipment ID:</b></td>
                <td>
                    <c:choose>
                        <c:when test="${empty KualiForm.document.exconIntlShipmentList[0].shipmentId}">
                            <span style='color: red;'>Assigned after submission</span>
                        </c:when>
                        <c:otherwise>
                            <c:out value="${KualiForm.document.exconIntlShipmentList[0].shipmentId}" />
                        </c:otherwise>
                    </c:choose>
                </td>
            </tr>

            <tr>
                <td colspan="2"></td>
                <td id="applicantId" class="grid" class="infoline">
                    <b>* <kul:htmlAttributeLabel attributeEntry="${exconIntlShipmentAttributes.applicantId}" /></b>
                </td><td>
                <kra-nui:dynamicLookup property="exconIntlShipmentBean.exconIntlShipment.applicantId" attributeEntry="${exconIntlShipmentAttributes.applicantId}"
                                       readOnlyAlternateDisplay="${KualiForm.exconIntlShipmentBean.exconIntlShipment.applicantName}" placeHolder="Type: Last, First"
                                       searchMethod="findPersons"
                                       readOnly="${readOnly || !KualiForm.exconIntlShipmentBean.exconIntlShipment.isAdmin}"/>

            </td>
            </tr>

            <tr>
                <td colspan="2"></td>
                <td id="supervisorId" class="grid" class="infoline">
                    <b>* <kul:htmlAttributeLabel attributeEntry="${exconIntlShipmentAttributes.supervisorId}" /></b>
                </td><td>
                <kra-nui:dynamicLookup property="exconIntlShipmentBean.exconIntlShipment.supervisorId" attributeEntry="${exconIntlShipmentAttributes.supervisorId}"
                                       readOnlyAlternateDisplay="${KualiForm.exconIntlShipmentBean.exconIntlShipment.supervisorName}" placeHolder="Type: Last, First"
                                       searchMethod="findPersons"/>
            </td>
            </tr>

            <tr>
                <td colspan="2">&nbsp;</td>
                <td class="grid" class="infoline">
                    <b>* <kul:htmlAttributeLabel attributeEntry="${exconIntlShipmentAttributes.unitNumber}"/></b>
                </td><td>
                <kra-nui:dynamicLookup property="exconIntlShipmentBean.exconIntlShipment.unitNumber" attributeEntry="${exconIntlShipmentAttributes.unitNumber}"
                                       readOnlyAlternateDisplay="${KualiForm.exconIntlShipmentBean.exconIntlShipment.unitName}" placeHolder="Type: Unit Name"
                                       searchMethod="findUnits"/>
            </td>
            </tr>

            <tr><td colspan="4"><hr></td></tr>
            <tr style="vertical-align: top; alignment: left">
                <td width="10%" style="font-weight: bold; vertical-align: middle">
                    <kul:htmlControlAttribute property="document.exconIntlShipmentList[0].restrictedExport" attributeEntry="${exconIntlShipmentAttributes.restrictedExport}" />
                </td>
                <td><b>1.&nbsp;</b></td>
                <td colspan="2">
                    Are you sending any items, software, or technical data outside the U.S. that is restricted for export?
                    Technologies restricted by International Traffic in Arms Regulations (ITAR) or Export Administration Regulations (EAR)
                    are for military or dual military-civilian use.  The departments on
                    <a href="https://vpr.colostate.edu/ricro/departments-with-more-than-minimal-risk/" target="_blank">this list</a>
                    are at greater risk for handling such technology than others.  If so, CSU may need to secure an export
                    license before making the shipment (see below).
                </td>
            </tr>
            <tr style="vertical-align: top; alignment: left">
                <td colspan="2">
                    &nbsp;
                </td>
                <td width="12%">
                    <b><kul:htmlAttributeLabel attributeEntry="${exconIntlShipmentAttributes.shipmentDescription}" /></b>
                </td><td>
                <kul:htmlControlAttribute property="document.exconIntlShipmentList[0].shipmentDescription" attributeEntry="${exconIntlShipmentAttributes.shipmentDescription}"/>
            </td>
            </tr>
            <tr><td colspan="4">&nbsp;</td></tr>

            <tr style="vertical-align: top; alignment: left">
                <td width="10%" style="font-weight: bold; vertical-align: middle">
                    <kul:htmlControlAttribute property="document.exconIntlShipmentList[0].restrictedCountry" attributeEntry="${exconIntlShipmentAttributes.restrictedCountry}" />
                </td>
                <td><b>2.&nbsp;</b></td>
                <td colspan="2">
                    Are you sending something to any of the countries on the
                    <a href="https://vpr.colostate.edu/ricro/excon/export-controlled-or-embargoed-countries/" target="_blank">Export Control Country List</a>?
                    Federal laws and regulations restrict exports to certain destinations for certain purposes.  If yes,
                    please provide a description of the materials and their end use to the Export Control Administrator (see below)
                    for help determining whether an export license may be required before sending the package.
                </td>
            </tr>
            <tr style="vertical-align: top; alignment: left">
                <td colspan="2">
                    &nbsp;
                </td>
                <td>
                    <b><kul:htmlAttributeLabel attributeEntry="${exconIntlShipmentAttributes.countryCode}" /></b>
                </td><td>
                <kul:htmlControlAttribute property="document.exconIntlShipmentList[0].countryCode" attributeEntry="${exconIntlShipmentAttributes.countryCode}"
                                          styleClass="selectpicker\" data-size=\"10\" data-live-search=\"true\" data-live-search-placeholder=\"Type: Country Name"/>
                <c:if test="${readOnly && not empty KualiForm.exconIntlShipmentBean.exconIntlShipment.sanctionListCode}">
                    : <span style="color: red; font-weight: bold">${KualiForm.exconIntlShipmentBean.exconIntlShipment.sanctionListName}</span>
                </c:if>
            </td>
            </tr>
            <tr><td colspan="4">&nbsp;</td></tr>

            <tr style="vertical-align: top; alignment: left">
                <td width="10%" style="font-weight: bold; vertical-align: middle">
                    <kul:htmlControlAttribute property="document.exconIntlShipmentList[0].restrictedParty" attributeEntry="${exconIntlShipmentAttributes.restrictedParty}" />
                </td>
                <td><b>3.&nbsp;</b></td>
                <td colspan="2">
                    Is the recipient of your shipment listed as a denied party?  Federal requirements restrict CSU from doing business
                    with certain institutions, organizations, and individuals.  Central Receiving can help you screen the recipient of your
                    shipment and their organization.  If there is a match that cannot be ruled out on the basis of different but similar names,
                    a country mismatch or other factors, the Export Control Administrator can help determine whether CSU needs to get an export
                    license prior to making the shipment (see below).
                </td>
            </tr>
            <tr style="vertical-align: top; alignment: left">
                <td colspan="2">
                    &nbsp;
                </td>
                <td>
                    <b><kul:htmlAttributeLabel attributeEntry="${exconIntlShipmentAttributes.receivingParty}" /></b>
                </td><td>
                <kul:htmlControlAttribute property="document.exconIntlShipmentList[0].receivingParty" attributeEntry="${exconIntlShipmentAttributes.receivingParty}"/>
                <c:if test="${readOnly && KualiForm.exconIntlShipmentBean.numMatches > -1}">
                    : <span style="color: red; font-weight: bold"> ${KualiForm.exconIntlShipmentBean.numMatches} Possible Matches &nbsp; </span>
                    <c:if test="${KualiForm.exconIntlShipmentBean.numMatches > 0 && KualiForm.exconIntlShipmentBean.exconIntlShipment.isAdmin}">
                        <html:image property="methodToCall.refresh"
                                    src='${ConfigProperties.kra.externalizable.images.url}tinybutton-view.gif' styleClass="tinybutton"
                                    alt="View Results"
                                    onclick="openNewWindow('exconIntlShipment','viewRPSResult','0','${KualiForm.formKey}','${KualiForm.document.sessionDocument}');return false;"/>

                    </c:if>
                </c:if>
            </td>
            </tr>
            <tr>
                <td colspan="4">&nbsp;</td></tr>
            <tr>
                <th colspan="4">
                    Is the answer "yes" to a question above?  Or, are you not sure of an answer?  Ask the Export Control Administrator at
                    <a href="mailto:VPR_Export_Control@colostate.edu">VPR_Export_Control@colostate.edu</a>.
                </th>
            </tr>
            <tr><td colspan="4">&nbsp;</td></tr>
            <tr style="vertical-align: top">
                <td colspan="4" style="font-weight: bold; vertical-align: top">
                    <table><tr style="vertical-align: top"><td>
                        <kul:htmlControlAttribute property="document.exconIntlShipmentList[0].certificationInd" attributeEntry="${exconIntlShipmentAttributes.certificationInd}" />
                    </td><td>&nbsp;</td><td>I certify that this shipment complies with US Export Control laws and regulations.  The answers to each of the questions
                        above is no, or any yes answers have been resolved.  If required, we have secured an export control license from the
                        appropriate federal agency.
                    </td></tr></table>
                </td>
            </tr>


        </table>
    </div>
    <hr>

</kul:tabTop>
