<%--
  #%L
  %%
  Copyright (C) 2005 - 2020 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>
<%@ include file="/WEB-INF/jsp/kraTldHeader.jsp"%>
<%@ include file="/WEB-INF/jsp/kraExconTldHeader.jsp"%>

<c:set var="exconProjectAttributes" value="${DataDictionary.ExconProject.attributes}" />
<c:set var="exconProjectReviewAttributes" value="${DataDictionary.ExconProjectReview.attributes}" />

<c:set var="readOnly" value="${not KualiForm.editingMode['fullEntry']}" scope="request" />
<c:set var="action" value="exconProjectAgreements" />

<kul:tab tabTitle="Reviews" defaultOpen="true" tabErrorKey="exconProjectReviewsBean*" tabAuditKey="exconProjectReviewsBean*"
			auditCluster="reviewsAuditWarnings,reviewsAuditErrors" useRiceAuditMode="true">
	
	<div class="tab-container" align="center">
	<h3>
		<span class="subhead-left">&nbsp;</span>  		
		<span class="subhead-right"><kul:help parameterNamespace="KC-EXCON" parameterDetailType="Document" parameterName="exconProjectDestinationsHelpUrl" altText="help"/></span>
	</h3>
	<table cellpadding="0" cellspacing="0" summary="">
		<tr>
			<th>&nbsp;</th>
			<th>*Review Type</th>
			<th>Comment</th>
			<th>
			<div align="center">Actions</div>
			</th>
		</tr>

		<c:if test="${!readOnly}">
			<tbody class="addline">
			<tr>
				<th class="infoline">Add</th>
				<td id="projectReviewTypeCode" class="grid" class="infoline">
					<kul:htmlControlAttribute 
						property="exconProjectReviewsBean.newReview.projectReviewTypeCode"
						attributeEntry="${exconProjectReviewAttributes.projectReviewTypeCode}"
						readOnly="${readOnly}" /> 

				</td>
				<td id="reviewComment" class="infoline">
					<kul:htmlControlAttribute
						property="exconProjectReviewsBean.newReview.reviewComment"
						attributeEntry="${exconProjectReviewAttributes.reviewComment}" 
						readOnly="${readOnly}"/>
						
				</td>
				<td class="infoline">
				<div align="center"><html:image
					property="methodToCall.addReview"
					src="${ConfigProperties.kr.externalizable.images.url}tinybutton-add1.gif"
					title="Add Review" alt="Add Review" styleClass="tinybutton addButton" /></div>
				</td>
			</tr>
			</tbody>
		</c:if>

		<c:forEach var="reviews"
			items="${KualiForm.exconProjectReviewsBean.exconProjectReviews}"
			varStatus="projectReviewRowStatus">
			<tr>
				<th class="infoline" scope="row">
					<c:out value="${projectReviewRowStatus.index + 1}" />
				</th>
				<td valign="middle">
					${reviews.projectReviewTypeName}
				</td>
				<td valign="middle">
					${reviews.reviewComment}
				</td>

				<td>
				<div align="center">
				<c:choose>
				<c:when test="${!readOnly}">
					<html:image
						property="methodToCall.deleteReview.line${projectReviewRowStatus.index}.anchor${currentTabIndex}"
						src='${ConfigProperties.kra.externalizable.images.url}tinybutton-delete1.gif'
						styleClass="tinybutton" />
				</c:when>
				<c:otherwise>&nbsp;
				</c:otherwise>
				</c:choose>
				</div>
				</td>
			</tr>
		</c:forEach>		

	</table>
	</div>
</kul:tab>
