<%--
  #%L
  %%
  Copyright (C) 2005 - 2020 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>
<%@ tag import="java.util.Map" %>

<%@ include file="/kr/WEB-INF/jsp/tldHeader.jsp"%>
<%@ attribute name="property" required="true" description="The property being rendered." %>
<%@ attribute name="attributeEntry" required="true" type="java.util.Map" description="The Map of data dictionary attributes about the property to render a control for." %>
<%@ attribute name="onblur" required="false" description="If set, this will be used as the onblur method on the control." %>
<%@ attribute name="readOnly" required="false" description="Whether this control should be rendered as read only (ie, not a control but rather text) or not." %>
<%@ attribute name="disabled" required="false" description="Whether this control should be rendered as disabled or not." %>
<%@ attribute name="onchange" required="false" description="If set, this will be used as the onchange method on the control." %>
<%@ attribute name="onclick" required="false" description="If set, this will be used as the onclick method on the control." %>
<%@ attribute name="readOnlyBody" required="false"
              description="when readOnly, use the tag body instead of a written hidden field.
              This allows mixing in module-specific inquiries." %>
<%@ attribute name="readOnlyAlternateDisplay" required="false"
              description="when readOnly, you can specify a String value to display instead of
              the main property.  The readOnlyBody and extraReadOnlyProperty attributes take precedence.
              THIS VALUE WILL BE DISPLAYED WITHOUT ANY XML FILTERING/ESCAPING, AND NEEDS TO BE PROPERLY ESCAPED TO PREVENT CROSS-SITE SCRIPTING VULNERABILITIES" %>
<%@ attribute name="placeHolder" required="false" description="Placeholder for selectpicker" %>
<%@ attribute name="searchMethod" required="true" description="Method to populate dropdown" %>

<kul:htmlControlAttribute property="${property}" attributeEntry="${attributeEntry}"
                          styleClass="selectpicker\" data-size=\"10\" data-live-search=\"true\" data-live-search-placeholder=\"${placeHolder}"
                          readOnlyBody="${readOnlyBody}" readOnlyAlternateDisplay="${readOnlyAlternateDisplay}" readOnly="${readOnly}" />


<input type="hidden" id="${property}_savedVal" value=<bean:write name="KualiForm" property="${property}"/>>
<script>jQuery(document).ready(function() {setupDynamicSelect("${property}","${searchMethod}");});</script>
