<%--
  #%L
  %%
  Copyright (C) 2005 - 2021 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>
<%@ include file="/WEB-INF/jsp/kraTldHeader.jsp"%>
<%@ include file="/WEB-INF/jsp/kraExconTldHeader.jsp"%>

<c:set var="exconProjectAttributes" value="${DataDictionary.ExconProject.attributes}" />
<c:set var="exconProjectCommentAttributes" value="${DataDictionary.ExconProjectComment.attributes}" />

<c:set var="readOnly" value="${not KualiForm.editingMode['fullEntry']}" scope="request" />
<c:set var="action" value="exconProjectCommentsAndAttachments" />

<kul:tabTop tabTitle="Comments" defaultOpen="true" tabErrorKey="exconProjectCommentsBean*">
	
	<div class="tab-container" align="center">
	<h3>
		<span class="subhead-left">Comments</span>  		
		<span class="subhead-right"><kul:help parameterNamespace="KC-EXCON" parameterDetailType="Document" parameterName="exconProjectCommentsHelpUrl" altText="help"/></span>
	</h3>
	<table cellpadding="0" cellspacing="0" summary="">
		<tr>
			<th>&nbsp;</th>
			<th>Comment Date</th>
			<th>Comment Author</th>
			<th>*Comment Type</th>
			<th>*Comment</th>
			<th>
			<div align="center">Actions</div>
			</th>
		</tr>

		<c:if test="${!readOnly}">
			<tbody class="addline">
			<tr>
				<th class="infoline">Add</th>
				<th class="infoline">&nbsp;</th>
				<th class="infoline">&nbsp;</th>
				<td id="commentTypeCode" class="grid" class="infoline">
					<kul:htmlControlAttribute 
						property="exconProjectCommentsBean.newComment.commentTypeCode"
						attributeEntry="${exconProjectCommentAttributes.commentTypeCode}"
						readOnly="${readOnly}" /> 

				</td>
				<td id="comments" class="infoline">
					<kul:htmlControlAttribute
						property="exconProjectCommentsBean.newComment.comments"
						attributeEntry="${exconProjectCommentAttributes.comments}" 
						readOnly="${readOnly}"/>
						
				</td>

				<td class="infoline">
				<div align="center">
					<kul:kualiButton property="methodToCall.addComment"
									 src="${ConfigProperties.kr.externalizable.images.url}tinybutton-add1.gif"
									 label="Add" title="Add Comment" styleClass="tinybutton addButton small outline" /></div>
				</td>
			</tr>
			</tbody>
		</c:if>

		<c:forEach var="comments"
			items="${KualiForm.exconProjectCommentsBean.exconProjectComments}"
			varStatus="projectCommentRowStatus">
			<tr>
				<th class="infoline" scope="row">
					<c:out value="${projectCommentRowStatus.index + 1}" />
				</th>
				<td valign="middle">
					${comments.commentDateStr}
				</td>
				<td valign="middle">
					${comments.commentAuthorName}
				</td>
				<td valign="middle">
					${comments.commentType.description}
				</td>
				<td valign="middle">
					${comments.comments}
				</td>


				<td>
				<div align="center">
				<c:choose>
				<c:when test="${!readOnly}">
                    <kul:kualiButton property="methodToCall.deleteComment.line${projectCommentRowStatus.index}.anchor${currentTabIndex}"
                                     src="${ConfigProperties.kra.externalizable.images.url}tinybutton-delete1.gif"
                                     label="Delete" title="Delete Comment" styleClass="tinybutton small outline" />
				</c:when>
				<c:otherwise>&nbsp;
				</c:otherwise>
				</c:choose>
				</div>
				</td>
			</tr>
		</c:forEach>		

	</table>
	</div>
</kul:tabTop>
