<%--
  #%L
  %%
  Copyright (C) 2005 - 2021 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>

<%@ include file="/kr/WEB-INF/jsp/tldHeader.jsp"%>

<c:set var="docAffiliationAttributes" value="${DataDictionary.PersonDocumentAffiliation.attributes}" />

<kul:subtab lookedUpCollectionName="affiliations" width="${tableWidth}" subTabTitle="Affiliations" noShowHideButton="true" >      
        <table cellpadding="0" cellspacing="0" summary="">
          	<tr>
          		<th><div align="left">&nbsp;</div></th> 
          		<kim:cell inquiry="${inquiry}" isLabel="true" textAlign="center" attributeEntry="${docAffiliationAttributes.affiliationTypeCode}" noColon="true" />
          		<kim:cell inquiry="${inquiry}" isLabel="true" textAlign="center" attributeEntry="${docAffiliationAttributes.campusCode}" noColon="true" />
          		<kim:cell inquiry="${inquiry}" isLabel="true" textAlign="center" attributeEntry="${docAffiliationAttributes.dflt}" noColon="true" />
           <c:if test="${not inquiry}">	
              	<kul:htmlAttributeHeaderCell literalLabel="Actions" scope="col"/>
          </c:if>	
          	</tr>     
          <c:if test="${not inquiry and not readOnlyEntity}">	
             <tr>
				<th class="infoline">
					<c:out value="Add:" />
				</th>

                <td align="left" valign="middle" class="infoline">
                	<div align="center"><kul:htmlControlAttribute property="newAffln.affiliationTypeCode" attributeEntry="${docAffiliationAttributes.affiliationTypeCode}" disabled="${readOnlyEntity}"/>
                </div>
                </td>
                <td class="infoline">   
                <div align="center">             	
                  <kul:htmlControlAttribute property="newAffln.campusCode" attributeEntry="${docAffiliationAttributes.campusCode}" readOnly="${readOnlyEntity}" />
				</div>
				</td>
                <td class="infoline">
                <div align="center">
                	<kul:htmlControlAttribute property="newAffln.dflt" attributeEntry="${docAffiliationAttributes.dflt}" readOnly="${readOnlyEntity}" /> 
				</div>
                </td>
                <td class="infoline">
					<div align=center>
						<kul:kualiButton property="methodToCall.addAffln.anchor${tabKey}"
									src="${ConfigProperties.kr.externalizable.images.url}tinybutton-add1.gif"
									label="Add" title="Add Affiliation" styleClass="tinybutton small outline"/>
					</div>
                </td>
       </tr>         
       </c:if>     
        	<c:forEach var="affln" items="${KualiForm.document.affiliations}" varStatus="status">
        	    <c:set var="rowSpan" value="1"/>
        		<c:if test="${affln.employmentAffiliationType or fn:length(affln.empInfos) > 0}" >
        	    	<c:set var="rowSpan" value="2"/>
        		</c:if>
        	
	             <tr>
					<th rowspan="${rowSpan}" class="infoline">
						<c:out value="${status.index+1}" />
					</th>
					<kim:cell inquiry="${inquiry}" valign="middle" cellClass="infoline" textAlign="center" property="document.affiliations[${status.index}].affiliationTypeCode" attributeEntry="${docAffiliationAttributes.affiliationTypeCode}"  readOnlyAlternateDisplay="${fn:escapeXml(affln.affiliationType.name)}" disabled="true" readOnly="false" />
					<kim:cell inquiry="${inquiry}" valign="middle" cellClass="infoline" textAlign="center" property="document.affiliations[${status.index}].campusCode" attributeEntry="${docAffiliationAttributes.campusCode}" readOnly="${readOnlyEntity}" />
					<kim:cell inquiry="${inquiry}" valign="middle" cellClass="infoline" textAlign="center" property="document.affiliations[${status.index}].dflt" attributeEntry="${docAffiliationAttributes.dflt}" readOnly="${readOnlyEntity}" />

           <c:if test="${not inquiry}">	

					<td>
					<div align=center>&nbsp;
						<kul:kualiButton property="methodToCall.deleteAffln.line${status.index}.anchor${currentTabIndex}"
										 src="${ConfigProperties.kr.externalizable.images.url}tinybutton-delete1.gif"
										 disabledSrc="${ConfigProperties.kr.externalizable.images.url}tinybutton-delete2.gif"
										 label="Delete" title="Delete Affiliation" styleClass="tinybutton small outline"
										 disabled="${address.edit or readOnlyEntity}" />
					</div>
	                </td>
	            </c:if>    
	            </tr>
	            <c:if test="${affln.employmentAffiliationType  or fn:length(affln.empInfos) > 0}" >
	            <tr>
	              <td colspan=5 style="padding:0px;">
		        	<kim:personEmpInfo afflnIdx="${status.index}" />
		          </td>
		        </tr>
		        </c:if>
        	</c:forEach>        

            
        </table>
</kul:subtab>
		
