<%--
  #%L
  %%
  Copyright (C) 2005 - 2021 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>

<%@ include file="/kr/WEB-INF/jsp/tldHeader.jsp"%>

<c:set var="docCitizenshipAttributes" value="${DataDictionary.PersonDocumentCitizenship.attributes}" />

<kul:subtab lookedUpCollectionName="citizenship" width="${tableWidth}" subTabTitle="Citizenships">      
        <table cellpadding="0" cellspacing="0" summary="">
          	<tr>
          		<th><div align="left">&nbsp;</div></th> 
          		<kim:cell inquiry="${inquiry}" isLabel="true" textAlign="center" attributeEntry="${docCitizenshipAttributes.countryCode}" noColon="true" />
          		<kim:cell inquiry="${inquiry}" isLabel="true" textAlign="center" attributeEntry="${docCitizenshipAttributes.startDate}" noColon="true" />
          		<kim:cell inquiry="${inquiry}" isLabel="true" textAlign="center" attributeEntry="${docCitizenshipAttributes.endDate}" noColon="true" />
              	<kul:htmlAttributeHeaderCell literalLabel="Actions" scope="col"/>
          	
          	</tr>     
          	
             <tr>
				<th class="infoline">Add:</th>
				<kim:cell inquiry="${inquiry}" valign="middle" cellClass="infoline" textAlign="center" property="newCitizenship.countryCode" attributeEntry="${docCitizenshipAttributes.countryCode}" readOnly="${readOnly}" />
				<kim:cell inquiry="${inquiry}" valign="middle" cellClass="infoline" textAlign="center" property="newCitizenship.startDate" attributeEntry="${docCitizenshipAttributes.startDate}" datePicker="true" readOnly="${readOnly}" />
				<kim:cell inquiry="${inquiry}" valign="middle" cellClass="infoline" textAlign="center" property="newCitizenship.endDate" attributeEntry="${docCitizenshipAttributes.endDate}" datePicker="true" readOnly="${readOnly}" />
                <td class="infoline">
					<div align=center>
						<kul:kualiButton property="methodToCall.addCitizenship.anchor${tabKey}"
										 src="${ConfigProperties.kr.externalizable.images.url}tinybutton-add1.gif"
										 label="Add" title="Add Citizenship" styleClass="tinybutton small outline"/>
					</div>
                </td>
       </tr>         
            
        	<c:forEach var="citizenship" items="${KualiForm.document.citizenships}" varStatus="status">
	             <tr>
					<th class="infoline">
						<c:out value="${status.index+1}" />
					</th>
					<kim:cell inquiry="${inquiry}" valign="middle" cellClass="infoline" textAlign="center" property="document.citizenships[${status.index}].countryCode" attributeEntry="${docCitizenshipAttributes.countryCode}" readOnly="${readOnly}" />
					<kim:cell inquiry="${inquiry}" valign="middle" cellClass="infoline" textAlign="center" property="document.citizenships[${status.index}].startDate" attributeEntry="${docCitizenshipAttributes.startDate}" datePicker="true" readOnly="${readOnly}" />
					<kim:cell inquiry="${inquiry}" valign="middle" cellClass="infoline" textAlign="center" property="document.citizenships[${status.index}].endDate"  attributeEntry="${docCitizenshipAttributes.endDate}" datePicker="true" readOnly="${readOnly}" />

					<td>
					<div align=center>&nbsp;
						<kul:kualiButton property="methodToCall.deleteCitizenship.line${status.index}.anchor${currentTabIndex}"
										 src="${ConfigProperties.kr.externalizable.images.url}tinybutton-delete1.gif"
										 disabledSrc="${ConfigProperties.kr.externalizable.images.url}tinybutton-delete2.gif"
										 label="Delete" title="Delete Citizenship" styleClass="tinybutton small outline" />
					</div>
	                </td>
	            </tr>
        	</c:forEach>        

            
        </table>
</kul:subtab>
