<%--
  #%L
  %%
  Copyright (C) 2005 - 2021 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>

<%@ include file="/kr/WEB-INF/jsp/tldHeader.jsp"%>

<c:if test="${!empty prefix}">
    <c:set var="prefix" value="${prefix}." />
</c:if>

<c:if test="${empty noTable}">
    <table border=1 cellpadding=4>
        <c:if test="${!empty title}">
            <tr>
                <th colspan=2 align=left>${title}</th>
            </tr>
        </c:if>
    
        <tr>
            <th align=left>key</th>
            <th align=left>value</th>
        </tr>
</c:if>
    
        <c:forEach items='${map}' var='mapEntry' >
            <c:if test="${fn:startsWith(mapEntry.value,'{')}">
                <dd:dumpMap noTable="true" prefix="${prefix}${mapEntry.key}" map="${mapEntry.value}" />
            </c:if>
    
            <c:if test="${!fn:startsWith(mapEntry.value,'{')}">
                <tr>
                    <td valign=top>${prefix}${mapEntry.key}</td>
    
                    <td>
                        <table cellspacing=0 cellpadding=0>
                            <c:set var="subItems" value="${fn:split(mapEntry.value, ',')}" />
        
                            <c:forEach items="${subItems}" var="subItem" >
                                <tr><td>${subItem}</td></tr>
                            </c:forEach>
                        </table>
                    </td>
                </tr>
            </c:if>
        </c:forEach>
<c:if test="${empty noTable}">
    </table>
</c:if>
