<%--
  #%L
  %%
  Copyright (C) 2005 - 2021 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>

<%@ include file="/kr/WEB-INF/jsp/tldHeader.jsp"%>

<%@ attribute name="isReadOnly" required="true"
              description="Is the view for this field readOnly?" %>
<%@ attribute name="field" required="true" type="org.kuali.rice.kns.web.ui.Field"
              description="The field for which to show the lookup icon." %>
<%@ attribute name="addHighlighting" required="false"
              description="boolean indicating if this field should be highlighted (to indicate old/new change)" %>            
<%--
				#######################################################
				# If the field has errors, display error icon.
				####################################################### --%>
<kul:checkErrors keyMatch="${field.propertyName}" />
<c:if test="${hasErrors}">
	 <kul:fieldShowErrorIcon />
</c:if>
<kul:fieldShowLookupIcon isReadOnly="${isReadOnly}" field="${field}" anchor="${currentTabIndex}"/>
<kul:fieldShowDirectInquiryIcon isReadOnly="${isReadOnly}" field="${field}" anchor="${currentTabIndex}"/>
<kul:fieldShowExpandedTextareaIcon isReadOnly="${isReadOnly}" field="${field}" anchor="${currentTabIndex}"/>
<c:if test="${field.fieldLevelHelpEnabled || (!field.fieldLevelHelpDisabled && KualiForm.fieldLevelHelpEnabled)}">
<kul:fieldShowHelpIcon isReadOnly="${isReadOnly}" field="${field}" />
</c:if>

<%-- don't render the field changed icon if readonly since the fieldShowReadOnly tag will render it when the field is readonly --%>
<c:if test="${addHighlighting && field.highlightField && !isReadOnly}">
  <kul:fieldShowChangedIcon />
</c:if>

