<%--
  #%L
  %%
  Copyright (C) 2005 - 2021 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>

<%@ include file="/WEB-INF/jsp/kraTldHeader.jsp"%>

<c:set var="personMassChangeAttributes" value="${DataDictionary.PersonMassChange.attributes}" />
<c:set var="awardPersonMassChangeAttributes" value="${DataDictionary.AwardPersonMassChange.attributes}" />
<c:set var="institutionalProposalPersonMassChangeAttributes" value="${DataDictionary.InstitutionalProposalPersonMassChange.attributes}" />
<c:set var="proposalDevelopmentPersonMassChangeAttributes" value="${DataDictionary.ProposalDevelopmentPersonMassChange.attributes}" />
<c:set var="proposalLogPersonMassChangeAttributes" value="${DataDictionary.ProposalLogPersonMassChange.attributes}" />
<c:set var="subawardPersonMassChangeAttributes" value="${DataDictionary.SubawardPersonMassChange.attributes}" />
<c:set var="negotiationPersonMassChangeAttributes" value="${DataDictionary.NegotiationPersonMassChange.attributes}" />
<c:set var="unitAdministratorPersonMassChangeAttributes" value="${DataDictionary.UnitAdministratorPersonMassChange.attributes}" />
<c:set var="action" value="personMassChangeHome" />
<c:set var="className" value="org.kuali.kra.personmasschange.document.PersonMassChangeDocument" />
<c:set var="readOnly" value="${not KualiForm.editingMode['modify']}"/>

<kul:tab tabTitle="Person Type" defaultOpen="true" innerTabErrorKey="document.personMassChange*">
    <div class="tab-container" align="center">
        <h3>
            <span class="subhead-left">Modules</span>
        </h3>
        
	    <kul:innerTab parentTab="${parentTab}" tabTitle="Award ${tabTitle}" tabErrorKey="document.personMassChange.awardPersonMassChange.*" defaultOpen="false" >
	        <div class="tab-container" align="center">
	            <table cellpadding="4" cellspacing="0" summary="">
	                <tr>
	                    <th style="width:50%"><div align="left"><kul:htmlAttributeLabel attributeEntry="${awardPersonMassChangeAttributes.investigator}" labelFor="document.personMassChange.awardPersonMassChange.investigator"/></div></th>
	                    <td style="width:50%"><kul:htmlControlAttribute property="document.personMassChange.awardPersonMassChange.investigator" 
	                                                                    attributeEntry="${awardPersonMassChangeAttributes.investigator}" readOnly="false" /></td>
	                </tr>
	                <tr>
                        <th style="width:50%"><div align="left"><kul:htmlAttributeLabel attributeEntry="${awardPersonMassChangeAttributes.keyStudyPerson}" labelFor="document.personMassChange.awardPersonMassChange.keyStudyPerson"/></div></th>
                        <td style="width:50%"><kul:htmlControlAttribute property="document.personMassChange.awardPersonMassChange.keyStudyPerson" 
                                                                        attributeEntry="${awardPersonMassChangeAttributes.keyStudyPerson}" readOnly="false" /></td>
                    </tr>
                    <tr>
                        <th style="width:50%"><div align="left"><kul:htmlAttributeLabel attributeEntry="${awardPersonMassChangeAttributes.unitContact}" labelFor="document.personMassChange.awardPersonMassChange.unitContact"/></div></th>
                        <td style="width:50%"><kul:htmlControlAttribute property="document.personMassChange.awardPersonMassChange.unitContact" 
                                                                        attributeEntry="${awardPersonMassChangeAttributes.unitContact}" readOnly="false" /></td>
                    </tr>
	                <tr>
	                    <th style="width:50%"><div align="left"><kul:htmlAttributeLabel attributeEntry="${awardPersonMassChangeAttributes.sponsorContact}" labelFor="document.personMassChange.awardPersonMassChange.sponsorContact"/></div></th>
	                    <td style="width:50%"><kul:htmlControlAttribute property="document.personMassChange.awardPersonMassChange.sponsorContact" 
	                                                                    attributeEntry="${awardPersonMassChangeAttributes.sponsorContact}" readOnly="false" /></td>
	                </tr>
	                <tr>
	                    <th style="width:50%"><div align="left"><kul:htmlAttributeLabel attributeEntry="${awardPersonMassChangeAttributes.approvedForeignTravel}" labelFor="document.personMassChange.awardPersonMassChange.approvedForeignTravel"/></div></th>
	                    <td style="width:50%"><kul:htmlControlAttribute property="document.personMassChange.awardPersonMassChange.approvedForeignTravel" 
	                                                                    attributeEntry="${awardPersonMassChangeAttributes.approvedForeignTravel}" readOnly="false" /></td>
	                </tr>

	                <tr>
	                    <td colspan="2"><div align="center">
	                        <html:image src='${ConfigProperties.kra.externalizable.images.url}tinybutton-selectall.gif' alt="Select All" styleClass="tinybutton" 
	                                    onclick="selectAllPersonMassChangeCategory('document.personMassChange.awardPersonMassChange', 'investigator', 'keyStudyPerson', 'unitContact', 'sponsorContact', 'approvedForeignTravel')" />
	                        <html:image src='${ConfigProperties.kra.externalizable.images.url}tinybutton-selectnone.gif' alt="Select None" styleClass="tinybutton" 
	                                    onclick="unselectAllPersonMassChangeCategory('document.personMassChange.awardPersonMassChange', 'investigator', 'keyStudyPerson', 'unitContact', 'sponsorContact', 'approvedForeignTravel')"/>
	                    </div></td>
	                </tr>
	            </table>
	        </div>
	    </kul:innerTab>
	    
	    <kul:innerTab parentTab="${parentTab}" tabTitle="Institutional Proposal ${tabTitle}" tabErrorKey="document.personMassChange.institutionalProposalPersonMassChange.*" defaultOpen="false" >
	        <div class="tab-container" align="center">
	            <table cellpadding="4" cellspacing="0" summary="">
	                <tr>
	                    <th style="width:50%"><div align="left"><kul:htmlAttributeLabel attributeEntry="${institutionalProposalPersonMassChangeAttributes.investigator}" labelFor="document.personMassChange.institutionalProposalPersonMassChange.investigator"/></div></th>
	                    <td style="width:50%"><kul:htmlControlAttribute property="document.personMassChange.institutionalProposalPersonMassChange.investigator" 
	                                                                    attributeEntry="${institutionalProposalPersonMassChangeAttributes.investigator}" readOnly="false" /></td>
	                </tr>
	                <tr>
                        <th style="width:50%"><div align="left"><kul:htmlAttributeLabel attributeEntry="${institutionalProposalPersonMassChangeAttributes.keyStudyPerson}" labelFor="document.personMassChange.institutionalProposalPersonMassChange.keyStudyPerson"/></div></th>
                        <td style="width:50%"><kul:htmlControlAttribute property="document.personMassChange.institutionalProposalPersonMassChange.keyStudyPerson" 
                                                                        attributeEntry="${institutionalProposalPersonMassChangeAttributes.keyStudyPerson}" readOnly="false" /></td>
                    </tr>
	                <tr>
	                    <th style="width:50%"><div align="left"><kul:htmlAttributeLabel attributeEntry="${institutionalProposalPersonMassChangeAttributes.mailingInformation}" labelFor="document.personMassChange.institutionalProposalPersonMassChange.mailingInformation"/></div></th>
	                    <td style="width:50%"><kul:htmlControlAttribute property="document.personMassChange.institutionalProposalPersonMassChange.mailingInformation" 
	                                                                    attributeEntry="${institutionalProposalPersonMassChangeAttributes.mailingInformation}" readOnly="false" /></td>
	                </tr>
	                <tr>
                        <th style="width:50%"><div align="left"><kul:htmlAttributeLabel attributeEntry="${institutionalProposalPersonMassChangeAttributes.unitContact}" labelFor="document.personMassChange.institutionalProposalPersonMassChange.unitContact"/></div></th>
                        <td style="width:50%"><kul:htmlControlAttribute property="document.personMassChange.institutionalProposalPersonMassChange.unitContact" 
                                                                        attributeEntry="${institutionalProposalPersonMassChangeAttributes.unitContact}" readOnly="false" /></td>
                    </tr>
	                <tr>
	                    <th style="width:50%"><div align="left"><kul:htmlAttributeLabel attributeEntry="${institutionalProposalPersonMassChangeAttributes.ipReviewer}" labelFor="document.personMassChange.institutionalProposalPersonMassChange.ipReviewer"/></div></th>
	                    <td style="width:50%"><kul:htmlControlAttribute property="document.personMassChange.institutionalProposalPersonMassChange.ipReviewer" 
	                                                                    attributeEntry="${institutionalProposalPersonMassChangeAttributes.ipReviewer}" readOnly="false" /></td>
	                </tr>
	                <tr>
                        <td colspan="2"><div align="center">
                            <html:image src='${ConfigProperties.kra.externalizable.images.url}tinybutton-selectall.gif' alt="Select All" styleClass="tinybutton" 
                                        onclick="selectAllPersonMassChangeCategory('document.personMassChange.institutionalProposalPersonMassChange', 'investigator', 'keyStudyPerson', 'mailingInformation', 'unitContact', 'ipReviewer')" />
                            <html:image src='${ConfigProperties.kra.externalizable.images.url}tinybutton-selectnone.gif' alt="Select None" styleClass="tinybutton" 
                                        onclick="unselectAllPersonMassChangeCategory('document.personMassChange.institutionalProposalPersonMassChange', 'investigator', 'keyStudyPerson', 'mailingInformation', 'unitContact', 'ipReviewer')"/>
                        </div></td>
                    </tr>
	            </table>
	        </div>
	    </kul:innerTab>
	    
	    <kul:innerTab parentTab="${parentTab}" tabTitle="Proposal Development ${tabTitle}" tabErrorKey="document.personMassChange.proposalDevelopmentPersonMassChange.*" defaultOpen="false" >
	        <div class="tab-container" align="center">
	            <table cellpadding="4" cellspacing="0" summary="">
	                <tr>
	                    <th style="width:50%"><div align="left"><kul:htmlAttributeLabel attributeEntry="${proposalDevelopmentPersonMassChangeAttributes.investigator}" labelFor="document.personMassChange.proposalDevelopmentPersonMassChange.investigator"/></div></th>
	                    <td style="width:50%"><kul:htmlControlAttribute property="document.personMassChange.proposalDevelopmentPersonMassChange.investigator" 
	                                                                    attributeEntry="${proposalDevelopmentPersonMassChangeAttributes.investigator}" readOnly="false" /></td>
	                </tr>
	                <tr>
	                    <th style="width:50%"><div align="left"><kul:htmlAttributeLabel attributeEntry="${proposalDevelopmentPersonMassChangeAttributes.mailingInformation}" labelFor="document.personMassChange.proposalDevelopmentPersonMassChange.mailingInformation"/></div></th>
	                    <td style="width:50%"><kul:htmlControlAttribute property="document.personMassChange.proposalDevelopmentPersonMassChange.mailingInformation" 
	                                                                    attributeEntry="${proposalDevelopmentPersonMassChangeAttributes.mailingInformation}" readOnly="false" /></td>
	                </tr>
	                <tr>
	                    <th style="width:50%"><div align="left"><kul:htmlAttributeLabel attributeEntry="${proposalDevelopmentPersonMassChangeAttributes.keyStudyPerson}" labelFor="document.personMassChange.proposalDevelopmentPersonMassChange.keyStudyPerson"/></div></th>
	                    <td style="width:50%"><kul:htmlControlAttribute property="document.personMassChange.proposalDevelopmentPersonMassChange.keyStudyPerson" 
	                                                                    attributeEntry="${proposalDevelopmentPersonMassChangeAttributes.keyStudyPerson}" readOnly="false" /></td>
	                </tr>
	                <tr>
                        <td colspan="2"><div align="center">
                            <html:image src='${ConfigProperties.kra.externalizable.images.url}tinybutton-selectall.gif' alt="Select All" styleClass="tinybutton" 
                                        onclick="selectAllPersonMassChangeCategory('document.personMassChange.proposalDevelopmentPersonMassChange', 'investigator', 'mailingInformation', 'keyStudyPerson', 'budgetPerson')" />
                            <html:image src='${ConfigProperties.kra.externalizable.images.url}tinybutton-selectnone.gif' alt="Select None" styleClass="tinybutton" 
                                        onclick="unselectAllPersonMassChangeCategory('document.personMassChange.proposalDevelopmentPersonMassChange', 'investigator', 'mailingInformation', 'keyStudyPerson', 'budgetPerson')"/>
                        </div></td>
                    </tr>
	            </table>
	        </div>
	    </kul:innerTab>
	    
	    <kul:innerTab parentTab="${parentTab}" tabTitle="Proposal Log ${tabTitle}" tabErrorKey="document.personMassChange.proposalLogPersonMassChange.*" defaultOpen="false" >
	        <div class="tab-container" align="center">
	            <table cellpadding="4" cellspacing="0" summary="">
	                <tr>
	                    <th style="width:50%"><div align="left"><kul:htmlAttributeLabel attributeEntry="${proposalLogPersonMassChangeAttributes.principalInvestigator}" labelFor="document.personMassChange.proposalLogPersonMassChange.principalInvestigator"/></div></th>
	                    <td style="width:50%"><kul:htmlControlAttribute property="document.personMassChange.proposalLogPersonMassChange.principalInvestigator" 
	                                                                    attributeEntry="${proposalLogPersonMassChangeAttributes.principalInvestigator}" readOnly="false" /></td>
	                </tr>
	                <tr>
                        <td colspan="2"><div align="center">
                            <html:image src='${ConfigProperties.kra.externalizable.images.url}tinybutton-selectall.gif' alt="Select All" styleClass="tinybutton" 
                                        onclick="selectAllPersonMassChangeCategory('document.personMassChange.proposalLogPersonMassChange', 'principalInvestigator')" />
                            <html:image src='${ConfigProperties.kra.externalizable.images.url}tinybutton-selectnone.gif' alt="Select None" styleClass="tinybutton" 
                                        onclick="unselectAllPersonMassChangeCategory('document.personMassChange.proposalLogPersonMassChange', 'principalInvestigator')"/>
                        </div></td>
                    </tr>
	            </table>
	        </div>
	    </kul:innerTab>
	    
	    <kul:innerTab parentTab="${parentTab}" tabTitle="Subaward ${tabTitle}" tabErrorKey="document.personMassChange.subawardPersonMassChange.*" defaultOpen="false" >
	        <div class="tab-container" align="center">
	            <table cellpadding="4" cellspacing="0" summary="">
	                <tr>
	                    <th style="width:50%"><div align="left"><kul:htmlAttributeLabel attributeEntry="${subawardPersonMassChangeAttributes.requisitioner}" labelFor="document.personMassChange.subawardPersonMassChange.requisitioner"/></div></th>
	                    <td style="width:50%"><kul:htmlControlAttribute property="document.personMassChange.subawardPersonMassChange.requisitioner" 
	                                                                    attributeEntry="${subawardPersonMassChangeAttributes.requisitioner}" readOnly="false" /></td>
	                </tr>
	                <tr>
                        <th style="width:50%"><div align="left"><kul:htmlAttributeLabel attributeEntry="${subawardPersonMassChangeAttributes.contact}" labelFor="document.personMassChange.subawardPersonMassChange.contact"/></div></th>
                        <td style="width:50%"><kul:htmlControlAttribute property="document.personMassChange.subawardPersonMassChange.contact" 
                                                                        attributeEntry="${subawardPersonMassChangeAttributes.contact}" readOnly="false" /></td>
                    </tr>
	                <tr>
                        <td colspan="2"><div align="center">
                            <html:image src='${ConfigProperties.kra.externalizable.images.url}tinybutton-selectall.gif' alt="Select All" styleClass="tinybutton" 
                                        onclick="selectAllPersonMassChangeCategory('document.personMassChange.subawardPersonMassChange', 'requisitioner', 'contact')" />
                            <html:image src='${ConfigProperties.kra.externalizable.images.url}tinybutton-selectnone.gif' alt="Select None" styleClass="tinybutton" 
                                        onclick="unselectAllPersonMassChangeCategory('document.personMassChange.subawardPersonMassChange', 'requisitioner', 'contact')"/>
                        </div></td>
                    </tr>
	            </table>
	        </div>
	    </kul:innerTab>
	    
	    <kul:innerTab parentTab="${parentTab}" tabTitle="Negotiation ${tabTitle}" tabErrorKey="document.personMassChange.negotiationPersonMassChange.*" defaultOpen="false" >
	        <div class="tab-container" align="center">
	            <table cellpadding="4" cellspacing="0" summary="">
	                <tr>
	                    <th style="width:50%"><div align="left"><kul:htmlAttributeLabel attributeEntry="${negotiationPersonMassChangeAttributes.negotiator}" labelFor="document.personMassChange.negotiationPersonMassChange.negotiator"/></div></th>
	                    <td style="width:50%"><kul:htmlControlAttribute property="document.personMassChange.negotiationPersonMassChange.negotiator" 
	                                                                    attributeEntry="${negotiationPersonMassChangeAttributes.negotiator}" readOnly="false" /></td>
	                </tr>
	                <tr>
                        <td colspan="2"><div align="center">
                            <html:image src='${ConfigProperties.kra.externalizable.images.url}tinybutton-selectall.gif' alt="Select All" styleClass="tinybutton" 
                                        onclick="selectAllPersonMassChangeCategory('document.personMassChange.negotiationPersonMassChange', 'negotiator')" />
                            <html:image src='${ConfigProperties.kra.externalizable.images.url}tinybutton-selectnone.gif' alt="Select None" styleClass="tinybutton" 
                                        onclick="unselectAllPersonMassChangeCategory('document.personMassChange.negotiationPersonMassChange', 'negotiator')"/>
                        </div></td>
                    </tr>
	            </table>
	        </div>
	    </kul:innerTab>
	    
	    <kul:innerTab parentTab="${parentTab}" tabTitle="Unit Administrator ${tabTitle}" tabErrorKey="document.personMassChange.unitAdministratorPersonMassChange.*" defaultOpen="false" >
	        <div class="tab-container" align="center">
	            <table cellpadding="4" cellspacing="0" summary="">
	               <tr>
                        <th style="width:50%"><div align="left"><kul:htmlAttributeLabel attributeEntry="${unitAdministratorPersonMassChangeAttributes.administrativeOfficer}" labelFor="document.personMassChange.unitAdministratorPersonMassChange.administrativeOfficer"/></div></th>
                        <td style="width:50%"><kul:htmlControlAttribute property="document.personMassChange.unitAdministratorPersonMassChange.administrativeOfficer" 
                                                                        attributeEntry="${unitAdministratorPersonMassChangeAttributes.administrativeOfficer}" readOnly="false" /></td>
                    </tr>
                    <tr>
                        <th style="width:50%"><div align="left"><kul:htmlAttributeLabel attributeEntry="${unitAdministratorPersonMassChangeAttributes.ospAdministrator}" labelFor="document.personMassChange.unitAdministratorPersonMassChange.ospAdministrator"/></div></th>
                        <td style="width:50%"><kul:htmlControlAttribute property="document.personMassChange.unitAdministratorPersonMassChange.ospAdministrator" 
                                                                        attributeEntry="${unitAdministratorPersonMassChangeAttributes.ospAdministrator}" readOnly="false" /></td>
                    </tr>
                    <tr>
                        <th style="width:50%"><div align="left"><kul:htmlAttributeLabel attributeEntry="${unitAdministratorPersonMassChangeAttributes.unitHead}" labelFor="document.personMassChange.unitAdministratorPersonMassChange.unitHead"/></div></th>
                        <td style="width:50%"><kul:htmlControlAttribute property="document.personMassChange.unitAdministratorPersonMassChange.unitHead" 
                                                                        attributeEntry="${unitAdministratorPersonMassChangeAttributes.unitHead}" readOnly="false" /></td>
                    </tr>
                    <tr>
                        <th style="width:50%"><div align="left"><kul:htmlAttributeLabel attributeEntry="${unitAdministratorPersonMassChangeAttributes.deanVP}" labelFor="document.personMassChange.unitAdministratorPersonMassChange.deanVP"/></div></th>
                        <td style="width:50%"><kul:htmlControlAttribute property="document.personMassChange.unitAdministratorPersonMassChange.deanVP" 
                                                                        attributeEntry="${unitAdministratorPersonMassChangeAttributes.deanVP}" readOnly="false" /></td>
                    </tr>
                    <tr>
                        <th style="width:50%"><div align="left"><kul:htmlAttributeLabel attributeEntry="${unitAdministratorPersonMassChangeAttributes.otherIndividualToNotify}" labelFor="document.personMassChange.unitAdministratorPersonMassChange.otherIndividualToNotify"/></div></th>
                        <td style="width:50%"><kul:htmlControlAttribute property="document.personMassChange.unitAdministratorPersonMassChange.otherIndividualToNotify" 
                                                                        attributeEntry="${unitAdministratorPersonMassChangeAttributes.otherIndividualToNotify}" readOnly="false" /></td>
                    </tr>
	                <tr>
	                    <th style="width:50%"><div align="left"><kul:htmlAttributeLabel attributeEntry="${unitAdministratorPersonMassChangeAttributes.administrativeContact}" labelFor="document.personMassChange.unitAdministratorPersonMassChange.administrativeContact"/></div></th>
	                    <td style="width:50%"><kul:htmlControlAttribute property="document.personMassChange.unitAdministratorPersonMassChange.administrativeContact" 
	                                                                    attributeEntry="${unitAdministratorPersonMassChangeAttributes.administrativeContact}" readOnly="false" /></td>
	                </tr>
	                <tr>
                        <th style="width:50%"><div align="left"><kul:htmlAttributeLabel attributeEntry="${unitAdministratorPersonMassChangeAttributes.financialContact}" labelFor="document.personMassChange.unitAdministratorPersonMassChange.financialContact"/></div></th>
                        <td style="width:50%"><kul:htmlControlAttribute property="document.personMassChange.unitAdministratorPersonMassChange.financialContact" 
                                                                        attributeEntry="${unitAdministratorPersonMassChangeAttributes.financialContact}" readOnly="false" /></td>
                    </tr>
	                <tr>
                        <td colspan="2"><div align="center">
                            <html:image src='${ConfigProperties.kra.externalizable.images.url}tinybutton-selectall.gif' alt="Select All" styleClass="tinybutton" 
                                        onclick="selectAllPersonMassChangeCategory('document.personMassChange.unitAdministratorPersonMassChange', 'administrativeOfficer', 'ospAdministrator', 'unitHead', 'deanVP', 'otherIndividualToNotify', 'administrativeContact', 'financialContact')" />
                            <html:image src='${ConfigProperties.kra.externalizable.images.url}tinybutton-selectnone.gif' alt="Select None" styleClass="tinybutton" 
                                        onclick="unselectAllPersonMassChangeCategory('document.personMassChange.unitAdministratorPersonMassChange', 'administrativeOfficer', 'ospAdministrator', 'unitHead', 'deanVP', 'otherIndividualToNotify', 'administrativeContact', 'financialContact')"/>
                        </div></td>
                    </tr>
	            </table>
	        </div>
	    </kul:innerTab>
    </div>
    
    <div class="tab-container" align="center">
        <h3>
            <span class="subhead-left">Options</span>
        </h3>
        
        <table cellpadding="4" cellspacing="0" summary="">
            <tr>
                <th style="width:50%"><div align="left"><kul:htmlAttributeLabel attributeEntry="${personMassChangeAttributes.changeAllSequences}" labelFor="document.personMassChange.changeAllSequences"/></div></th>
                <td style="width:50%"><kul:htmlControlAttribute property="document.personMassChange.changeAllSequences" 
                                                                attributeEntry="${personMassChangeAttributes.changeAllSequences}" readOnly="false" /></td>
            </tr>
        </table>
    </div>
</kul:tab>
