<%--
  #%L
  %%
  Copyright (C) 2005 - 2021 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>
<%@ include file="/WEB-INF/jsp/kraTldHeader.jsp" %>
<style type="text/css">
    .nobull {
        list-style-type: none;
        padding-left: 0;
        margin-left: 0;
    }

    #workarea th {
        background-repeat: repeat-x;
        background-color: #f5f5f5;
    }

    #workarea td.infoline {
        background-repeat: repeat-x;
    }
</style>
<c:set var="subAwardPrintAgreementAttributes" value="${DataDictionary.SubAwardPrintAgreement.attributes}"/>
<c:set var="action" value="SubAwardHomeAction"/>
<c:set var="subAwardPrintAgreement" value="${KualiForm.subAwardPrintAgreement }"/>

<kul:tab tabTitle="Print" tabItemCount="" defaultOpen="false" tabErrorKey="print*,subAwardPrintAgreement*" auditCluster="requiredFieldsAuditErrors"
         tabAuditKey="" useRiceAuditMode="true">
    <div class="tab-container" align="center">
        <h3>
            <span class="subhead-left">Print</span>
        </h3>
        <table cellpadding="0" cellspacing="0" summary="Print Options">
            <tr>
                <th rowspan="8" scope="row" style="text-align:left;">Cost Reimbursement</th>
            </tr>
            <tr>
                <td scope="row" style="text-align:left;" nowrap="nowrap">
                    <kul:htmlAttributeLabel attributeEntry="${subAwardPrintAgreementAttributes.fundingSource}" useShortLabel="false" labelFor="subAwardPrintAgreement.fundingSource"/>
                </td>
                <td>
                    <kul:htmlControlAttribute property="subAwardPrintAgreement.fundingSource" attributeEntry="${subAwardPrintAgreementAttributes.fundingSource}" readOnly="false"/>
                </td>
                <td rowspan="5" class="infoline" style="text-align:left;">
                    <html:image property="methodToCall.printTemplates" src='${ConfigProperties.kra.externalizable.images.url}tinybutton-print.gif' alt="Print Award Notice" styleClass="tinybutton" onclick="excludeSubmitRestriction=true; jQuery('.tab-container-error').css('display','none'); jQuery('.left-errmsg').css('display','none');"/>
                </td>
            </tr>
            <tr>
                <td scope="row" style="text-align:left;" nowrap="nowrap"><label for="subAwardPrintAgreement.selectedForms">Templates:</label></td>
                <td scope="row" style="text-align:left;" nowrap="nowrap" colspan="2">
                    <html:select property="subAwardPrintAgreement.selectedForms" styleId="subAwardPrintAgreement.selectedForms" title="Template" disabled="${readOnly}" multiple="true" style="width: fit-content;">
                        <jsp:useBean id="paramMap"  class="java.util.HashMap"/>
                        <c:set target="${paramMap}" property="templateTypeCode" value="${4}" />

                        <c:forEach items="${krafn:getOptionList('org.kuali.kra.subaward.lookup.keyvalue.SubawardFormsFinder', paramMap)}" var="option">
                            <c:out value="${option.value}"/>
                            <option value="${option.key}">${option.value}</option>
                        </c:forEach>
                    </html:select>
                </td>
            </tr>
            <tr>
                <td scope="row" style="text-align:left;">Template Attachments:</td>
                <td scope="row" style="text-align:left;">
                    <ul class="nobull">
                        <c:forEach var="attachment" items="${KualiForm.document.subAwardList[0].subAwardTemplateAttachments}" varStatus="status">
                            <c:if test="${status.index % 2 == 0}">
                                <li class="nobull">
                                    <c:out value="${attachment.typeAttachment.description} -  ${attachment.description}"/>
                                </li>
                            </c:if>
                        </c:forEach>
                    </ul>
                </td>
                <td scope="row" style="text-align:left;">
                    <ul class="nobull">
                        <c:forEach var="attachment" items="${KualiForm.document.subAwardList[0].subAwardTemplateAttachments}" varStatus="status">
                            <c:if test="${status.index % 2 != 0}">
                                <li class="nobull">
                                    <c:out value="${attachment.typeAttachment.description} -  ${attachment.description}"/>
                                </li>
                            </c:if>
                        </c:forEach>
                    </ul>
                </td>
            </tr>
        </table>
    </div>
</kul:tab>
