<%--
  #%L
  %%
  Copyright (C) 2005 - 2021 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>

<!DOCTYPE html>
<%@ page contentType="text/html"%>
<%@ taglib uri="http://www.springframework.org/tags" prefix="spring"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>

<html lang="en">
<head>
<title>Kuali Communications Broker - Deliverer Configuration</title>
<link href="${ConfigProperties.ken.url}/css/notification.css" rel="stylesheet" type="text/css" />
</head>
<body>

<div class="background-content">
<div style="padding: 5px;">
<div class="title">Configure Delivery Types</div>
<p>Enter the appropriate information for each delivery type then select which channels for which you want the delivery type enabled. Select "None" in channel list to remove a delivery type for all
channels.</p>
<div style="color: red; padding: 2px;" id="message"><c:if test="${not empty errorList}">
    <strong>Error(s):</strong>
    <br />
    <c:forEach var="error" items="${errorList}">
        <c:out value="${error}" />
        <br />
    </c:forEach>
</c:if> <c:if test="${empty errorList}">
    <c:if test="${not empty message}">
        <c:out value="${message}" />
    </c:if>
</c:if></div>
<form name="DelivererConfiguration" action="saveprefs.kcb">
<table border="0" cellpadding="0" cellspacing="0" class="bord-all" width="80%">
    <tr>
        <td class="thnormal"><strong>Delivery Type</strong></td>
        <td class="thnormal" width="15%" />
        <td class="thnormal" width="25%"><strong>Channels</strong></td>
    </tr>
    <c:forEach var="deliveryType" items="${deliveryTypes}">
        <c:if test="${deliveryType.name != 'KEWActionList'}">
            <tr>
                <td class="thnormal">
                <p><strong><c:out value="${deliveryType.title}" /></strong></p>
                <p><c:out value="${deliveryType.description}" /></p>
                <c:if test="${! empty deliveryType.preferenceKeys}">

                    <c:forEach var="entry" items="${deliveryType.preferenceKeys}">
                        <c:set var="keyname">
                            <c:out value="${deliveryType.name}" />.<c:out value="${entry.key}" />
                        </c:set>

                        <div style="margin-left: 2px; padding: 2px"><label for="<c:out value="${keyname}"  />"><c:out value="${entry.value}" />:</label><br />
                        <input type="text" aria-label="<c:out value="${keyname}"  />" size="20" id="<c:out value="${keyname}"  />" name="<c:out value="${keyname}"  />" value="<c:out value="${preferences[keyname]}" />" /></div>
                    </c:forEach>
                </c:if></td>
                <td class="thnormal" valign="center">
                <c:set var="channellist"><c:out value="${deliveryType.name}" />.channels</c:set>
                <label for="${channellist}"><center><strong><i>Enabled For &gt;&gt;</i></strong></center></label>
                </td>
                <td class="thnormal" align="center" valign="center" width="25%"> <select multiple="multiple" name="${channellist}" id="${channellist}" aria-label="Enabled For">
                    <option value="0">None</option>
                    <c:forEach var="channel" items="${channels}">
                        <c:set var="chid">
                            <c:out value="${deliveryType.name}" />.<c:out value="${channel}" />
                        </c:set>
                        <option value="<c:out value="${channel}" />" <c:if test="${not empty currentDeliverersMap[chid]}" > selected="selected" </c:if>><c:out value="${channel}" /></option>
                    </c:forEach>
                </select></td>
            </tr>
        </c:if>
    </c:forEach>
    <tr>
        <td class="thnormal" colspan="3" align="center">
            <input type="image" src="${ConfigProperties.ken.url}/images/buttonsmall_save.gif" value="save" alt="Save" name="save" />
            <img src="${ConfigProperties.ken.url}/images/transparent_002.gif" height="1" width="1">
            <c:set var="cancelLocation" value="${ConfigProperties.application.url}/portal.do" />
            <c:if test="${!empty backLocation}">
                <c:set var="cancelLocation" value="${backLocation}"/>
                <input type="hidden" value="<c:out value='${backLocation}' />" alt="Back Location" name="backLocation"/>
            </c:if>
            <a href="${cancelLocation}">
                <img src="${ConfigProperties.ken.url}/images/buttonsmall_cancel.gif" alt="Cancel" border="0" />
            </a>
        </td>
    </tr>
</table>
</form>
</div>
</div>
</body>
</html>
