<#--
 #%L
 %%
 Copyright (C) 2005 - 2021 Kuali, Inc. - All Rights Reserved
 %%
 You may use and modify this code under the terms of the Kuali, Inc.
 Pre-Release License Agreement. You may not distribute it.
 
 You should have received a copy of the Kuali, Inc. Pre-Release License
 Agreement with this file. If not, please write to license@kuali.co.
 #L%
-->

<#--
    Renders a step progress bar
 -->
<#macro uif_stepProgressBar element>
    <#include 'progressBar.ftl' parse=true/>

    <#if element.verticalHeight?has_content>
        <#local vHeight="style='height: ${element.verticalHeight}px;'"/>
    </#if>

    <@krad.div component=element>
        <#-- when not vertical put the step label text first, otherwise after -->
        <#if !element.vertical>
            <div class="progress-details" ${vHeight!}>
                <#list element.segmentSizes as size>
                        <div style="${size!};" class="${element.stepLabelClasses[size_index]!}">
                            <span class="sr-only">${element.accessibilityText[size_index]!}</span>
                            ${element.stepCollection[size_index]!}
                        </div>
                </#list>
            </div>
        </#if>

        <div class="progress" ${vHeight!}>
            <@uif_progressBar element=element renderOwnDiv=false/>
        </div>

        <#if element.vertical>
            <div class="progress-details" ${vHeight!}>
                <#list element.segmentSizes as size>
                        <div style="${size!};" class="${element.stepLabelClasses[size_index]!}">
                            <span class="sr-only">${element.accessibilityText[size_index]!}</span>
                            <span>${element.stepCollection[size_index]!}</span>
                        </div>
                </#list>
            </div>
        </#if>
    </@krad.div>
</#macro>
