<#--
 #%L
 %%
 Copyright (C) 2005 - 2021 Kuali, Inc. - All Rights Reserved
 %%
 You may use and modify this code under the terms of the Kuali, Inc.
 Pre-Release License Agreement. You may not distribute it.
 
 You should have received a copy of the Kuali, Inc. Pre-Release License
 Agreement with this file. If not, please write to license@kuali.co.
 #L%
-->

<#macro uif_view view>

    <!-- VIEW -->
    <@krad.div component=view>

        <#-- optional top group content above breadcrumbs -->
        <#local topGroupWrapData=""/>
        <#if view.stickyTopGroup>
            <#local topGroupWrapData="data-sticky='true'"/>
        </#if>

        <#if view.topGroup?has_content && view.topGroup.render>
            <div id="Uif-TopGroupWrapper" ${topGroupWrapData}>
                <@krad.template component=view.topGroup/>
            </div>
        </#if>

        <!-- BREADCRUMBS -->
        <#local breadcrumbWrapData=""/>
        <#if view.stickyBreadcrumbs>
            <#local breadcrumbWrapData="data-sticky='true'"/>
        </#if>

        <#if view.breadcrumbs?has_content && view.breadcrumbs.render>
           <div id="Uif-BreadcrumbWrapper" ${breadcrumbWrapData}></div>
        </#if>

        <!-- VIEW HEADER -->
        <@krad.template component=view.header/>

        <!-- VIEW CONTENT -->
        <div id="Uif-ViewContentWrapper" class="uif-viewContentWrapper ${view.contentContainerClassesAsString}">
            <!-- VIEW NAVIGATION -->
            <#if view.navigation?? && view.navigation.items?? && view.navigation.items?has_content>
                <nav id="Uif-Navigation" role="navigation">
                     <@krad.template component=view.navigation currentPageId="${view.currentPageId!}"/>
                </nav>
            </#if>

            <@krad.template component=view.currentPage/>
        </div>

        <!-- VIEW FOOTER -->
        <@krad.template component=view.footer/>

        <!-- DIALOGS/Placeholders -->
        <div id="Uif-Dialogs">
            <#list view.dialogs as dialog>
                <@krad.template component=dialog/>
            </#list>
        </div>

    </@krad.div>

</#macro>
