<%--
  #%L
  %%
  Copyright (C) 2005 - 2020 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.

  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>
<%@ include file="/WEB-INF/jsp/kraTldHeader.jsp"%>

<%@ attribute name="property" required="true" %>
<%@ attribute name="readOnly" required="true" %>
<%@ attribute name="styleClass" required="false" %>
<%@ attribute name="anchor" required="false" %>
<%@ attribute name="excludeInactive" required="false" %>
<%@ attribute name="valuesFinder" required="true" %>
<%@ attribute name="onchange" required="false" %>

<c:set var="excludeInactive" value="${(empty excludeInactive) ? 'true' : excludeInactive}" />

<logic:present name="KualiForm" property="${property}">
	<bean:define id="currentValue" name="KualiForm" property="${property}" />
</logic:present>
<logic:notPresent name="KualiForm" property="${property}">
	<c:set var="currentValue" value="" />
</logic:notPresent>

<jsp:useBean id="paramMap"  class="java.util.HashMap"/>
<c:set target="${paramMap}" property="currentValue" value="${currentValue}" />
<c:set target="${paramMap}" property="excludeInactive" value="${excludeInactive}" />

<c:if test="${!readOnly}" >
	${kfunc:registerEditableProperty(KualiForm, property)}
</c:if>

<html:select property="${property}" tabindex="0" disabled="${readOnly}" styleClass="${styleClass}" onchange="${onchange}">
	<c:forEach items="${krafn:getOptionList(valuesFinder, paramMap)}" var="option">
		<c:choose>
			<c:when test="${currentValue eq option.key}" >
				<option value="${option.key}" selected="selected">${option.value}</option>
			</c:when>
			<c:otherwise>
				<option value="${option.key}">${option.value}</option>
			</c:otherwise>
		</c:choose>
	</c:forEach>
</html:select>