/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2020 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

/**
 * Bind to click events on toggle buttons
 */
jQuery(function() {
    /**
     * Toggle the named input value between YES and NO, and then call customLookupChanged
     * to submit form to refresh.
     */
    function toggleSearchType(input_name) {
        var input = jQuery('input[name=' + input_name + ']');
        input.val(input.val() == "YES" ? "NO" : "YES");
        customLookupChanged();
    }
    jQuery("#toggleAdvancedSearch" ).click(function() { toggleSearchType("isAdvancedSearch"); });
    jQuery("#toggleSuperUserSearch").click(function() { toggleSearchType("superUserSearch"); });
    jQuery("#resetSavedSearch"     ).click(function() { toggleSearchType("resetSavedSearch"); });
});

/**
 * Called on an action that requires the lookup to be refreshed
 * Invokes performCustomAction.
 */
function customLookupChanged() {
    var methodToCallElement=document.createElement("input");
    methodToCallElement.setAttribute("type","hidden");
    methodToCallElement.setAttribute("name","methodToCall");
    methodToCallElement.setAttribute("value","refresh");
    document.forms[0].appendChild(methodToCallElement);

    var refreshCallerElement=document.createElement("input");
    refreshCallerElement.setAttribute("type","hidden");
    refreshCallerElement.setAttribute("name","refreshCaller");
    refreshCallerElement.setAttribute("value","customLookupAction");
    document.forms[0].appendChild(refreshCallerElement);

    document.forms[0].submit();
}
