/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.maven.spring;

import java.util.Map;
import java.util.Properties;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.kuali.common.maven.spring.MavenAwareUtils;
import org.kuali.common.util.Assert;
import org.kuali.common.util.FormatUtils;
import org.kuali.common.util.execute.Executable;
import org.kuali.common.util.maven.MavenUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AugmentMavenPropertiesExecutable
implements Executable {
    private static final Logger logger = LoggerFactory.getLogger(AugmentMavenPropertiesExecutable.class);
    private final MavenProject mavenProject;
    private final Settings settings;
    private final boolean skip;

    public AugmentMavenPropertiesExecutable(MavenProject mavenProject, Settings settings, boolean skip) {
        Assert.noNulls((Object[])new Object[]{mavenProject});
        this.mavenProject = mavenProject;
        this.settings = settings;
        this.skip = skip;
    }

    public void execute() {
        if (this.skip) {
            return;
        }
        Properties mavenProperties = this.mavenProject.getProperties();
        int originalSize = mavenProperties.size();
        Properties internal = MavenAwareUtils.getInternalProperties(this.mavenProject, this.settings);
        mavenProperties.putAll((Map<?, ?>)internal);
        MavenUtils.augmentProjectProperties((Properties)mavenProperties);
        logger.debug("Added {} properties", (Object)FormatUtils.getCount((long)(mavenProperties.size() - originalSize)));
    }

    public MavenProject getMavenProject() {
        return this.mavenProject;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public boolean isSkip() {
        return this.skip;
    }
}

