/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.maven.spring;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.LocationUtils;
import org.kuali.common.util.maven.RepositoryUtils;
import org.kuali.common.util.maven.model.Dependency;

public class MavenAwareUtils {
    public static Properties getInternalProperties(MavenProject project, Settings settings) {
        Properties properties = new Properties();
        MavenAwareUtils.nullSafeSet(properties, "project.id", project.getId());
        MavenAwareUtils.nullSafeSet(properties, "project.groupId", project.getGroupId());
        MavenAwareUtils.nullSafeSet(properties, "project.artifactId", project.getArtifactId());
        MavenAwareUtils.nullSafeSet(properties, "project.version", project.getVersion());
        MavenAwareUtils.nullSafeSet(properties, "project.packaging", project.getPackaging());
        MavenAwareUtils.nullSafeSet(properties, "project.name", project.getName());
        MavenAwareUtils.nullSafeSet(properties, "project.description", project.getDescription());
        MavenAwareUtils.nullSafeSet(properties, "project.inceptionYear", project.getInceptionYear());
        MavenAwareUtils.nullSafeSet(properties, "project.basedir", LocationUtils.getCanonicalPath((File)project.getBasedir()));
        if (project.getCiManagement() != null) {
            MavenAwareUtils.nullSafeSet(properties, "project.ciManagement.system", project.getCiManagement().getSystem());
            MavenAwareUtils.nullSafeSet(properties, "project.ciManagement.url", project.getCiManagement().getUrl());
        }
        if (project.getIssueManagement() != null) {
            MavenAwareUtils.nullSafeSet(properties, "project.issueManagement.system", project.getIssueManagement().getSystem());
            MavenAwareUtils.nullSafeSet(properties, "project.issueManagement.url", project.getIssueManagement().getUrl());
        }
        if (project.getBuild() != null) {
            MavenAwareUtils.nullSafeSet(properties, "project.build.directory", project.getBuild().getDirectory());
            MavenAwareUtils.nullSafeSet(properties, "project.build.outputDirectory", project.getBuild().getOutputDirectory());
            MavenAwareUtils.nullSafeSet(properties, "project.build.testOutputDirectory", project.getBuild().getTestOutputDirectory());
            MavenAwareUtils.nullSafeSet(properties, "project.build.sourceDirectory", project.getBuild().getSourceDirectory());
            MavenAwareUtils.nullSafeSet(properties, "project.build.scriptSourceDirectory", project.getBuild().getScriptSourceDirectory());
            MavenAwareUtils.nullSafeSet(properties, "project.build.testSourceDirectory", project.getBuild().getTestSourceDirectory());
        }
        if (project.getScm() != null) {
            MavenAwareUtils.nullSafeSet(properties, "project.scm.connection", project.getScm().getConnection());
            MavenAwareUtils.nullSafeSet(properties, "project.scm.developerConnection", project.getScm().getDeveloperConnection());
            MavenAwareUtils.nullSafeSet(properties, "project.scm.url", project.getScm().getDeveloperConnection());
        }
        MavenAwareUtils.nullSafeSet(properties, "project.pom.location", MavenAwareUtils.getPomLocation(project));
        List<org.kuali.common.util.maven.model.Dependency> dependencies = MavenAwareUtils.convertToSimplePojos(project.getDependencies());
        MavenAwareUtils.nullSafeSet(properties, "project.dependencies", MavenAwareUtils.getDependenciesCSV(dependencies));
        if (settings != null) {
            MavenAwareUtils.nullSafeSet(properties, "settings.localRepository", settings.getLocalRepository());
            MavenAwareUtils.nullSafeSet(properties, "settings.modelEncoding", settings.getModelEncoding());
            MavenAwareUtils.nullSafeSet(properties, "settings.sourceLevel", settings.getSourceLevel());
            if (settings.getInteractiveMode() != null) {
                MavenAwareUtils.nullSafeSet(properties, "settings.interactiveMode", settings.getInteractiveMode() + "");
            }
        }
        return properties;
    }

    public static Properties getInternalProperties(MavenProject project) {
        return MavenAwareUtils.getInternalProperties(project, null);
    }

    public static void nullSafeSet(Properties properties, String key, String value) {
        if (value != null) {
            properties.setProperty(key, value);
        }
    }

    public static String getPomLocation(MavenProject project) {
        StringBuilder sb = new StringBuilder();
        sb.append("classpath:");
        sb.append("META-INF");
        sb.append("/");
        sb.append("maven");
        sb.append("/");
        sb.append(project.getGroupId());
        sb.append("/");
        sb.append(project.getArtifactId());
        sb.append("/");
        sb.append("pom.xml");
        return sb.toString();
    }

    public static List<org.kuali.common.util.maven.model.Dependency> convertToSimplePojos(List<Dependency> dependencies) {
        ArrayList<org.kuali.common.util.maven.model.Dependency> pojos = new ArrayList<org.kuali.common.util.maven.model.Dependency>();
        for (Dependency d : CollectionUtils.toEmptyList(dependencies)) {
            org.kuali.common.util.maven.model.Dependency pojo = new Dependency.Builder(d.getGroupId(), d.getArtifactId(), d.getVersion()).classifier(d.getClassifier()).type(d.getType()).scope(d.getScope()).build();
            pojos.add(pojo);
        }
        return pojos;
    }

    public static String getDependenciesCSV(List<org.kuali.common.util.maven.model.Dependency> dependencies) {
        if (CollectionUtils.isEmpty(dependencies)) {
            return "NONE";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < dependencies.size(); ++i) {
            if (i != 0) {
                sb.append(",");
            }
            org.kuali.common.util.maven.model.Dependency dependency = dependencies.get(i);
            sb.append(RepositoryUtils.toString((org.kuali.common.util.maven.model.Dependency)dependency));
        }
        return sb.toString();
    }
}

