/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util;

import java.io.PrintStream;
import org.kuali.common.util.Assert;
import org.kuali.common.util.LogMsg;
import org.kuali.common.util.LoggerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProgressInformer {
    private static final Logger logger = LoggerFactory.getLogger(AbstractProgressInformer.class);
    protected long progress;
    PrintStream printStream = System.out;
    String startToken = "[INFO] Progress: ";
    String progressToken = ".";
    String completeToken = "\n";
    LogMsg startMessage;
    LogMsg stopMessage;

    public synchronized long getProgress() {
        return this.progress;
    }

    public void start() {
        if (this.startMessage != null) {
            LoggerUtils.log(this.startMessage, logger);
        }
        Assert.notNull((Object)this.printStream, (String)"printStream is null");
        this.progress = 0L;
        this.printStream.print(this.startToken);
    }

    public void stop() {
        this.printStream.print(this.completeToken);
        if (this.stopMessage != null) {
            LoggerUtils.log(this.stopMessage, logger);
        }
    }

    public PrintStream getPrintStream() {
        return this.printStream;
    }

    public void setPrintStream(PrintStream printStream) {
        this.printStream = printStream;
    }

    public String getStartToken() {
        return this.startToken;
    }

    public void setStartToken(String startToken) {
        this.startToken = startToken;
    }

    public String getCompleteToken() {
        return this.completeToken;
    }

    public void setCompleteToken(String completeToken) {
        this.completeToken = completeToken;
    }

    public String getProgressToken() {
        return this.progressToken;
    }

    public void setProgressToken(String progressToken) {
        this.progressToken = progressToken;
    }

    public LogMsg getStartMessage() {
        return this.startMessage;
    }

    public void setStartMessage(LogMsg startMessage) {
        this.startMessage = startMessage;
    }

    public LogMsg getStopMessage() {
        return this.stopMessage;
    }

    public void setStopMessage(LogMsg stopMessage) {
        this.stopMessage = stopMessage;
    }
}

