/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.Assert;
import org.kuali.common.util.LocationUtils;
import org.kuali.common.util.MonitorTextFileResult;
import org.kuali.common.util.SimpleScanner;
import org.kuali.common.util.SyncRequest;
import org.kuali.common.util.SyncResult;
import org.kuali.common.util.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemUtils {
    private static final Logger logger = LoggerFactory.getLogger(FileSystemUtils.class);

    public static MonitorTextFileResult monitorTextFile(File file, String token, int intervalMillis, int timeoutMillis, String encoding) {
        Assert.notNull((Object)file, (String)"file is null");
        Assert.hasText((String)token, (String)"token has no text");
        Assert.hasText((String)encoding, (String)"encoding has no text");
        Assert.isTrue((intervalMillis > 0 ? 1 : 0) != 0, (String)"interval must be a positive integer");
        Assert.isTrue((timeoutMillis > 0 ? 1 : 0) != 0, (String)"timeout must be a positive integer");
        long start = System.currentTimeMillis();
        long stop = start + (long)timeoutMillis;
        boolean exists = false;
        boolean contains = false;
        boolean timeoutExceeded = false;
        long now = -1L;
        String content = null;
        do {
            if (now != -1L) {
                ThreadUtils.sleep(intervalMillis);
            }
            if ((now = System.currentTimeMillis()) <= stop) continue;
            timeoutExceeded = true;
            break;
        } while (!(exists = LocationUtils.exists(file)) || !(contains = StringUtils.contains((CharSequence)(content = LocationUtils.toString(file, encoding)), (CharSequence)token)));
        long elapsed = now - start;
        MonitorTextFileResult mtfr = new MonitorTextFileResult(exists, contains, timeoutExceeded, elapsed);
        mtfr.setAbsolutePath(LocationUtils.getCanonicalPath(file));
        mtfr.setContent(content);
        return mtfr;
    }

    public static List<SyncResult> syncFiles(List<SyncRequest> requests) throws IOException {
        ArrayList<SyncResult> results = new ArrayList<SyncResult>();
        for (SyncRequest request : requests) {
            SyncResult result = FileSystemUtils.syncFiles(request);
            results.add(result);
        }
        return results;
    }

    public static SyncResult syncFiles(SyncRequest request) throws IOException {
        logger.info("Sync [{}] -> [{}]", (Object)request.getSrcDir(), (Object)request.getDstDir());
        List<File> dstFiles = FileSystemUtils.getAllFiles(request.getDstDir());
        List<File> srcFiles = request.getSrcFiles();
        List<String> dstPaths = FileSystemUtils.getRelativePaths(request.getDstDir(), dstFiles);
        List<String> srcPaths = FileSystemUtils.getRelativePaths(request.getSrcDir(), srcFiles);
        ArrayList<String> adds = new ArrayList<String>();
        ArrayList<String> updates = new ArrayList<String>();
        ArrayList<String> deletes = new ArrayList<String>();
        for (String srcPath : srcPaths) {
            boolean existing = dstPaths.contains(srcPath);
            if (existing) {
                updates.add(srcPath);
                continue;
            }
            adds.add(srcPath);
        }
        for (String dstPath : dstPaths) {
            boolean extra = !srcPaths.contains(dstPath);
            if (!extra) continue;
            deletes.add(dstPath);
        }
        FileSystemUtils.copyFiles(request.getSrcDir(), request.getSrcFiles(), request.getDstDir());
        SyncResult result = new SyncResult();
        result.setAdds(FileSystemUtils.getFullPaths(request.getDstDir(), adds));
        result.setUpdates(FileSystemUtils.getFullPaths(request.getDstDir(), updates));
        result.setDeletes(FileSystemUtils.getFullPaths(request.getDstDir(), deletes));
        return result;
    }

    protected static void copyFiles(File srcDir, List<File> files, File dstDir) throws IOException {
        for (File file : files) {
            String relativePath = FileSystemUtils.getRelativePath(srcDir, file);
            File dstFile = new File(dstDir, relativePath);
            FileUtils.copyFile((File)file, (File)dstFile);
        }
    }

    protected static List<File> getFullPaths(File dir, List<String> relativePaths) {
        ArrayList<File> files = new ArrayList<File>();
        for (String relativePath : relativePaths) {
            File file = new File(dir, relativePath);
            files.add(file);
        }
        return files;
    }

    protected static List<String> getRelativePaths(File dir, List<File> files) {
        ArrayList<String> relativePaths = new ArrayList<String>();
        for (File file : files) {
            String relativePath = FileSystemUtils.getRelativePath(dir, file);
            relativePaths.add(relativePath);
        }
        return relativePaths;
    }

    protected static String getRelativePath(File dir, File file) {
        String dirPath = LocationUtils.getCanonicalPath(dir);
        String filePath = LocationUtils.getCanonicalPath(file);
        if (!StringUtils.contains((CharSequence)filePath, (CharSequence)dirPath)) {
            throw new IllegalArgumentException(file + " does not reside under " + dir);
        }
        return StringUtils.remove((String)filePath, (String)dirPath);
    }

    protected static List<File> getAllFiles(File dir) {
        SimpleScanner scanner = new SimpleScanner(dir, Arrays.asList("**/*"), Arrays.asList("**/.svn/**", "**/.git/**"));
        return scanner.getFiles();
    }
}

