/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.Project;
import org.kuali.common.util.ProjectUtils;
import org.kuali.common.util.PropertyUtils;
import org.kuali.common.util.property.ProjectProperties;
import org.kuali.common.util.property.PropertiesContext;
import org.kuali.common.util.property.processor.ProjectProcessor;
import org.kuali.common.util.property.processor.PropertyProcessor;
import org.kuali.common.util.property.processor.VersionProcessor;
import org.kuali.common.util.service.SpringContext;
import org.kuali.common.util.spring.SpringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;

public class MavenUtils {
    private static final Logger logger = LoggerFactory.getLogger(MavenUtils.class);
    public static final String POM = "pom";
    public static final String PROJECT_VERSION_KEY = "project.version";
    public static final String PROJECT_ENCODING_KEY = "project.encoding";

    public static SpringContext getMavenizedSpringContext(Class<?> propertySourceConfig) {
        return MavenUtils.getMavenizedSpringContext(null, propertySourceConfig);
    }

    public static SpringContext getMavenizedSpringContext(Properties mavenProperties, Class<?> propertySourceConfig) {
        PropertySource<?> source = SpringUtils.getSinglePropertySource(propertySourceConfig, "mavenProperties", mavenProperties);
        return SpringUtils.getSinglePropertySourceContext(source);
    }

    public static void augmentProjectProperties(Properties mavenProperties) {
        ArrayList<PropertyProcessor> processors = new ArrayList<PropertyProcessor>();
        processors.add(new ProjectProcessor());
        processors.add(new VersionProcessor(Arrays.asList(PROJECT_VERSION_KEY), true));
        PropertyUtils.process(mavenProperties, processors);
        String encoding = PropertyUtils.getRequiredResolvedProperty(mavenProperties, PROJECT_ENCODING_KEY);
        PropertyUtils.prepareContextProperties(mavenProperties, encoding);
    }

    public static ProjectProperties getMavenProjectProperties(Properties mavenProperties) {
        Project project = ProjectUtils.getProject(mavenProperties);
        PropertiesContext pc = new PropertiesContext();
        pc.setProperties(mavenProperties);
        ProjectProperties pp = new ProjectProperties();
        pp.setProject(project);
        pp.setPropertiesContext(pc);
        return pp;
    }

    protected static List<String> getList(Properties properties, String key) {
        String csv = properties.getProperty(key);
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(CollectionUtils.getTrimmedListFromCSV(csv));
        return list;
    }

    protected static List<String> getList(Environment env, Properties properties, String key) {
        String csv = env.getProperty(key);
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(CollectionUtils.getTrimmedListFromCSV(csv));
        list.addAll(MavenUtils.getList(properties, key));
        return list;
    }

    public static final boolean skip(boolean forceMojoExecution, boolean skip, String packaging) {
        if (forceMojoExecution) {
            logger.info("Forced mojo execution");
            return false;
        }
        if (skip) {
            logger.info("Skipping mojo execution");
            return true;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)packaging, (CharSequence)POM)) {
            logger.info("Skipping mojo execution for project with packaging type '{}'", (Object)POM);
            return true;
        }
        return false;
    }
}

