/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.Assert;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.Dependency;
import org.kuali.common.util.LocationUtils;
import org.kuali.common.util.Project;
import org.kuali.common.util.ProjectContext;
import org.kuali.common.util.PropertyUtils;
import org.kuali.common.util.ReflectionUtils;
import org.kuali.common.util.RepositoryUtils;
import org.kuali.common.util.Str;
import org.kuali.common.util.property.Constants;
import org.kuali.common.util.property.ProjectProperties;
import org.kuali.common.util.property.PropertiesContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.PropertyPlaceholderHelper;

public class ProjectUtils {
    private static final Logger logger = LoggerFactory.getLogger(ProjectUtils.class);
    private static final PropertyPlaceholderHelper PPH = Constants.DEFAULT_PROPERTY_PLACEHOLDER_HELPER;
    public static final String KUALI_COMMON_GROUP_ID = "org.kuali.common";
    private static final Map<String, Properties> PROJECT_PROPERTIES_CACHE = new HashMap<String, Properties>();

    public static ProjectProperties loadProjectProperties(ProjectContext context) {
        Project project = ProjectUtils.loadProject(context);
        PropertiesContext propertiesContext = new PropertiesContext(project.getProperties());
        propertiesContext.setEncoding(project.getEncoding());
        propertiesContext.setLocations(context.getPropertyLocations());
        return new ProjectProperties(project, propertiesContext);
    }

    public static Project loadProject(ProjectContext context) {
        return ProjectUtils.loadProject(ProjectUtils.getGav(context));
    }

    public static String getGav(ProjectContext context) {
        return ProjectUtils.getGav(context.getGroupId(), context.getArtifactId());
    }

    public static String getGav(Project project) {
        return ProjectUtils.getGav(project.getGroupId(), project.getArtifactId());
    }

    public static String getGav(String groupId, String artifactId) {
        return groupId + ":" + artifactId;
    }

    public static Project loadProject(String gav) {
        Project project = ProjectUtils.getProject(gav);
        Properties properties = ProjectUtils.loadProperties(project);
        return ProjectUtils.getProject(properties);
    }

    public static synchronized void clearProjectPropertiesCache() {
        PROJECT_PROPERTIES_CACHE.clear();
    }

    public static Project getProject(String gav) {
        logger.debug("Processing [{}]", (Object)gav);
        String[] tokens = StringUtils.split((String)gav, (String)":");
        Project project = new Project();
        if (tokens.length > 0) {
            project.setGroupId(RepositoryUtils.toNull(tokens[0]));
        }
        if (tokens.length > 1) {
            project.setArtifactId(RepositoryUtils.toNull(tokens[1]));
        }
        if (tokens.length > 2) {
            project.setPackaging(RepositoryUtils.toNull(tokens[2]));
        }
        if (tokens.length > 3) {
            project.setVersion(RepositoryUtils.toNull(tokens[3]));
        }
        if (tokens.length > 4) {
            project.setClassifier(RepositoryUtils.toNull(tokens[4]));
        }
        return project;
    }

    public static List<Dependency> getDependencies(String csv) {
        List<String> tokens = CollectionUtils.getTrimmedListFromCSV(csv);
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        for (String token : tokens) {
            Dependency dependency = RepositoryUtils.parseDependency(token);
            dependencies.add(dependency);
        }
        return dependencies;
    }

    public static Project getProject(Properties properties) {
        List<String> skipKeys = Arrays.asList("project.dependencies");
        String startsWith = "project.";
        List<String> keys = PropertyUtils.getStartsWithKeys(properties, startsWith);
        Project project = new Project();
        project.setProperties(properties);
        Map<String, Object> description = ReflectionUtils.describe(project);
        Set<String> beanProperties = description.keySet();
        for (String key : keys) {
            if (skipKeys.contains(key)) continue;
            String value = properties.getProperty(key);
            String beanProperty = ProjectUtils.getBeanProperty(key, startsWith);
            if (!beanProperties.contains(beanProperty)) continue;
            ReflectionUtils.copyProperty(project, beanProperty, value);
        }
        String csv = RepositoryUtils.toNull(properties.getProperty("project.dependencies"));
        List<Dependency> dependencies = ProjectUtils.getDependencies(csv);
        project.setDependencies(dependencies);
        return project;
    }

    protected static String getBeanProperty(String key, String startsWith) {
        String s = StringUtils.substring((String)key, (int)startsWith.length());
        String[] tokens = StringUtils.split((String)s, (String)".");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i == 0) {
                sb.append(token);
                continue;
            }
            sb.append(StringUtils.capitalize((String)token));
        }
        return sb.toString();
    }

    public static Properties loadProperties(String gav) {
        return ProjectUtils.loadProperties(ProjectUtils.getProject(gav));
    }

    public static synchronized Properties loadProperties(Project project) {
        String gav = ProjectUtils.getGav(project.getGroupId(), project.getArtifactId());
        Properties properties = PROJECT_PROPERTIES_CACHE.get(gav);
        if (properties != null) {
            return properties;
        }
        return ProjectUtils.loadAndCache(project, gav);
    }

    protected static Properties loadAndCache(Project project, String gav) {
        String location = ProjectUtils.getPropertiesFileLocation(project);
        if (!LocationUtils.exists(location)) {
            throw new IllegalArgumentException("[" + location + "] does not exist");
        }
        Properties properties = PropertyUtils.load(location);
        PROJECT_PROPERTIES_CACHE.put(gav, properties);
        return properties;
    }

    public static String getPropertiesFileLocation(Project project) {
        Assert.hasText((String)project.getGroupId(), (String)"groupId has no text");
        Assert.hasText((String)project.getArtifactId(), (String)"artifactId has no text");
        Properties properties = new Properties();
        properties.setProperty("project.groupId.path", Str.getPath(project.getGroupId()));
        properties.setProperty("project.artifactId", project.getArtifactId());
        return PPH.replacePlaceholders("classpath:META-INF/${project.groupId.path}/${project.artifactId}/project.properties", properties);
    }
}

