/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.util.MethodInvoker;

public class ReflectionUtils
extends org.springframework.util.ReflectionUtils {
    public static Map<String, Object> describe(Object bean) {
        try {
            return BeanUtils.describe((Object)bean);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void copyProperty(Object bean, String name, Object value) {
        try {
            BeanUtils.copyProperty((Object)bean, (String)name, (Object)value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Object invokeMethod(Class<?> targetClass, String targetMethod, Object ... arguments) {
        MethodInvoker invoker = new MethodInvoker();
        invoker.setTargetClass(targetClass);
        invoker.setTargetMethod(targetMethod);
        invoker.setArguments(arguments);
        return ReflectionUtils.invoke(invoker);
    }

    public static Object invoke(MethodInvoker invoker) {
        try {
            invoker.prepare();
            return invoker.invoke();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Class<?> getClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T newInstance(String className) {
        Class<?> clazz = ReflectionUtils.getClass(className);
        return (T)ReflectionUtils.newInstance(clazz);
    }

    public static <T> T newInstance(Class<T> instanceClass) {
        try {
            return instanceClass.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Unexpected error", e);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Unexpected error", e);
        }
    }
}

