/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.execute;

import java.io.File;
import java.util.List;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.LocationUtils;
import org.kuali.common.util.execute.AbstractCopyLocationsExecutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyLocationsToDirectoryExecutable
extends AbstractCopyLocationsExecutable {
    private static final Logger logger = LoggerFactory.getLogger(CopyLocationsToDirectoryExecutable.class);
    boolean addSequenceToFilenames = true;
    int initialSequenceNumber = 1;

    @Override
    protected List<File> getFiles(List<String> locations) {
        List<String> filenames = LocationUtils.getFilenames(locations);
        if (this.addSequenceToFilenames) {
            logger.debug("Adding sequences");
            filenames = CollectionUtils.getSequencedStrings(filenames, this.initialSequenceNumber);
        }
        return LocationUtils.getFiles(this.directory, filenames);
    }

    public boolean isAddSequenceToFilenames() {
        return this.addSequenceToFilenames;
    }

    public void setAddSequenceToFilenames(boolean addSequenceToFilenames) {
        this.addSequenceToFilenames = addSequenceToFilenames;
    }

    public int getInitialSequenceNumber() {
        return this.initialSequenceNumber;
    }

    public void setInitialSequenceNumber(int initialSequenceNumber) {
        this.initialSequenceNumber = initialSequenceNumber;
    }
}

