/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.execute;

import java.io.File;
import java.util.Properties;
import org.kuali.common.util.LocationUtils;
import org.kuali.common.util.PropertyUtils;
import org.kuali.common.util.execute.Executable;
import org.kuali.common.util.execute.ExecutionMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class RunOnceExecutable
implements Executable {
    private static final Logger logger = LoggerFactory.getLogger(RunOnceExecutable.class);
    Executable executable;
    File propertiesFile;
    String property;
    String encoding;
    boolean skip;

    @Override
    public void execute() {
        if (this.skip) {
            logger.info("Skipping execution");
            return;
        }
        Assert.notNull((Object)this.propertiesFile);
        Assert.notNull((Object)this.property);
        Assert.notNull((Object)this.executable);
        if (!this.propertiesFile.exists()) {
            logger.info("Skipping execution. File does not exist - [{}]", (Object)LocationUtils.getCanonicalPath(this.propertiesFile));
            return;
        }
        logger.info("Examining run once property [{}] in [{}]", (Object)this.property, (Object)LocationUtils.getCanonicalPath(this.propertiesFile));
        Properties properties = PropertyUtils.load(this.propertiesFile, this.encoding);
        ExecutionMode mode = this.getExecutionMode(properties, this.property);
        if (!this.isRunOnce(mode)) {
            logger.info("Skipping execution - [{}={}]", (Object)this.property, (Object)mode);
            return;
        }
        logger.info("{}={}", (Object)this.property, (Object)mode);
        if (!this.isAlways(mode)) {
            this.setState(properties, this.property, ExecutionMode.INPROGRESS);
        }
        try {
            this.executable.execute();
            if (!this.isAlways(mode)) {
                this.setState(properties, this.property, ExecutionMode.COMPLETED);
            }
        }
        catch (Exception e) {
            if (!this.isAlways(mode)) {
                this.setState(properties, this.property, ExecutionMode.FAILED);
            }
            throw new IllegalStateException("Unexpected execution error", e);
        }
    }

    protected boolean isAlways(ExecutionMode mode) {
        return ExecutionMode.ALWAYS.equals((Object)mode);
    }

    protected boolean isRunOnce(ExecutionMode mode) {
        if (ExecutionMode.RUNONCE.equals((Object)mode)) {
            return true;
        }
        if (this.isAlways(mode)) {
            return true;
        }
        return ExecutionMode.TRUE.equals((Object)mode);
    }

    protected ExecutionMode getExecutionMode(Properties properties, String key) {
        String value = properties.getProperty(this.property);
        if (value == null) {
            return ExecutionMode.NULL;
        }
        return ExecutionMode.valueOf(value.toUpperCase());
    }

    protected void setState(Properties properties, String key, ExecutionMode mode) {
        logger.info("{}={}", (Object)key, (Object)mode);
        properties.setProperty(this.property, mode.name());
        PropertyUtils.store(properties, this.propertiesFile, this.encoding);
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public void setExecutable(Executable executable) {
        this.executable = executable;
    }

    public File getPropertiesFile() {
        return this.propertiesFile;
    }

    public void setPropertiesFile(File propertiesFile) {
        this.propertiesFile = propertiesFile;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }
}

