/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.execute;

import java.io.File;
import java.util.List;
import java.util.Properties;
import org.kuali.common.util.LocationUtils;
import org.kuali.common.util.PropertyUtils;
import org.kuali.common.util.execute.Executable;
import org.springframework.util.Assert;

public class StorePropertiesExecutable
implements Executable {
    String encoding = "UTF-8";
    boolean skip;
    boolean skipIfExists = true;
    Properties properties;
    File outputFile;
    List<String> includes;
    List<String> excludes;

    @Override
    public void execute() {
        if (this.skip) {
            return;
        }
        Assert.notNull((Object)this.outputFile, (String)"outputFile is null");
        boolean exists = LocationUtils.exists(this.outputFile);
        if (exists && this.skipIfExists) {
            return;
        }
        Assert.notNull((Object)this.properties, (String)"properties is null");
        Properties duplicate = PropertyUtils.duplicate(this.properties);
        PropertyUtils.trim(duplicate, this.includes, this.excludes);
        this.store(duplicate, this.outputFile, this.encoding);
    }

    protected void store(Properties properties, File outputFile, String encoding) {
        PropertyUtils.store(properties, outputFile, encoding, null, true);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public boolean isSkipIfExists() {
        return this.skipIfExists;
    }

    public void setSkipIfExists(boolean skipIfExists) {
        this.skipIfExists = skipIfExists;
    }
}

