/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.property;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.jasypt.util.text.TextEncryptor;
import org.kuali.common.util.EncUtils;
import org.kuali.common.util.EncryptionMode;
import org.kuali.common.util.EncryptionStrength;
import org.kuali.common.util.LoggerUtils;
import org.kuali.common.util.PropertyUtils;
import org.kuali.common.util.Str;
import org.kuali.common.util.obscure.DefaultObscurer;
import org.kuali.common.util.obscure.Obscurer;
import org.kuali.common.util.property.Constants;
import org.kuali.common.util.property.GlobalPropertiesMode;
import org.kuali.common.util.property.PropertyContext;
import org.kuali.common.util.property.PropertyStyle;
import org.kuali.common.util.property.processor.AddPrefixProcessor;
import org.kuali.common.util.property.processor.EndsWithDecryptProcessor;
import org.kuali.common.util.property.processor.EndsWithEncryptProcessor;
import org.kuali.common.util.property.processor.GlobalOverrideProcessor;
import org.kuali.common.util.property.processor.OverrideProcessor;
import org.kuali.common.util.property.processor.PropertyProcessor;
import org.kuali.common.util.property.processor.ReformatKeysAsEnvVarsProcessor;
import org.kuali.common.util.property.processor.ResolvePlaceholdersProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.PropertyPlaceholderHelper;

public class DefaultPropertyContext
implements PropertyContext {
    private static final Logger logger = LoggerFactory.getLogger(DefaultPropertyContext.class);
    PropertyPlaceholderHelper helper = Constants.DEFAULT_PROPERTY_PLACEHOLDER_HELPER;
    String globalPropertiesMode = Constants.DEFAULT_GLOBAL_PROPERTIES_MODE.name();
    String resolvePlaceholders = Boolean.toString(true);
    Obscurer obscurer = new DefaultObscurer();
    String style = PropertyStyle.NORMAL.name();
    String encryptionMode = EncryptionMode.NONE.name();
    String encryptionStrength = EncryptionStrength.BASIC.name();
    String encryptionPassword;
    String prefix;
    List<PropertyProcessor> processors;
    Properties properties;
    Properties buildProperties;
    List<String> buildPropertyIncludes;
    List<String> buildPropertyExcludes;

    protected List<PropertyProcessor> getDefaultProcessors() {
        ArrayList<PropertyProcessor> processors = new ArrayList<PropertyProcessor>();
        if (this.buildProperties != null) {
            OverrideProcessor overrideProcessor = new OverrideProcessor(Constants.DEFAULT_PROPERTY_OVERWRITE_MODE, this.buildProperties);
            if (this.buildPropertyIncludes != null) {
                overrideProcessor.setIncludes(this.buildPropertyIncludes);
            }
            if (this.buildPropertyExcludes != null) {
                overrideProcessor.setExcludes(this.buildPropertyExcludes);
            }
            processors.add(overrideProcessor);
        }
        if (this.encryptionMode != null) {
            EncryptionMode mode = EncryptionMode.valueOf(this.encryptionMode);
            EncryptionStrength strength = EncryptionStrength.valueOf(this.encryptionStrength);
            processors.add(this.getEncProcessor(mode, strength, this.encryptionPassword));
        }
        this.encryptionPassword = null;
        GlobalPropertiesMode gpm = GlobalPropertiesMode.valueOf(this.globalPropertiesMode);
        processors.add(new GlobalOverrideProcessor(gpm));
        if (Boolean.parseBoolean(this.resolvePlaceholders)) {
            processors.add(new ResolvePlaceholdersProcessor(this.helper, gpm));
        }
        if (!StringUtils.isBlank((CharSequence)this.prefix)) {
            processors.add(new AddPrefixProcessor(this.prefix));
        }
        if (this.style != null) {
            processors.add(this.getStyleProcessor(this.style));
        }
        return processors;
    }

    protected PropertyProcessor getStyleProcessor(String style) {
        switch (PropertyStyle.valueOf(style)) {
            case NORMAL: {
                return Constants.NO_OP_PROCESSOR;
            }
            case ENVIRONMENT_VARIABLE: {
                return new ReformatKeysAsEnvVarsProcessor();
            }
        }
        throw new IllegalArgumentException("Property style " + style + " is unknown");
    }

    protected PropertyProcessor getEncProcessor(EncryptionMode mode, EncryptionStrength strength, String password) {
        switch (mode) {
            case NONE: {
                return Constants.NO_OP_PROCESSOR;
            }
            case ENCRYPT: {
                TextEncryptor encryptor = EncUtils.getTextEncryptor(strength, password);
                return new EndsWithEncryptProcessor(encryptor);
            }
            case DECRYPT: {
                TextEncryptor decryptor = EncUtils.getTextEncryptor(strength, password);
                return new EndsWithDecryptProcessor(decryptor);
            }
        }
        throw new IllegalArgumentException("Encryption mode '" + (Object)((Object)mode) + "' is unknown");
    }

    protected void log() {
        if (!StringUtils.equals((CharSequence)EncryptionMode.NONE.name(), (CharSequence)this.encryptionMode)) {
            logger.info("Encryption mode - " + StringUtils.trimToEmpty((String)this.encryptionMode));
            logger.info("Encryption strength - " + StringUtils.trimToEmpty((String)this.encryptionStrength));
            String displayPassword = LoggerUtils.getNullAsNone(this.encryptionPassword);
            if (this.encryptionPassword != null) {
                displayPassword = this.obscurer.obscure(this.encryptionPassword);
            }
            logger.info("Encryption password - " + displayPassword);
        }
        if (!StringUtils.equals((CharSequence)PropertyStyle.NORMAL.name(), (CharSequence)this.style)) {
            logger.info("Property style - " + StringUtils.trimToEmpty((String)this.style));
        }
        if (!StringUtils.isEmpty((CharSequence)this.prefix)) {
            logger.info("Property prefix - " + StringUtils.trimToEmpty((String)this.prefix));
        }
        if (!StringUtils.equals((CharSequence)Boolean.toString(true), (CharSequence)this.resolvePlaceholders)) {
            logger.info("Resolve placeholders - " + this.resolvePlaceholders);
        }
    }

    @Override
    public void initialize(Properties properties) {
        GlobalPropertiesMode gpm = GlobalPropertiesMode.valueOf(this.globalPropertiesMode);
        Properties global = PropertyUtils.getProperties(properties, gpm);
        this.encryptionMode = this.resolve(this.encryptionMode, global);
        this.encryptionPassword = this.resolveAndRemove(this.encryptionPassword, global, properties);
        this.encryptionStrength = this.resolve(this.encryptionStrength, global);
        this.style = this.resolve(this.style, global);
        this.prefix = this.resolve(this.prefix, global);
        this.resolvePlaceholders = this.resolve(this.resolvePlaceholders, global);
        this.log();
        this.validate();
        this.addProcessors();
        logger.info("Proceeding with " + this.processors.size() + " processors.");
    }

    protected void addProcessors() {
        List<PropertyProcessor> defaultProcessors = this.getDefaultProcessors();
        if (this.processors == null) {
            this.processors = defaultProcessors;
        } else {
            this.processors.addAll(0, defaultProcessors);
        }
    }

    protected void validate() {
        EncryptionMode.valueOf(this.encryptionMode);
        EncryptionStrength.valueOf(this.encryptionStrength);
        PropertyStyle.valueOf(this.style);
        Boolean.parseBoolean(this.resolvePlaceholders);
    }

    protected String getPlaceholderKey(String string) {
        String prefix = "${";
        String suffix = "}";
        String separator = ":";
        String key = StringUtils.substringBetween((String)string, (String)prefix, (String)separator);
        if (key == null) {
            return StringUtils.substringBetween((String)string, (String)prefix, (String)suffix);
        }
        return key;
    }

    protected void remove(String string, String resolvedString, Properties properties) {
        boolean remove;
        boolean placeholder = PropertyUtils.isSingleUnresolvedPlaceholder(string);
        boolean resolved = !StringUtils.equals((CharSequence)string, (CharSequence)resolvedString);
        boolean irrelevant = Str.contains(Arrays.asList("NONE", "NULL"), resolvedString, false);
        boolean bl = remove = placeholder && resolved && !irrelevant;
        if (remove) {
            String key = this.getPlaceholderKey(string);
            Assert.notNull((Object)key, (String)"key is null");
            if (properties.getProperty(key) != null) {
                logger.info("Removing property '" + key + "'");
                properties.remove(key);
            }
        }
    }

    protected String resolveAndRemove(String string, Properties global, Properties properties) {
        String resolvedString = this.resolve(string, global);
        this.remove(string, resolvedString, properties);
        return resolvedString;
    }

    protected String resolve(String string, Properties properties) {
        if (string == null) {
            return null;
        }
        String resolvedValue = this.helper.replacePlaceholders(string, properties);
        if (!StringUtils.equals((CharSequence)string, (CharSequence)resolvedValue)) {
            logger.debug("Resolved {} -> {}", (Object)string, (Object)resolvedValue);
        }
        return resolvedValue;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public PropertyPlaceholderHelper getHelper() {
        return this.helper;
    }

    public void setHelper(PropertyPlaceholderHelper helper) {
        this.helper = helper;
    }

    public String getEncryptionMode() {
        return this.encryptionMode;
    }

    public void setEncryptionMode(String encryptionMode) {
        this.encryptionMode = encryptionMode;
    }

    public String getEncryptionStrength() {
        return this.encryptionStrength;
    }

    public void setEncryptionStrength(String encryptionStrength) {
        this.encryptionStrength = encryptionStrength;
    }

    public String getEncryptionPassword() {
        return this.encryptionPassword;
    }

    public void setEncryptionPassword(String encryptionPassword) {
        this.encryptionPassword = encryptionPassword;
    }

    @Override
    public List<PropertyProcessor> getProcessors() {
        return this.processors;
    }

    public void setProcessors(List<PropertyProcessor> processors) {
        this.processors = processors;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getGlobalPropertiesMode() {
        return this.globalPropertiesMode;
    }

    public void setGlobalPropertiesMode(String globalPropertiesMode) {
        this.globalPropertiesMode = globalPropertiesMode;
    }

    public String getResolvePlaceholders() {
        return this.resolvePlaceholders;
    }

    public void setResolvePlaceholders(String resolvePlaceholders) {
        this.resolvePlaceholders = resolvePlaceholders;
    }

    public Obscurer getObscurer() {
        return this.obscurer;
    }

    public void setObscurer(Obscurer obscurer) {
        this.obscurer = obscurer;
    }

    public Properties getBuildProperties() {
        return this.buildProperties;
    }

    public void setBuildProperties(Properties buildProperties) {
        this.buildProperties = buildProperties;
    }

    public List<String> getBuildPropertyIncludes() {
        return this.buildPropertyIncludes;
    }

    public void setBuildPropertyIncludes(List<String> buildPropertyIncludes) {
        this.buildPropertyIncludes = buildPropertyIncludes;
    }

    public List<String> getBuildPropertyExcludes() {
        return this.buildPropertyExcludes;
    }

    public void setBuildPropertyExcludes(List<String> buildPropertyExcludes) {
        this.buildPropertyExcludes = buildPropertyExcludes;
    }
}

