/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.property.processor;

import java.util.List;
import java.util.Properties;
import org.kuali.common.util.Mode;
import org.kuali.common.util.PropertyUtils;
import org.kuali.common.util.property.Constants;
import org.kuali.common.util.property.GlobalPropertiesMode;
import org.kuali.common.util.property.processor.PropertyProcessor;

public class GlobalOverrideProcessor
implements PropertyProcessor {
    GlobalPropertiesMode globalPropertiesMode;
    Mode propertyOverwriteMode;
    List<String> includes;
    List<String> excludes;

    public GlobalOverrideProcessor() {
        this(Constants.DEFAULT_GLOBAL_PROPERTIES_MODE, Constants.DEFAULT_PROPERTY_OVERWRITE_MODE);
    }

    public GlobalOverrideProcessor(GlobalPropertiesMode globalPropertiesMode) {
        this(globalPropertiesMode, Constants.DEFAULT_PROPERTY_OVERWRITE_MODE);
    }

    public GlobalOverrideProcessor(GlobalPropertiesMode globalPropertiesMode, Mode propertyOverwriteMode) {
        this.globalPropertiesMode = globalPropertiesMode;
        this.propertyOverwriteMode = propertyOverwriteMode;
    }

    @Override
    public void process(Properties properties) {
        Properties global = PropertyUtils.getProperties(properties, this.globalPropertiesMode);
        List<String> keys = PropertyUtils.getSortedKeys(properties, this.includes, this.excludes);
        for (String key : keys) {
            String newValue = global.getProperty(key);
            PropertyUtils.addOrOverrideProperty(properties, key, newValue, this.propertyOverwriteMode);
        }
    }

    public GlobalPropertiesMode getGlobalPropertiesMode() {
        return this.globalPropertiesMode;
    }

    public void setGlobalPropertiesMode(GlobalPropertiesMode globalPropertiesMode) {
        this.globalPropertiesMode = globalPropertiesMode;
    }

    public Mode getPropertyOverwriteMode() {
        return this.propertyOverwriteMode;
    }

    public void setPropertyOverwriteMode(Mode propertyOverwriteMode) {
        this.propertyOverwriteMode = propertyOverwriteMode;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }
}

