/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.property.processor;

import java.util.List;
import java.util.Properties;
import org.kuali.common.util.Mode;
import org.kuali.common.util.PropertyUtils;
import org.kuali.common.util.property.Constants;
import org.kuali.common.util.property.processor.PropertyProcessor;

public class OverrideProcessor
implements PropertyProcessor {
    Mode propertyOverwriteMode;
    Properties overrideProperties;
    List<String> includes;
    List<String> excludes;

    public OverrideProcessor() {
        this(Constants.DEFAULT_PROPERTY_OVERWRITE_MODE);
    }

    public OverrideProcessor(Mode propertyOverwriteMode) {
        this(Constants.DEFAULT_PROPERTY_OVERWRITE_MODE, null);
    }

    public OverrideProcessor(Mode propertyOverwriteMode, Properties overrideProperties) {
        this.propertyOverwriteMode = propertyOverwriteMode;
        this.overrideProperties = overrideProperties;
    }

    @Override
    public void process(Properties properties) {
        List<String> keys = PropertyUtils.getSortedKeys(this.overrideProperties, this.includes, this.excludes);
        for (String key : keys) {
            String newValue = this.overrideProperties.getProperty(key);
            PropertyUtils.addOrOverrideProperty(properties, key, newValue, this.propertyOverwriteMode);
        }
    }

    public Mode getPropertyOverwriteMode() {
        return this.propertyOverwriteMode;
    }

    public void setPropertyOverwriteMode(Mode propertyOverwriteMode) {
        this.propertyOverwriteMode = propertyOverwriteMode;
    }

    public Properties getOverrideProperties() {
        return this.overrideProperties;
    }

    public void setOverrideProperties(Properties overrideProperties) {
        this.overrideProperties = overrideProperties;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }
}

