/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.property.processor;

import java.io.File;
import java.util.Properties;
import org.kuali.common.util.OrgUtils;
import org.kuali.common.util.Project;
import org.kuali.common.util.Str;
import org.kuali.common.util.property.processor.PropertyProcessor;
import org.springframework.util.Assert;

public class ProjectProcessor
implements PropertyProcessor {
    private static final String FS = File.separator;
    private static final String DOT = ".";

    @Override
    public void process(Properties properties) {
        Project p = this.getProject(properties);
        this.validate(p);
        String groupCode = OrgUtils.getGroupCode(p.getOrgId(), p.getGroupId());
        String groupBase = OrgUtils.getGroupBase(p.getOrgId(), p.getGroupId());
        String userHome = System.getProperty("user.home");
        String orgHome = userHome + FS + DOT + p.getOrgCode();
        String groupHome = orgHome + FS + groupCode;
        properties.setProperty("project.groupId.code", groupCode);
        properties.setProperty("project.groupId.path", Str.getPath(p.getGroupId()));
        properties.setProperty("project.groupId.base", groupBase);
        properties.setProperty("project.groupId.base.path", Str.getPath(groupBase));
        properties.setProperty("project.orgId.home", orgHome);
        properties.setProperty("project.groupId.home", groupHome);
        properties.setProperty("project.build.timestamp.millis", Long.toString(System.currentTimeMillis()));
    }

    protected void validate(Project project) {
        Assert.notNull((Object)project.getOrgId(), (String)"orgId is null");
        Assert.notNull((Object)project.getOrgCode(), (String)"orgCode is null");
        Assert.notNull((Object)project.getOrgPath(), (String)"orgPath is null");
        Assert.notNull((Object)project.getGroupId(), (String)"groupId is null");
        Assert.notNull((Object)project.getArtifactId(), (String)"artifactId is null");
        Assert.notNull((Object)project.getVersion(), (String)"version is null");
    }

    protected Project getProject(Properties properties) {
        Project project = new Project();
        project.setOrgId(properties.getProperty("project.orgId"));
        project.setOrgCode(properties.getProperty("project.orgId.code"));
        project.setOrgPath(properties.getProperty("project.orgId.path"));
        project.setGroupId(properties.getProperty("project.groupId"));
        project.setArtifactId(properties.getProperty("project.artifactId"));
        project.setVersion(properties.getProperty("project.version"));
        return project;
    }
}

