/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.secure;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.Assert;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.LocationUtils;
import org.kuali.common.util.PropertyUtils;
import org.kuali.common.util.Str;
import org.kuali.common.util.secure.ChannelUtils;
import org.kuali.common.util.secure.RemoteFile;
import org.kuali.common.util.secure.Result;
import org.kuali.common.util.secure.SSHUtils;
import org.kuali.common.util.secure.SecureChannel;
import org.kuali.common.util.secure.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSecureChannel
implements SecureChannel {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSecureChannel.class);
    private static final String SFTP = "sftp";
    private static final String EXEC = "exec";
    private static final String FORWARDSLASH = "/";
    private static final int DEFAULT_SLEEP_MILLIS = 10;
    private static final String DEFAULT_ENCODING = "UTF-8";
    File knownHosts = SSHUtils.DEFAULT_KNOWN_HOSTS;
    File config = SSHUtils.DEFAULT_CONFIG_FILE;
    boolean useConfigFile = true;
    boolean includeDefaultPrivateKeyLocations = true;
    boolean strictHostKeyChecking = true;
    int port = 22;
    int waitForClosedSleepMillis = 10;
    String encoding = "UTF-8";
    String username;
    String hostname;
    Integer connectTimeout;
    List<File> privateKeys;
    List<String> privateKeyStrings;
    Properties options;
    protected Session session;
    protected ChannelSftp sftp;

    @Override
    public synchronized void open() throws IOException {
        this.logOpen();
        this.validate();
        try {
            JSch jsch = this.getJSch();
            this.session = this.openSession(jsch);
            this.sftp = this.openSftpChannel(this.session, this.connectTimeout);
        }
        catch (JSchException e) {
            throw new IOException("Unexpected error opening secure channel", e);
        }
    }

    @Override
    public synchronized void close() {
        logger.info("Closing secure channel [{}]", (Object)ChannelUtils.getLocation(this.username, this.hostname));
        this.closeQuietly((Channel)this.sftp);
        this.closeQuietly(this.session);
    }

    @Override
    public Result executeCommand(String command) {
        return this.executeCommand(command, null);
    }

    @Override
    public Result executeCommand(String command, String stdin) {
        Result result;
        Assert.notBlank(command);
        ChannelExec exec = null;
        InputStream stdoutStream = null;
        ByteArrayOutputStream stderrStream = null;
        InputStream stdinStream = null;
        try {
            long start = System.currentTimeMillis();
            exec = (ChannelExec)this.session.openChannel(EXEC);
            byte[] commandBytes = Str.getBytes(command, this.encoding);
            exec.setCommand(commandBytes);
            stdinStream = this.getInputStream(stdin, this.encoding);
            stderrStream = new ByteArrayOutputStream();
            stdoutStream = exec.getInputStream();
            exec.setInputStream(stdinStream);
            exec.setErrStream((OutputStream)stderrStream);
            this.connect((Channel)exec, null);
            String stdout = Str.getString(IOUtils.toByteArray((InputStream)stdoutStream), this.encoding);
            String stderr = Str.getString(stderrStream.toByteArray(), this.encoding);
            this.waitForClosed(exec, this.waitForClosedSleepMillis);
            result = ChannelUtils.getExecutionResult(exec.getExitStatus(), start, command, stdin, stdout, stderr, this.encoding);
        }
        catch (Exception e) {
            try {
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stdinStream);
                IOUtils.closeQuietly(stdoutStream);
                IOUtils.closeQuietly(stderrStream);
                this.closeQuietly((Channel)exec);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)stdinStream);
        IOUtils.closeQuietly((InputStream)stdoutStream);
        IOUtils.closeQuietly((OutputStream)stderrStream);
        this.closeQuietly((Channel)exec);
        return result;
    }

    @Override
    public void executeNoWait(String command) {
        Assert.notBlank(command);
        ChannelExec exec = null;
        try {
            exec = (ChannelExec)this.session.openChannel(EXEC);
            byte[] commandBytes = Str.getBytes(command, this.encoding);
            exec.setCommand(commandBytes);
            this.connect((Channel)exec, null);
            this.closeQuietly((Channel)exec);
        }
        catch (Exception e) {
            try {
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                this.closeQuietly((Channel)exec);
                throw throwable;
            }
        }
    }

    protected InputStream getInputStream(String s, String encoding) {
        if (s == null) {
            return null;
        }
        return new ByteArrayInputStream(Str.getBytes(s, encoding));
    }

    protected void waitForClosed(ChannelExec exec, long millis) {
        while (!exec.isClosed()) {
            this.sleep(millis);
        }
    }

    protected void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public RemoteFile getWorkingDirectory() {
        try {
            String workingDirectory = this.sftp.pwd();
            return this.getMetaData(workingDirectory);
        }
        catch (SftpException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void validate() {
        Assert.isTrue((boolean)SSHUtils.isValidPort(this.port));
        Assert.notBlank(this.hostname);
        Assert.notBlank(this.encoding);
    }

    protected void logOpen() {
        logger.info("Opening secure channel [{}] encoding={}", (Object)ChannelUtils.getLocation(this.username, this.hostname), (Object)this.encoding);
        logger.debug("Private key files - {}", (Object)CollectionUtils.toEmptyList(this.privateKeys).size());
        logger.debug("Private key strings - {}", (Object)CollectionUtils.toEmptyList(this.privateKeyStrings).size());
        logger.debug("Private key config file - {}", (Object)this.config);
        logger.debug("Private key config file use - {}", (Object)this.useConfigFile);
        logger.debug("Include default private key locations - {}", (Object)this.includeDefaultPrivateKeyLocations);
        logger.debug("Known hosts file - {}", (Object)this.knownHosts);
        logger.debug("Port - {}", (Object)this.port);
        logger.debug("Connect timeout - {}", (Object)this.connectTimeout);
        logger.debug("Strict host key checking - {}", (Object)this.strictHostKeyChecking);
        logger.debug("Configuring channel with {} custom options", (Object)PropertyUtils.toEmpty(this.options).size());
        if (this.options != null) {
            PropertyUtils.debug(this.options);
        }
    }

    protected ChannelSftp openSftpChannel(Session session, Integer timeout) throws JSchException {
        ChannelSftp sftp = (ChannelSftp)session.openChannel(SFTP);
        this.connect((Channel)sftp, timeout);
        return sftp;
    }

    protected void connect(Channel channel, Integer timeout) throws JSchException {
        if (timeout == null) {
            channel.connect();
        } else {
            channel.connect(timeout.intValue());
        }
    }

    protected void closeQuietly(Session session) {
        if (session != null) {
            session.disconnect();
        }
    }

    protected void closeQuietly(Channel channel) {
        if (channel != null) {
            channel.disconnect();
        }
    }

    protected Properties getSessionProperties(Properties options, boolean strictHostKeyChecking) {
        Properties properties = new Properties();
        if (options != null) {
            properties.putAll((Map<?, ?>)options);
        }
        if (!strictHostKeyChecking) {
            properties.setProperty("StrictHostKeyChecking", "no");
        }
        return properties;
    }

    protected Session openSession(JSch jsch) throws JSchException {
        Session session = jsch.getSession(this.username, this.hostname, this.port);
        session.setConfig(this.getSessionProperties(this.options, this.strictHostKeyChecking));
        if (this.connectTimeout == null) {
            session.connect();
        } else {
            session.connect(this.connectTimeout.intValue());
        }
        return session;
    }

    protected JSch getJSch() throws JSchException {
        List<File> uniquePrivateKeyFiles = this.getUniquePrivateKeyFiles();
        logger.debug("Located {} private keys on the file system", (Object)uniquePrivateKeyFiles.size());
        JSch jsch = this.getJSch(uniquePrivateKeyFiles, this.privateKeyStrings);
        if (this.strictHostKeyChecking && this.knownHosts != null) {
            String path = LocationUtils.getCanonicalPath(this.knownHosts);
            jsch.setKnownHosts(path);
        }
        return jsch;
    }

    protected JSch getJSch(List<File> privateKeys, List<String> privateKeyStrings) throws JSchException {
        JSch jsch = new JSch();
        for (File privateKey : privateKeys) {
            String path = LocationUtils.getCanonicalPath(privateKey);
            jsch.addIdentity(path);
        }
        int count = 0;
        for (String privateKeyString : CollectionUtils.toEmptyList(privateKeyStrings)) {
            String name = "privateKeyString-" + Integer.toString(count++);
            byte[] bytes = Str.getBytes(privateKeyString, this.encoding);
            jsch.addIdentity(name, bytes, null, null);
        }
        return jsch;
    }

    protected List<File> getUniquePrivateKeyFiles() {
        ArrayList<String> paths = new ArrayList<String>();
        if (this.privateKeys != null) {
            for (File privateKey : this.privateKeys) {
                paths.add(LocationUtils.getCanonicalPath(privateKey));
            }
        }
        if (this.useConfigFile) {
            for (String path : SSHUtils.getFilenames(this.config)) {
                paths.add(path);
            }
        }
        if (this.includeDefaultPrivateKeyLocations) {
            for (String path : SSHUtils.PRIVATE_KEY_DEFAULTS) {
                paths.add(path);
            }
        }
        List<String> uniquePaths = CollectionUtils.getUniqueStrings(paths);
        return SSHUtils.getExistingAndReadable(uniquePaths);
    }

    @Override
    public RemoteFile getMetaData(String absolutePath) {
        Assert.hasLength((String)absolutePath);
        RemoteFile file = new RemoteFile();
        file.setAbsolutePath(absolutePath);
        this.fillInAttributes(file, absolutePath);
        return file;
    }

    @Override
    public void deleteFile(String absolutePath) {
        RemoteFile file = this.getMetaData(absolutePath);
        if (this.isStatus(file, Status.MISSING)) {
            return;
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException("[" + ChannelUtils.getLocation(this.username, this.hostname, file) + "] is a directory.");
        }
        try {
            this.sftp.rm(absolutePath);
        }
        catch (SftpException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public boolean exists(String absolutePath) {
        RemoteFile file = this.getMetaData(absolutePath);
        return this.isStatus(file, Status.EXISTS);
    }

    @Override
    public boolean isDirectory(String absolutePath) {
        RemoteFile file = this.getMetaData(absolutePath);
        return this.isStatus(file, Status.EXISTS) && file.isDirectory();
    }

    protected void fillInAttributes(RemoteFile file) {
        this.fillInAttributes(file, file.getAbsolutePath());
    }

    protected void fillInAttributes(RemoteFile file, String path) {
        try {
            SftpATTRS attributes = this.sftp.stat(path);
            this.fillInAttributes(file, attributes);
        }
        catch (SftpException e) {
            this.handleNoSuchFileException(file, e);
        }
    }

    protected void fillInAttributes(RemoteFile file, SftpATTRS attributes) {
        file.setDirectory(attributes.isDir());
        file.setPermissions(attributes.getPermissions());
        file.setUserId(attributes.getUId());
        file.setGroupId(attributes.getGId());
        file.setSize(attributes.getSize());
        file.setStatus(Status.EXISTS);
    }

    @Override
    public void copyFile(File source, RemoteFile destination) {
        Assert.notNull((Object)source);
        Assert.isTrue((boolean)source.exists());
        Assert.isTrue((!source.isDirectory() ? 1 : 0) != 0);
        Assert.isTrue((boolean)source.canRead());
        this.copyLocationToFile(LocationUtils.getCanonicalURLString(source), destination);
    }

    @Override
    public void copyFileToDirectory(File source, RemoteFile destination) {
        RemoteFile clone = this.clone(destination);
        String filename = source.getName();
        this.addFilenameToPath(clone, filename);
        this.copyFile(source, clone);
    }

    protected RemoteFile clone(RemoteFile file) {
        try {
            RemoteFile clone = new RemoteFile();
            BeanUtils.copyProperties((Object)clone, (Object)file);
            return clone;
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void copyLocationToFile(String location, RemoteFile destination) {
        Assert.notNull((Object)location);
        Assert.isTrue((boolean)LocationUtils.exists(location), (String)(location + " does not exist"));
        InputStream in = null;
        try {
            in = LocationUtils.getInputStream(location);
            this.copyInputStreamToFile(in, destination);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    @Override
    public void copyStringToFile(String string, RemoteFile destination) {
        Assert.notNull((Object)string);
        Assert.notBlank(this.encoding);
        ByteArrayInputStream in = new ByteArrayInputStream(Str.getBytes(string, this.encoding));
        this.copyInputStreamToFile(in, destination);
        IOUtils.closeQuietly((InputStream)in);
    }

    @Override
    public String toString(RemoteFile source) {
        Assert.notNull((Object)source);
        Assert.hasText((String)source.getAbsolutePath());
        Assert.notBlank(this.encoding);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.copyFile(source, out);
            String string = out.toString(this.encoding);
            return string;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected IO error", e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    @Override
    public void copyInputStreamToFile(InputStream source, RemoteFile destination) {
        Assert.notNull((Object)source);
        try {
            this.createDirectories(destination);
            this.sftp.put(source, destination.getAbsolutePath());
        }
        catch (SftpException e) {
            throw new IllegalStateException(e);
        }
    }

    protected String getAbsolutePath(String absolutePath, String filename) {
        if (StringUtils.endsWith((CharSequence)absolutePath, (CharSequence)FORWARDSLASH)) {
            return absolutePath + filename;
        }
        return absolutePath + FORWARDSLASH + filename;
    }

    protected void addFilenameToPath(RemoteFile destination, String filename) {
        String newAbsolutePath = this.getAbsolutePath(destination.getAbsolutePath(), filename);
        destination.setAbsolutePath(newAbsolutePath);
        destination.setDirectory(false);
    }

    @Override
    public void copyLocationToDirectory(String location, RemoteFile destination) {
        RemoteFile clone = this.clone(destination);
        String filename = LocationUtils.getFilename(location);
        this.addFilenameToPath(clone, filename);
        this.copyLocationToFile(location, clone);
    }

    @Override
    public void copyFile(RemoteFile source, File destination) {
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(FileUtils.openOutputStream((File)destination));
            this.copyFile(source, out);
        }
        catch (Exception e) {
            try {
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
    }

    @Override
    public void copyRemoteFile(String absolutePath, OutputStream out) throws IOException {
        try {
            this.sftp.get(absolutePath, out);
        }
        catch (SftpException e) {
            throw new IOException("Unexpected IO error", e);
        }
    }

    @Override
    public void copyFile(RemoteFile source, OutputStream out) throws IOException {
        this.copyRemoteFile(source.getAbsolutePath(), out);
    }

    @Override
    public void copyFileToDirectory(RemoteFile source, File destination) {
        String filename = FilenameUtils.getName((String)source.getAbsolutePath());
        File newDestination = new File(destination, filename);
        this.copyFile(source, newDestination);
    }

    @Override
    public void createDirectory(RemoteFile dir) {
        Assert.isTrue((boolean)dir.isDirectory());
        try {
            this.createDirectories(dir);
        }
        catch (SftpException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void createDirectories(RemoteFile file) throws SftpException {
        boolean directoryIndicator = file.isDirectory();
        this.fillInAttributes(file);
        this.validate(file, directoryIndicator);
        List<String> directories = LocationUtils.getNormalizedPathFragments(file.getAbsolutePath(), file.isDirectory());
        for (String directory : directories) {
            RemoteFile parentDir = new RemoteFile(directory);
            this.fillInAttributes(parentDir);
            this.validate(parentDir, true);
            if (this.isStatus(parentDir, Status.EXISTS)) continue;
            this.mkdir(parentDir);
        }
    }

    protected boolean isStatus(RemoteFile file, Status status) {
        return file.getStatus().equals((Object)status);
    }

    protected void validate(RemoteFile file, Status ... allowed) {
        for (Status status : allowed) {
            if (!this.isStatus(file, status)) continue;
            return;
        }
        throw new IllegalArgumentException("Invalid status - " + (Object)((Object)file.getStatus()));
    }

    protected boolean validate(RemoteFile file, boolean directoryIndicator) {
        boolean valid;
        this.validate(file, Status.MISSING, Status.EXISTS);
        boolean missing = this.isStatus(file, Status.MISSING);
        boolean exists = this.isStatus(file, Status.EXISTS);
        boolean correctFileType = file.isDirectory() == directoryIndicator;
        boolean bl = valid = missing || exists && correctFileType;
        if (valid) {
            return true;
        }
        throw new IllegalArgumentException(this.getInvalidExistingFileMessage(file));
    }

    protected String getInvalidExistingFileMessage(RemoteFile existing) {
        if (existing.isDirectory()) {
            return "[" + ChannelUtils.getLocation(this.username, this.hostname, existing) + "] is an existing directory. Unable to create file.";
        }
        return "[" + ChannelUtils.getLocation(this.username, this.hostname, existing) + "] is an existing file. Unable to create directory.";
    }

    protected void mkdir(RemoteFile dir) {
        try {
            String path = dir.getAbsolutePath();
            logger.debug("Creating [{}]", (Object)path);
            this.sftp.mkdir(path);
            this.setAttributes(dir);
        }
        catch (SftpException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void setAttributes(RemoteFile file) throws SftpException {
        String path = file.getAbsolutePath();
        if (file.getPermissions() != null) {
            this.sftp.chmod(file.getPermissions().intValue(), path);
        }
        if (file.getGroupId() != null) {
            this.sftp.chgrp(file.getGroupId().intValue(), path);
        }
        if (file.getUserId() != null) {
            this.sftp.chown(file.getUserId().intValue(), path);
        }
    }

    protected void handleNoSuchFileException(RemoteFile file, SftpException e) {
        if (!this.isNoSuchFileException(e)) {
            throw new IllegalStateException(e);
        }
        file.setStatus(Status.MISSING);
    }

    protected boolean isNoSuchFileException(SftpException exception) {
        return exception.id == 2;
    }

    public File getKnownHosts() {
        return this.knownHosts;
    }

    public void setKnownHosts(File knownHosts) {
        this.knownHosts = knownHosts;
    }

    public File getConfig() {
        return this.config;
    }

    public void setConfig(File config) {
        this.config = config;
    }

    public boolean isIncludeDefaultPrivateKeyLocations() {
        return this.includeDefaultPrivateKeyLocations;
    }

    public void setIncludeDefaultPrivateKeyLocations(boolean includeDefaultPrivateKeyLocations) {
        this.includeDefaultPrivateKeyLocations = includeDefaultPrivateKeyLocations;
    }

    public boolean isStrictHostKeyChecking() {
        return this.strictHostKeyChecking;
    }

    public void setStrictHostKeyChecking(boolean strictHostKeyChecking) {
        this.strictHostKeyChecking = strictHostKeyChecking;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public List<File> getPrivateKeys() {
        return this.privateKeys;
    }

    public void setPrivateKeys(List<File> privateKeys) {
        this.privateKeys = privateKeys;
    }

    public Properties getOptions() {
        return this.options;
    }

    public void setOptions(Properties options) {
        this.options = options;
    }

    public void setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getWaitForClosedSleepMillis() {
        return this.waitForClosedSleepMillis;
    }

    public void setWaitForClosedSleepMillis(int waitForClosedSleepMillis) {
        this.waitForClosedSleepMillis = waitForClosedSleepMillis;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public List<String> getPrivateKeyStrings() {
        return this.privateKeyStrings;
    }

    public void setPrivateKeyStrings(List<String> privateKeyStrings) {
        this.privateKeyStrings = privateKeyStrings;
    }

    public boolean isUseConfigFile() {
        return this.useConfigFile;
    }

    public void setUseConfigFile(boolean useConfigFile) {
        this.useConfigFile = useConfigFile;
    }
}

