/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.service;

import java.io.InputStream;
import java.util.List;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.LoggerLevel;
import org.kuali.common.util.LoggingStreamConsumer;
import org.kuali.common.util.service.DefaultExecContext;
import org.kuali.common.util.service.ExecContext;
import org.kuali.common.util.service.ExecService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExecService
implements ExecService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultExecService.class);

    @Override
    public int execute(ExecContext context) {
        Commandline cl = this.getCommandLine(context);
        return this.execute(context, cl);
    }

    @Override
    public int execute(String executable, List<String> args) {
        DefaultExecContext context = new DefaultExecContext();
        context.setExecutable(executable);
        context.setArgs(args);
        return this.execute(context);
    }

    protected int executeAndValidate(String executable, List<String> args) {
        int exitValue = this.execute(executable, args);
        this.validateExitValue(exitValue);
        return exitValue;
    }

    protected int executeAndValidate(ExecContext context) {
        int exitValue = this.execute(context);
        this.validateExitValue(exitValue);
        return exitValue;
    }

    protected int execute(ExecContext context, Commandline cl) {
        try {
            logger.debug("[{}]", (Object)cl);
            StreamConsumer stdout = this.getStreamConsumer(context.getStandardOutConsumer(), logger, LoggerLevel.INFO);
            StreamConsumer stderr = this.getStreamConsumer(context.getStandardErrConsumer(), logger, LoggerLevel.WARN);
            return CommandLineUtils.executeCommandLine((Commandline)cl, (InputStream)context.getInput(), (StreamConsumer)stdout, (StreamConsumer)stderr, (int)context.getTimeoutInSeconds());
        }
        catch (CommandLineException e) {
            throw new IllegalStateException(e);
        }
    }

    protected StreamConsumer getStreamConsumer(StreamConsumer provided, Logger logger, LoggerLevel level) {
        if (provided != null) {
            return provided;
        }
        return new LoggingStreamConsumer(logger, level);
    }

    protected void validateExitValue(int exitValue) {
        if (exitValue != 0) {
            throw new IllegalStateException("Non-zero exit value - " + exitValue);
        }
    }

    protected Commandline getCommandLine(ExecContext context) {
        Commandline cl = new Commandline();
        cl.setExecutable(context.getExecutable());
        if (context.isAddSystemEnvironment()) {
            try {
                cl.addSystemEnvironment();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        if (context.getArgs() != null) {
            cl.addArguments(CollectionUtils.toStringArray(context.getArgs()));
        }
        if (context.getWorkingDirectory() != null) {
            cl.setWorkingDirectory(context.getWorkingDirectory());
        }
        return cl;
    }
}

