/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.service;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.Assert;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.LocationUtils;
import org.kuali.common.util.service.PropertySourceAddPriority;
import org.kuali.common.util.service.PropertySourceContext;
import org.kuali.common.util.service.SpringContext;
import org.kuali.common.util.service.SpringService;
import org.kuali.common.util.spring.SpringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public class DefaultSpringService
implements SpringService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSpringService.class);

    @Override
    public void load(Class<?> annotatedClass) {
        this.load(annotatedClass, null, null);
    }

    @Override
    public void load(Class<?> annotatedClass, String beanName, Object bean, PropertySource<?> propertySource) {
        Assert.notNull(annotatedClass, (String)"annotatedClass is null");
        SpringContext context = new SpringContext();
        context.setAnnotatedClasses(CollectionUtils.asList(annotatedClass));
        context.setPropertySourceContext(new PropertySourceContext(SpringUtils.asList(propertySource)));
        context.setBeanNames(CollectionUtils.toEmptyList(beanName));
        context.setBeans(CollectionUtils.toEmptyList(bean));
        this.load(context);
    }

    @Override
    public void load(Class<?> annotatedClass, String beanName, Object bean) {
        this.load(annotatedClass, beanName, bean, null);
    }

    @Override
    public void load(String location) {
        this.load(location, null, null);
    }

    @Override
    public void load(String location, String beanName, Object bean, PropertySource<?> propertySource) {
        Assert.hasText((String)location, (String)"location is null");
        SpringContext context = new SpringContext();
        context.setLocations(Arrays.asList(location));
        context.setPropertySourceContext(new PropertySourceContext(SpringUtils.asList(propertySource)));
        context.setBeanNames(CollectionUtils.toEmptyList(beanName));
        context.setBeans(CollectionUtils.toEmptyList(bean));
        this.load(context);
    }

    @Override
    public void load(String location, String beanName, Object bean) {
        this.load(location, beanName, bean, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(SpringContext context) {
        context.setBeanNames(CollectionUtils.toEmptyList(context.getBeanNames()));
        context.setBeans(CollectionUtils.toEmptyList(context.getBeans()));
        context.setAnnotatedClasses(CollectionUtils.toEmptyList(context.getAnnotatedClasses()));
        context.setLocations(CollectionUtils.toEmptyList(context.getLocations()));
        boolean empty = CollectionUtils.isEmpty(context.getLocations()) && CollectionUtils.isEmpty(context.getAnnotatedClasses());
        Assert.isFalse(empty, "Both locations and annotatedClasses are empty");
        Assert.isTrue((context.getBeanNames().size() == context.getBeans().size() ? 1 : 0) != 0);
        SpringUtils.validateExists(context.getLocations());
        List<String> convertedLocations = this.getConvertedLocations(context.getLocations());
        String[] locationsArray = CollectionUtils.toStringArray(convertedLocations);
        ConfigurableApplicationContext parent = null;
        ClassPathXmlApplicationContext xmlChild = null;
        AnnotationConfigApplicationContext annotationChild = null;
        if (this.isParentContextRequired(context)) {
            parent = SpringUtils.getContextWithPreRegisteredBeans(context.getId(), context.getDisplayName(), context.getBeanNames(), context.getBeans());
        }
        if (!CollectionUtils.isEmpty(context.getAnnotatedClasses())) {
            annotationChild = this.getAnnotationContext(context, parent);
            this.addPropertySources(context, (ConfigurableApplicationContext)annotationChild);
        }
        if (!CollectionUtils.isEmpty(context.getLocations())) {
            xmlChild = new ClassPathXmlApplicationContext(locationsArray, false, (ApplicationContext)parent);
            if (parent == null) {
                this.addMetaInfo(xmlChild, context);
            }
            this.addPropertySources(context, (ConfigurableApplicationContext)xmlChild);
        }
        SpringUtils.refreshQuietly((ConfigurableApplicationContext)annotationChild);
        SpringUtils.refreshQuietly(xmlChild);
        this.debugQuietly((ApplicationContext)parent, (ApplicationContext)annotationChild, (ApplicationContext)xmlChild);
    }

    protected void debugQuietly(ApplicationContext parent, ApplicationContext child1, ApplicationContext child2) {
        if (!logger.isDebugEnabled()) {
            return;
        }
        if (parent != null) {
            SpringUtils.debug(parent);
        } else {
            if (child1 != null) {
                SpringUtils.debug(child1);
            }
            if (child2 != null) {
                SpringUtils.debug(child2);
            }
        }
    }

    protected void addMetaInfo(AnnotationConfigApplicationContext ctx, SpringContext sc) {
        if (!StringUtils.isBlank((CharSequence)sc.getId())) {
            ctx.setId(sc.getId());
        }
        if (!StringUtils.isBlank((CharSequence)sc.getDisplayName())) {
            ctx.setDisplayName(sc.getDisplayName());
        }
    }

    protected void addMetaInfo(ClassPathXmlApplicationContext ctx, SpringContext sc) {
        if (!StringUtils.isBlank((CharSequence)sc.getId())) {
            ctx.setId(sc.getId());
        }
        if (!StringUtils.isBlank((CharSequence)sc.getDisplayName())) {
            ctx.setDisplayName(sc.getDisplayName());
        }
    }

    protected AnnotationConfigApplicationContext getAnnotationContext(SpringContext context, ConfigurableApplicationContext parent) {
        AnnotationConfigApplicationContext ctx = new AnnotationConfigApplicationContext();
        if (parent != null) {
            ctx.setParent((ApplicationContext)parent);
        } else {
            this.addMetaInfo(ctx, context);
        }
        for (Class<?> annotatedClass : context.getAnnotatedClasses()) {
            ctx.register(new Class[]{annotatedClass});
        }
        return ctx;
    }

    protected void addPropertySources(SpringContext context, ConfigurableApplicationContext applicationContext) {
        PropertySourceContext psc = context.getPropertySourceContext();
        ConfigurableEnvironment env = applicationContext.getEnvironment();
        if (psc.isRemoveExistingSources()) {
            logger.debug("Removing all existing property sources");
            SpringUtils.removeAllPropertySources(env);
        }
        if (CollectionUtils.isEmpty(psc.getSources())) {
            return;
        }
        List<PropertySource<?>> propertySources = psc.getSources();
        MutablePropertySources sources = env.getPropertySources();
        if (psc.isLastOneInWins()) {
            Collections.reverse(propertySources);
        }
        PropertySourceAddPriority priority = psc.getPriority();
        block4: for (PropertySource<?> propertySource : propertySources) {
            Object[] args = new Object[]{propertySource.getName(), propertySource.getClass().getName(), priority};
            logger.debug("Adding property source - [{}] -> [{}] Priority=[{}]", args);
            switch (priority) {
                case FIRST: {
                    sources.addFirst(propertySource);
                    continue block4;
                }
                case LAST: {
                    sources.addLast(propertySource);
                    continue block4;
                }
            }
            throw new IllegalStateException((Object)((Object)priority) + " is an unknown priority");
        }
    }

    protected boolean isParentContextRequired(SpringContext context) {
        if (!CollectionUtils.isEmpty(context.getBeanNames())) {
            return true;
        }
        return !CollectionUtils.isEmpty(context.getBeans());
    }

    protected List<String> getConvertedLocations(List<String> locations) {
        ArrayList<String> converted = new ArrayList<String>();
        for (String location : locations) {
            if (LocationUtils.isExistingFile(location)) {
                File file = new File(location);
                String url = LocationUtils.getCanonicalURLString(file);
                converted.add(url);
                continue;
            }
            converted.add(location);
        }
        return converted;
    }
}

