/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.spring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.kuali.common.util.Project;
import org.kuali.common.util.ProjectContext;
import org.kuali.common.util.ProjectUtils;
import org.kuali.common.util.property.ProjectProperties;
import org.kuali.common.util.property.PropertiesContext;

public class ConfigUtils {
    public static List<ProjectProperties> getProjectProperties(List<ProjectContext> contexts) {
        ArrayList<ProjectProperties> list = new ArrayList<ProjectProperties>();
        for (ProjectContext context : contexts) {
            Project project = ProjectUtils.loadProject(context);
            ProjectProperties pp = ConfigUtils.getProjectProperties(project, context.getPropertyLocations());
            list.add(pp);
        }
        return list;
    }

    public static List<ProjectProperties> getProjectProperties(ProjectContext ... contexts) {
        return ConfigUtils.getProjectProperties(Arrays.asList(contexts));
    }

    public static ProjectProperties getProjectProperties(ProjectContext context) {
        Project project = ProjectUtils.loadProject(context);
        return ConfigUtils.getProjectProperties(project, context.getPropertyLocations());
    }

    public static ProjectProperties getProjectProperties(Project project, List<String> locations) {
        PropertiesContext pc = new PropertiesContext();
        pc.setEncoding(project.getEncoding());
        pc.setLocations(locations);
        return new ProjectProperties(project, pc);
    }
}

