/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.spring;

import org.codehaus.plexus.util.StringUtils;
import org.kuali.common.util.service.ScmService;
import org.kuali.common.util.service.ScmType;
import org.kuali.common.util.service.SvnService;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.util.Assert;

public class ScmServiceFactoryBean
implements FactoryBean<ScmService> {
    String url;
    boolean singleton = true;

    public ScmService getObject() {
        Assert.hasText((String)this.url, (String)"URL has no text");
        String[] tokens = StringUtils.split((String)this.url, (String)":");
        String scmType = tokens[1].toUpperCase();
        ScmType type = ScmType.valueOf(scmType);
        switch (type) {
            case SVN: {
                return new SvnService();
            }
            case GIT: {
                throw new IllegalArgumentException("GIT support is coming soon!");
            }
        }
        throw new IllegalArgumentException("SCM type [" + scmType + "] is unknown");
    }

    public Class<ScmService> getObjectType() {
        return ScmService.class;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }
}

