/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.spring;

import java.util.List;
import java.util.Properties;
import org.kuali.common.util.execute.Executable;
import org.kuali.common.util.execute.ShowPropertiesExecutable;
import org.kuali.common.util.spring.SpringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class ShowMavenPropertiesConfig {
    @Autowired
    Environment env;
    @Autowired
    @Qualifier(value="mavenProperties")
    Properties mavenProperties;

    @Bean(initMethod="execute")
    public Executable showPropertiesExecutable() {
        List<String> includes = SpringUtils.getListFromCSV(this.env, "properties.show.includes", "*");
        List<String> excludes = SpringUtils.getListFromCSV(this.env, "properties.show.excludes", "");
        ShowPropertiesExecutable executable = new ShowPropertiesExecutable();
        executable.setProperties(this.mavenProperties);
        executable.setExcludes(excludes);
        executable.setIncludes(includes);
        return executable;
    }
}

