/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.spring;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.codehaus.plexus.util.StringUtils;
import org.kuali.common.util.Assert;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.FormatUtils;
import org.kuali.common.util.LocationUtils;
import org.kuali.common.util.LoggerLevel;
import org.kuali.common.util.LoggerUtils;
import org.kuali.common.util.Project;
import org.kuali.common.util.ProjectContext;
import org.kuali.common.util.ProjectUtils;
import org.kuali.common.util.PropertyUtils;
import org.kuali.common.util.ReflectionUtils;
import org.kuali.common.util.Str;
import org.kuali.common.util.execute.Executable;
import org.kuali.common.util.execute.SpringExecutable;
import org.kuali.common.util.nullify.NullUtils;
import org.kuali.common.util.property.ProjectProperties;
import org.kuali.common.util.property.PropertiesContext;
import org.kuali.common.util.service.DefaultSpringService;
import org.kuali.common.util.service.PropertySourceContext;
import org.kuali.common.util.service.SpringContext;
import org.kuali.common.util.service.SpringService;
import org.kuali.common.util.spring.PropertySourceConversionResult;
import org.kuali.common.util.spring.PropertySourceNameComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.GenericXmlApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;

public class SpringUtils {
    private static final Logger logger = LoggerFactory.getLogger(SpringUtils.class);
    private static final String GLOBAL_SPRING_PROPERTY_SOURCE_NAME = "springPropertySource";

    public static SpringContext getSpringContext(List<Class<?>> annotatedClasses, ProjectContext project, List<ProjectContext> others) {
        PropertySource<?> source = SpringUtils.getGlobalPropertySource(project, others);
        PropertySourceContext psc = new PropertySourceContext(source, true);
        SpringContext context = new SpringContext();
        context.setPropertySourceContext(psc);
        context.setAnnotatedClasses(annotatedClasses);
        return context;
    }

    public static SpringContext getSpringContext(Class<?> annotatedClass, ProjectContext project, List<ProjectContext> others) {
        return SpringUtils.getSpringContext(CollectionUtils.asList(annotatedClass), project, others);
    }

    public static PropertySource<?> getGlobalPropertySource(ProjectContext project, ProjectContext other) {
        return SpringUtils.getGlobalPropertySource(project, Arrays.asList(other));
    }

    public static PropertySource<?> getGlobalPropertySource(ProjectContext project, List<ProjectContext> others) {
        return SpringUtils.getGlobalPropertySource(project, others, null);
    }

    public static PropertySource<?> getGlobalPropertySource(ProjectContext project, List<ProjectContext> others, Properties properties) {
        ProjectProperties projectProperties = ProjectUtils.loadProjectProperties(project);
        Properties existing = projectProperties.getPropertiesContext().getProperties();
        Properties combined = PropertyUtils.combine(existing, properties);
        projectProperties.getPropertiesContext().setProperties(combined);
        ArrayList<ProjectProperties> otherProjectProperties = new ArrayList<ProjectProperties>();
        for (ProjectContext other : CollectionUtils.toEmptyList(others)) {
            ProjectProperties opp = ProjectUtils.loadProjectProperties(other);
            otherProjectProperties.add(opp);
        }
        return SpringUtils.getGlobalPropertySource(projectProperties, otherProjectProperties);
    }

    public static PropertySource<?> getGlobalPropertySource(ProjectProperties project) {
        return SpringUtils.getGlobalPropertySource(project, null);
    }

    public static PropertySource<?> getGlobalPropertySource(ProjectProperties project, List<ProjectProperties> others) {
        ArrayList<ProjectProperties> list = new ArrayList<ProjectProperties>();
        list.add(project);
        if (!CollectionUtils.isEmpty(others)) {
            list.addAll(others);
            list.add(project);
        }
        return SpringUtils.getGlobalPropertySource(GLOBAL_SPRING_PROPERTY_SOURCE_NAME, list);
    }

    public static List<String> getIncludes(Environment env, String key, String defaultValue) {
        String includes = SpringUtils.getProperty(env, key, defaultValue);
        if (NullUtils.isNull(includes) || StringUtils.equals((String)includes, (String)"*")) {
            return new ArrayList<String>();
        }
        return CollectionUtils.getTrimmedListFromCSV(includes);
    }

    public static List<String> getIncludes(Environment env, String key) {
        return SpringUtils.getIncludes(env, key, null);
    }

    public static List<String> getExcludes(Environment env, String key, String defaultValue) {
        String excludes = SpringUtils.getProperty(env, key, defaultValue);
        if (NullUtils.isNullOrNone(excludes)) {
            return new ArrayList<String>();
        }
        return CollectionUtils.getTrimmedListFromCSV(excludes);
    }

    public static List<String> getExcludes(Environment env, String key) {
        return SpringUtils.getExcludes(env, key, null);
    }

    public static <T> T getInstance(Environment env, String key, Class<T> defaultValue) {
        String className = SpringUtils.getProperty(env, key, defaultValue.getCanonicalName());
        return ReflectionUtils.newInstance(className);
    }

    public static <T> T getInstance(Environment env, String key) {
        String className = SpringUtils.getProperty(env, key, null);
        return ReflectionUtils.newInstance(className);
    }

    public static List<String> getListFromCSV(Environment env, String key, String defaultValue) {
        String csv = SpringUtils.getProperty(env, key, defaultValue);
        return CollectionUtils.getTrimmedListFromCSV(csv);
    }

    @Deprecated
    public static List<PropertySource<?>> getPropertySources(SpringService service, Class<?> annotatedClass, String propertiesBeanName, Properties properties) {
        return SpringUtils.getPropertySources(annotatedClass, propertiesBeanName, properties);
    }

    public static PropertySource<?> getSinglePropertySource(Class<?> annotatedClass) {
        return SpringUtils.getSinglePropertySource(annotatedClass, null, null);
    }

    public static PropertySource<?> getSinglePropertySource(Class<?> annotatedClass, String propertiesBeanName, Properties properties) {
        List<PropertySource<?>> sources = SpringUtils.getPropertySources(annotatedClass, propertiesBeanName, properties);
        if (sources.size() > 1) {
            throw new IllegalStateException("More than one PropertySource was registered in the context");
        }
        return sources.get(0);
    }

    public static List<PropertySource<?>> getPropertySources(Class<?> annotatedClass, String propertiesBeanName, Properties properties) {
        ConfigurableApplicationContext parent = null;
        parent = properties == null ? SpringUtils.getConfigurableApplicationContext() : SpringUtils.getContextWithPreRegisteredBean(propertiesBeanName, properties);
        AnnotationConfigApplicationContext child = new AnnotationConfigApplicationContext();
        child.setParent((ApplicationContext)parent);
        child.register(new Class[]{annotatedClass});
        child.refresh();
        return SpringUtils.getPropertySources((ConfigurableApplicationContext)child);
    }

    @Deprecated
    public static List<PropertySource<?>> getPropertySources(SpringService service, String location, String mavenPropertiesBeanName, Properties mavenProperties) {
        return SpringUtils.getPropertySources(location, mavenPropertiesBeanName, mavenProperties);
    }

    public static List<PropertySource<?>> getPropertySources(String location, String mavenPropertiesBeanName, Properties mavenProperties) {
        String[] locationsArray = new String[]{location};
        ConfigurableApplicationContext parent = SpringUtils.getContextWithPreRegisteredBean(mavenPropertiesBeanName, mavenProperties);
        ClassPathXmlApplicationContext child = new ClassPathXmlApplicationContext(locationsArray, (ApplicationContext)parent);
        return SpringUtils.getPropertySources((ConfigurableApplicationContext)child);
    }

    public static Executable getSpringExecutable(Environment env, boolean skip, PropertySource<?> ps, List<Class<?>> annotatedClasses) {
        PropertySourceContext psc = new PropertySourceContext(ps, true);
        SpringContext context = new SpringContext();
        context.setAnnotatedClasses(annotatedClasses);
        context.setPropertySourceContext(psc);
        SpringExecutable se = new SpringExecutable();
        se.setService(new DefaultSpringService());
        se.setContext(context);
        se.setSkip(skip);
        return se;
    }

    public static int getInteger(Environment env, String key) {
        String value = SpringUtils.getProperty(env, key);
        return Integer.parseInt(value);
    }

    public static int getInteger(Environment env, String key, int defaultValue) {
        String value = SpringUtils.getProperty(env, key, Integer.toString(defaultValue));
        return Integer.parseInt(value);
    }

    public static long getLong(Environment env, String key) {
        String value = SpringUtils.getProperty(env, key);
        return Long.parseLong(value);
    }

    public static long getLong(Environment env, String key, long defaultValue) {
        String value = SpringUtils.getProperty(env, key, Long.toString(defaultValue));
        return Long.parseLong(value);
    }

    public static double getDouble(Environment env, String key) {
        String value = SpringUtils.getProperty(env, key);
        return Double.parseDouble(value);
    }

    public static double getDouble(Environment env, String key, double defaultValue) {
        String value = SpringUtils.getProperty(env, key, Double.toString(defaultValue));
        return Double.parseDouble(value);
    }

    public static long getMillis(Environment env, String key, String defaultValue) {
        String value = SpringUtils.getProperty(env, key, defaultValue);
        return FormatUtils.getMillis(value);
    }

    public static long getBytes(Environment env, String key, String defaultValue) {
        String value = SpringUtils.getProperty(env, key, defaultValue);
        return FormatUtils.getBytes(value);
    }

    public static long getBytes(Environment env, String key) {
        String value = SpringUtils.getProperty(env, key);
        return FormatUtils.getBytes(value);
    }

    public static File getFile(Environment env, String key) {
        String value = SpringUtils.getProperty(env, key);
        return new File(value);
    }

    public static boolean getBoolean(Environment env, String key, boolean defaultValue) {
        String value = SpringUtils.getProperty(env, key, Boolean.toString(defaultValue));
        return Boolean.parseBoolean(value);
    }

    public static boolean getBoolean(Environment env, String key) {
        String value = SpringUtils.getProperty(env, key);
        return Boolean.parseBoolean(value);
    }

    public static PropertySource<?> getGlobalPropertySource(String name, List<ProjectProperties> pps) {
        Properties source = PropertyUtils.load(pps);
        Properties globalSource = PropertyUtils.getGlobalProperties(source);
        logger.debug("Before prepareContextProperties()");
        PropertyUtils.debug(globalSource);
        PropertyUtils.prepareContextProperties(globalSource);
        logger.debug("After prepareContextProperties()");
        PropertyUtils.debug(globalSource);
        return new PropertiesPropertySource(name, globalSource);
    }

    public static PropertySource<?> getGlobalPropertySource(List<String> locations, String encoding) {
        Properties loaded = PropertyUtils.load(locations, encoding);
        Properties global = PropertyUtils.getGlobalProperties(loaded);
        PropertyUtils.prepareContextProperties(global);
        return new PropertiesPropertySource(GLOBAL_SPRING_PROPERTY_SOURCE_NAME, global);
    }

    public static SpringContext getSinglePropertySourceContext(ProjectContext context, String location) {
        PropertySource<?> source = SpringUtils.getGlobalPropertySource(context, location);
        return SpringUtils.getSinglePropertySourceContext(source);
    }

    public static SpringExecutable getSpringExecutable(ProjectContext project, String location, List<Class<?>> annotatedClasses) {
        SpringContext context = SpringUtils.getSinglePropertySourceContext(project, location);
        context.setAnnotatedClasses(annotatedClasses);
        SpringExecutable executable = new SpringExecutable();
        executable.setContext(context);
        return executable;
    }

    public static SpringExecutable getSpringExecutable(ProjectContext project, String location, Class<?> annotatedClass) {
        ArrayList classes = new ArrayList();
        classes.add(annotatedClass);
        return SpringUtils.getSpringExecutable(project, location, classes);
    }

    public static SpringContext getSinglePropertySourceContext(List<String> locations, String encoding) {
        PropertySource<?> source = SpringUtils.getGlobalPropertySource(locations, encoding);
        return SpringUtils.getSinglePropertySourceContext(source);
    }

    public static SpringContext getSinglePropertySourceContext(PropertySource<?> source) {
        PropertySourceContext psc = new PropertySourceContext(source, true);
        SpringContext context = new SpringContext();
        context.setPropertySourceContext(psc);
        return context;
    }

    public static PropertySource<?> getGlobalPropertySource(ProjectContext context, String ... locations) {
        ProjectProperties pp = ProjectUtils.loadProjectProperties(context);
        PropertiesContext pc = pp.getPropertiesContext();
        List<String> existingLocations = CollectionUtils.toEmptyList(pc.getLocations());
        if (locations != null) {
            for (String location : locations) {
                existingLocations.add(location);
            }
        }
        pc.setLocations(existingLocations);
        return SpringUtils.getGlobalPropertySource(pp);
    }

    public static PropertySource<?> getPropertySource(String name, List<ProjectProperties> pps) {
        Properties source = PropertyUtils.load(pps);
        PropertyUtils.prepareContextProperties(source);
        return new PropertiesPropertySource(name, source);
    }

    public static String getDefaultPropertyContextLocation(String gav) {
        Assert.hasText((String)gav, (String)"gav has no text");
        Project p = ProjectUtils.getProject(gav);
        return "classpath:" + Str.getPath(p.getGroupId()) + "/" + p.getArtifactId() + "-properties-context.xml";
    }

    public static void validateExists(List<String> locations) {
        StringBuilder sb = new StringBuilder();
        for (String location : locations) {
            if (LocationUtils.exists(location)) continue;
            sb.append("Location [" + location + "] does not exist\n");
        }
        if (sb.length() > 0) {
            throw new IllegalArgumentException(sb.toString());
        }
    }

    public static ConfigurableApplicationContext getContextWithPreRegisteredBeans(String id, String displayName, List<String> beanNames, List<Object> beans) {
        Assert.isTrue((beanNames.size() == beans.size() ? 1 : 0) != 0);
        GenericXmlApplicationContext appContext = new GenericXmlApplicationContext();
        if (!StringUtils.isBlank((String)id)) {
            appContext.setId(id);
        }
        if (!StringUtils.isBlank((String)displayName)) {
            appContext.setDisplayName(displayName);
        }
        appContext.refresh();
        ConfigurableListableBeanFactory factory = appContext.getBeanFactory();
        for (int i = 0; i < beanNames.size(); ++i) {
            String beanName = beanNames.get(i);
            Object bean = beans.get(i);
            logger.debug("Registering bean - [{}] -> [{}]", (Object)beanName, (Object)bean.getClass().getName());
            factory.registerSingleton(beanName, bean);
        }
        return appContext;
    }

    public static ConfigurableApplicationContext getConfigurableApplicationContext() {
        return new GenericXmlApplicationContext();
    }

    public static ConfigurableApplicationContext getContextWithPreRegisteredBeans(List<String> beanNames, List<Object> beans) {
        return SpringUtils.getContextWithPreRegisteredBeans(null, null, beanNames, beans);
    }

    public static void refreshQuietly(ConfigurableApplicationContext context) {
        if (context != null) {
            context.refresh();
        }
    }

    public static void closeQuietly(ConfigurableApplicationContext context) {
        if (context != null) {
            context.close();
        }
    }

    public static ConfigurableApplicationContext getContextWithPreRegisteredBean(String beanName, Object bean) {
        return SpringUtils.getContextWithPreRegisteredBeans(Arrays.asList(beanName), Arrays.asList(bean));
    }

    public static List<PropertySource<?>> getPropertySourcesFromAnnotatedClass(String annotatedClassName) {
        Class<?> annotatedClass = ReflectionUtils.getClass(annotatedClassName);
        return SpringUtils.getPropertySources(annotatedClass);
    }

    public static List<PropertySource<?>> getPropertySources(Class<?> annotatedClass) {
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext(new Class[]{annotatedClass});
        return SpringUtils.extractPropertySourcesAndClose((ConfigurableApplicationContext)context);
    }

    public static List<PropertySource<?>> extractPropertySourcesAndClose(ConfigurableApplicationContext context) {
        List<PropertySource<?>> sources = SpringUtils.getPropertySources(context);
        SpringUtils.closeQuietly(context);
        return sources;
    }

    public static List<PropertySource<?>> getPropertySources(String location) {
        GenericXmlApplicationContext context = new GenericXmlApplicationContext(new String[]{location});
        return SpringUtils.extractPropertySourcesAndClose((ConfigurableApplicationContext)context);
    }

    public static List<PropertySource<?>> getPropertySources(ConfigurableApplicationContext context) {
        return SpringUtils.getPropertySources(context, new PropertySourceNameComparator());
    }

    public static <T> Map<String, T> getAllBeans(List<String> locations, Class<T> type) {
        String[] locationsArray = locations.toArray(new String[locations.size()]);
        GenericXmlApplicationContext ctx = new GenericXmlApplicationContext(locationsArray);
        Map map = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)ctx, type);
        ctx.close();
        return map;
    }

    public static <T> Map<String, T> getAllBeans(String location, Class<T> type) {
        GenericXmlApplicationContext ctx = new GenericXmlApplicationContext(new String[]{location});
        Map map = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)ctx, type);
        ctx.close();
        return map;
    }

    public static <T> Map<String, T> getAllBeans(ConfigurableApplicationContext ctx, Class<T> type) {
        return BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)ctx, type);
    }

    public static List<PropertySource<?>> getPropertySources(ConfigurableApplicationContext context, Comparator<PropertySource<?>> comparator) {
        Map map = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)context, PropertySource.class);
        ArrayList list = new ArrayList();
        for (PropertySource source : map.values()) {
            list.add(source);
        }
        Collections.sort(list, comparator);
        return list;
    }

    public static List<PropertySource<?>> asList(PropertySource<?> ... sources) {
        ArrayList list = new ArrayList();
        if (sources == null) {
            return list;
        }
        for (PropertySource<?> element : sources) {
            if (element == null) continue;
            list.add(element);
        }
        return list;
    }

    public static void debug(ApplicationContext ctx) {
        logger.debug("------------------------ Spring Context ------------------------------");
        logger.debug("Id: [{}]", (Object)ctx.getId());
        logger.debug("Display Name: [{}]", (Object)ctx.getDisplayName());
        logger.debug("Application Name: [{}]", (Object)ctx.getApplicationName());
        logger.debug("----------------------------------------------------------------------");
        List<String> names = Arrays.asList(BeanFactoryUtils.beanNamesIncludingAncestors((ListableBeanFactory)ctx));
        List<String> columns = Arrays.asList("Name", "Type", "Hashcode");
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        Collections.sort(names);
        for (String name : names) {
            Object bean = ctx.getBean(name);
            String instance = bean == null ? "NULL" : bean.getClass().getSimpleName();
            String hashcode = bean == null ? "NULL" : Integer.toHexString(bean.hashCode());
            Object[] row = new Object[]{name, instance, hashcode};
            rows.add(row);
        }
        LoggerUtils.logTable(columns, rows, LoggerLevel.DEBUG, logger, true);
        logger.debug("----------------------------------------------------------------------");
    }

    public static void showPropertySources(List<PropertySource<?>> propertySources) {
        List<String> columns = Arrays.asList("Name", "Impl", "Source");
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        for (PropertySource<?> propertySource : propertySources) {
            String name = propertySource.getName();
            String impl = propertySource.getClass().getName();
            String source = propertySource.getSource().getClass().getName();
            Object[] row = new Object[]{name, impl, source};
            rows.add(row);
        }
        LoggerUtils.logTable(columns, rows, LoggerLevel.INFO, logger, true);
    }

    public static void showPropertySources(ConfigurableEnvironment env) {
        SpringUtils.showPropertySources(SpringUtils.getPropertySources(env));
    }

    public static String getProperty(Environment env, String key) {
        String value = env.getRequiredProperty(key);
        return env.resolveRequiredPlaceholders(value);
    }

    public static boolean exists(Environment env, String key) {
        return env.getProperty(key) != null;
    }

    public static String getProperty(Environment env, String key, String defaultValue) {
        if (defaultValue == null) {
            return SpringUtils.getProperty(env, key);
        }
        String value = env.getProperty(key);
        if (value == null) {
            return env.resolveRequiredPlaceholders(defaultValue);
        }
        return env.resolveRequiredPlaceholders(value);
    }

    public static Properties getAllEnumerableProperties(ConfigurableEnvironment env) {
        List<PropertySource<?>> sources = SpringUtils.getPropertySources(env);
        Collections.reverse(sources);
        PropertySourceConversionResult result = SpringUtils.convertEnumerablePropertySources(sources);
        return PropertyUtils.combine(result.getPropertiesList());
    }

    public static void reconfigurePropertySources(ConfigurableEnvironment env, String name, Properties properties) {
        SpringUtils.removeAllPropertySources(env);
        MutablePropertySources mps = env.getPropertySources();
        Assert.isTrue((mps.size() == 0 ? 1 : 0) != 0);
        PropertiesPropertySource pps = new PropertiesPropertySource(name, properties);
        mps.addFirst((PropertySource)pps);
    }

    public static void removeAllPropertySources(ConfigurableEnvironment env) {
        MutablePropertySources mps = env.getPropertySources();
        List<PropertySource<?>> sources = SpringUtils.getPropertySources(env);
        for (PropertySource<?> source : sources) {
            String name = source.getName();
            mps.remove(name);
        }
    }

    public static List<PropertySource<?>> getPropertySources(ConfigurableEnvironment env) {
        MutablePropertySources mps = env.getPropertySources();
        ArrayList sources = new ArrayList();
        for (PropertySource source : mps) {
            sources.add(source);
        }
        return sources;
    }

    public static PropertySourceConversionResult convertEnumerablePropertySources(List<PropertySource<?>> sources) {
        PropertySourceConversionResult result = new PropertySourceConversionResult();
        ArrayList<Properties> list = new ArrayList<Properties>();
        ArrayList converted = new ArrayList();
        ArrayList skipped = new ArrayList();
        for (PropertySource<?> source : sources) {
            logger.debug("Adding [{}]", (Object)source.getName());
            if (source instanceof EnumerablePropertySource) {
                EnumerablePropertySource eps = (EnumerablePropertySource)source;
                Properties sourceProperties = SpringUtils.convert(eps);
                list.add(sourceProperties);
                converted.add(source);
                continue;
            }
            logger.debug("Unable to obtain properties from property source [{}] -> [{}]", (Object)source.getName(), (Object)source.getClass().getName());
            skipped.add(source);
        }
        result.setConverted(converted);
        result.setSkipped(skipped);
        result.setPropertiesList(list);
        return result;
    }

    public static Properties convert(EnumerablePropertySource<?> source) {
        String[] names;
        Properties properties = new Properties();
        for (String name : names = source.getPropertyNames()) {
            Object object = source.getProperty(name);
            if (object != null) {
                String value = object.toString();
                properties.setProperty(name, value);
                continue;
            }
            logger.warn("Property [{}] is null", (Object)name);
        }
        return properties;
    }

    public static boolean isTrue(Environment env, String property) {
        String value = env.getProperty(property);
        if (StringUtils.isBlank((String)value)) {
            return false;
        }
        return new Boolean(value);
    }
}

