/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util;

import java.util.ArrayList;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.Mode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModeUtils {
    private static final Logger logger = LoggerFactory.getLogger(ModeUtils.class);

    public static final void validate(Mode mode, String msg) {
        ModeUtils.validate(mode, msg, msg);
    }

    public static final void validate(Mode mode, String msg, String errMsg) {
        ModeUtils.validate(mode, msg, null, errMsg);
    }

    public static final void validate(Mode mode, String msg, Object arg, String errMsg) {
        ModeUtils.validate(mode, msg, arg, null, errMsg);
    }

    public static final void validate(Mode mode, String msg, Object arg1, Object arg2, String errMsg) {
        ModeUtils.validate(mode, msg, ModeUtils.getArgs(arg1, arg2), errMsg);
    }

    public static final void validate(Mode mode, String msg, Object[] args, String errMsg) {
        switch (mode) {
            case IGNORE: {
                return;
            }
            case DEBUG: {
                logger.debug(msg, args);
                return;
            }
            case INFORM: {
                logger.info(msg, args);
                return;
            }
            case WARN: {
                logger.warn(msg, args);
                return;
            }
            case ERROR: {
                logger.error(msg, args);
                throw new IllegalStateException(errMsg);
            }
        }
        throw new IllegalArgumentException("Mode '" + (Object)((Object)mode) + "' is unknown");
    }

    protected static final Object[] getArgs(Object arg1, Object arg2) {
        if (arg1 == null && arg2 == null) {
            return null;
        }
        ArrayList<Object> args = new ArrayList<Object>();
        if (arg1 != null) {
            args.add(arg1);
        }
        if (arg2 != null) {
            args.add(arg2);
        }
        return CollectionUtils.toObjectArray(args);
    }
}

